<?php
///////////////////////////////////////////////////////////////////////////
// Created and developed by Greg Zemskov, Revisium Company
// Email: audit@revisium.com, http://revisium.com/ai/

// Commercial usage is not allowed without a license purchase or written permission of the author
// Source code and signatures usage is not allowed

// Certificated in Federal Institute of Industrial Property in 2012
// http://revisium.com/ai/i/mini_aibolit.jpg

////////////////////////////////////////////////////////////////////////////
// Запрещено использование скрипта в коммерческих целях без приобретения лицензии.
// Запрещено использование исходного кода скрипта и сигнатур.
//
// По вопросам приобретения лицензии обращайтесь в компанию "Ревизиум": http://www.revisium.com
// audit@revisium.com
// На скрипт получено авторское свидетельство в Роспатенте
// http://revisium.com/ai/i/mini_aibolit.jpg
///////////////////////////////////////////////////////////////////////////
ini_set('memory_limit', '1G');
ini_set('xdebug.max_nesting_level', 500);

//@mb_internal_encoding('');

$int_enc = @ini_get('mbstring.internal_encoding');
        
define('SHORT_PHP_TAG', strtolower(ini_get('short_open_tag')) == 'on' || strtolower(ini_get('short_open_tag')) == 1 ? true : false);

// Put any strong password to open the script from web
// Впишите вместо put_any_strong_password_here сложный пароль	 

define('PASS', '????????????????'); 

//////////////////////////////////////////////////////////////////////////

if (isCli()) {
	if (strpos('--eng', $argv[$argc - 1]) !== false) {
		  define('LANG', 'EN');  
	}
} else {
   define('NEED_REPORT', true);
}
	
if (!defined('LANG')) {
   define('LANG', 'EN');  
}	

// put 1 for expert mode, 0 for basic check and 2 for paranoic mode
// установите 1 для режима "Эксперта", 0 для быстрой проверки и 2 для параноидальной проверки (для лечения сайта) 
define('AI_EXPERT_MODE', 1); 

define('REPORT_MASK_PHPSIGN', 1);
define('REPORT_MASK_SPAMLINKS', 2);
define('REPORT_MASK_DOORWAYS', 4);
define('REPORT_MASK_SUSP', 8);
define('REPORT_MASK_CANDI', 16);
define('REPORT_MASK_WRIT', 32);
define('REPORT_MASK_FULL', REPORT_MASK_PHPSIGN | REPORT_MASK_DOORWAYS | REPORT_MASK_SUSP
/* <-- remove this line to enable "recommendations"  

| REPORT_MASK_SPAMLINKS 

 remove this line to enable "recommendations" --> */
);

define('AI_HOSTER', 0); 

define('AI_EXTRA_WARN', 0);

$defaults = array(
	'path' => dirname(__FILE__),
	'scan_all_files' => 0, // full scan (rather than just a .js, .php, .html, .htaccess)
	'scan_delay' => 0, // delay in file scanning to reduce system load
	'max_size_to_scan' => '600K',
	'site_url' => '', // website url
	'no_rw_dir' => 0,
    	'skip_ext' => '',
        'skip_cache' => false,
	'report_mask' => REPORT_MASK_FULL
);


define('DEBUG_MODE', 0);

define('AIBOLIT_START_TIME', time());

define('DIR_SEPARATOR', '/');

define('AIBOLIT_MAX_NUMBER', 200);

define('DOUBLECHECK_FILE', 'AI-BOLIT-DOUBLECHECK.php');

if ((isset($_SERVER['OS']) && stripos('Win', $_SERVER['OS']) !== false)/* && stripos('CygWin', $_SERVER['OS']) === false)*/) {
   define('DIR_SEPARATOR', '\\');
}

$g_SuspiciousFiles = array('cgi', 'pl', 'o', 'so', 'py', 'sh', 'phtml', 'php3', 'php4', 'php5', 'php6', 'php7', 'pht', 'shtml', 'susp', 'suspected');
$g_SensitiveFiles = array_merge(array('php', 'js', 'htaccess', 'html', 'htm', 'tpl', 'inc', 'css', 'txt', 'sql'), $g_SuspiciousFiles);
$g_CriticalFiles = array('php', 'htaccess', 'cgi', 'pl', 'o', 'so', 'py', 'sh', 'phtml', 'php3', 'php4', 'php5', 'php6', 'php7', 'pht', 'shtml', 'susp', 'suspected', 'infected', 'vir');
$g_CriticalEntries = '<\?php|<\?=|#!/usr|#!/bin|eval|assert|base64_decode|system|create_function|exec|popen|fwrite|fputs|file_get_|call_user_func|file_put_|\$_REQUEST|ob_start|\$_GET|\$_POST|\$_SERVER|\$_FILES|move|copy|array_|reg_replace|mysql_|chr|fsockopen|\$GLOBALS|sqliteCreateFunction';
$g_VirusFiles = array('js', 'html', 'htm', 'suspicious');
$g_VirusEntries = '<\s*script|<\s*iframe|<\s*object|<\s*embed|fromCharCode|setTimeout|setInterval|location\.|document\.|window\.|navigator\.|\$(this)\.';
$g_PhishFiles = array('js', 'html', 'htm', 'suspected', 'php', 'pht', 'php7');
$g_PhishEntries = '<\s*title|<\s*html|<\s*form|<\s*body|bank|account';
$g_ShortListExt = array('php', 'php3', 'php4', 'php5', 'php6', 'php7', 'pht', 'html', 'htm', 'phtml', 'shtml', 'khtml');

if (LANG == 'RU') {
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// RUSSIAN INTERFACE
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
$msg1 = "\"Отображать по _MENU_ записей\"";
$msg2 = "\"Ничего не найдено\"";
$msg3 = "\"Отображается c _START_ по _END_ из _TOTAL_ файлов\"";
$msg4 = "\"Нет файлов\"";
$msg5 = "\"(всего записей _MAX_)\"";
$msg6 = "\"Поиск:\"";
$msg7 = "\"Первая\"";
$msg8 = "\"Предыдущая\"";
$msg9 = "\"Следующая\"";
$msg10 = "\"Последняя\"";
$msg11 = "\": активировать для сортировки столбца по возрастанию\"";
$msg12 = "\": активировать для сортировки столбцов по убыванию\"";

define('AI_STR_001', 'Отчет сканера <a href="https://revisium.com/ai/">AI-Bolit</a> v@@VERSION@@:');
define('AI_STR_002', 'Обращаем внимание на то, что большинство CMS <b>без дополнительной защиты</b> рано или поздно <b>взламывают</b>.<p> Компания <a href="https://revisium.com/">"Ревизиум"</a> предлагает услугу превентивной защиты сайта от взлома с использованием уникальной <b>процедуры "цементирования сайта"</b>. Подробно на <a href="https://revisium.com/ru/client_protect/">странице услуги</a>. <p>Лучшее лечение &mdash; это профилактика.');
define('AI_STR_003', 'Не оставляйте файл отчета на сервере, и не давайте на него прямых ссылок с других сайтов. Информация из отчета может быть использована злоумышленниками для взлома сайта, так как содержит информацию о настройках сервера, файлах и каталогах.');
define('AI_STR_004', 'Путь');
define('AI_STR_005', 'Изменение свойств');
define('AI_STR_006', 'Изменение содержимого');
define('AI_STR_007', 'Размер');
define('AI_STR_008', 'Конфигурация PHP');
define('AI_STR_009', "Вы установили слабый пароль на скрипт AI-BOLIT. Укажите пароль не менее 8 символов, содержащий латинские буквы в верхнем и нижнем регистре, а также цифры. Например, такой <b>%s</b>");
define('AI_STR_010', "Сканер AI-Bolit запускается с паролем. Если это первый запуск сканера, вам нужно придумать сложный пароль и вписать его в файле ai-bolit.php в строке №34. <p>Например, <b>define('PASS', '%s');</b><p>
После этого откройте сканер в браузере, указав пароль в параметре \"p\". <p>Например, так <b>http://mysite.ru/ai-bolit.php?p=%s</b>. ");
define('AI_STR_011', 'Текущая директория не доступна для чтения скрипту. Пожалуйста, укажите права на доступ <b>rwxr-xr-x</b> или с помощью командной строки <b>chmod +r имя_директории</b>');
define('AI_STR_012', "Затрачено времени: <b>%s</b>. Сканирование начато %s, сканирование завершено %s");
define('AI_STR_013', 'Всего проверено %s директорий и %s файлов.');
define('AI_STR_014', '<div class="rep" style="color: #0000A0">Внимание, скрипт выполнил быструю проверку сайта. Проверяются только наиболее критические файлы, но часть вредоносных скриптов может быть не обнаружена. Пожалуйста, запустите скрипт из командной строки для выполнения полного тестирования. Подробнее смотрите в <a href="https://revisium.com/ai/faq.php">FAQ вопрос №10</a>.</div>');
define('AI_STR_015', '<div class="title">Критические замечания</div>');
define('AI_STR_016', 'Эти файлы могут быть вредоносными или хакерскими скриптами');
define('AI_STR_017', 'Вирусы и вредоносные скрипты не обнаружены.');
define('AI_STR_018', 'Эти файлы могут быть javascript вирусами');
define('AI_STR_019', 'Обнаружены сигнатуры исполняемых файлов unix и нехарактерных скриптов. Они могут быть вредоносными файлами');
define('AI_STR_020', 'Двойное расширение, зашифрованный контент или подозрение на вредоносный скрипт. Требуется дополнительный анализ');
define('AI_STR_021', 'Подозрение на вредоносный скрипт');
define('AI_STR_022', 'Символические ссылки (symlinks)');
define('AI_STR_023', 'Скрытые файлы');
define('AI_STR_024', 'Возможно, каталог с дорвеем');
define('AI_STR_025', 'Не найдено директорий c дорвеями');
define('AI_STR_026', 'Предупреждения');
define('AI_STR_027', 'Подозрение на мобильный редирект, подмену расширений или автовнедрение кода');
define('AI_STR_028', 'В не .php файле содержится стартовая сигнатура PHP кода. Возможно, там вредоносный код');
define('AI_STR_029', 'Дорвеи, реклама, спам-ссылки, редиректы');
define('AI_STR_030', 'Непроверенные файлы - ошибка чтения');
define('AI_STR_031', 'Невидимые ссылки. Подозрение на ссылочный спам');
define('AI_STR_032', 'Невидимые ссылки');
define('AI_STR_033', 'Отображены только первые ');
define('AI_STR_034', 'Подозрение на дорвей');
define('AI_STR_035', 'Скрипт использует код, который часто встречается во вредоносных скриптах');
define('AI_STR_036', 'Директории из файла .adirignore были пропущены при сканировании');
define('AI_STR_037', 'Версии найденных CMS');
define('AI_STR_038', 'Большие файлы (больше чем %s). Пропущено');
define('AI_STR_039', 'Не найдено файлов больше чем %s');
define('AI_STR_040', 'Временные файлы или файлы(каталоги) - кандидаты на удаление по ряду причин');
define('AI_STR_041', 'Потенциально небезопасно! Директории, доступные скрипту на запись');
define('AI_STR_042', 'Не найдено директорий, доступных на запись скриптом');
define('AI_STR_043', 'Использовано памяти при сканировании: ');
define('AI_STR_044', 'Просканированы только файлы, перечисленные в ' . DOUBLECHECK_FILE . '. Для полного сканирования удалите файл ' . DOUBLECHECK_FILE . ' и запустите сканер повторно.');
define('AI_STR_045', '<div class="rep">Внимание! Выполнена экспресс-проверка сайта. Просканированы только файлы с расширением .php, .js, .html, .htaccess. В этом режиме могут быть пропущены вирусы и хакерские скрипты в файлах с другими расширениями. Чтобы выполнить более тщательное сканирование, поменяйте значение настройки на <b>\'scan_all_files\' => 1</b> в строке 50 или откройте сканер в браузере с параметром full: <b><a href="ai-bolit.php?p=' . PASS . '&full">ai-bolit.php?p=' . PASS . '&full</a></b>. <p>Не забудьте перед повторным запуском удалить файл ' . DOUBLECHECK_FILE . '</div>');
define('AI_STR_050', 'Замечания и предложения по работе скрипта и не обнаруженные вредоносные скрипты присылайте на <a href="mailto:ai@revisium.com">ai@revisium.com</a>.<p>Также будем чрезвычайно благодарны за любые упоминания скрипта AI-Bolit на вашем сайте, в блоге, среди друзей, знакомых и клиентов. Ссылочку можно поставить на <a href="https://revisium.com/ai/">https://revisium.com/ai/</a>. <p>Если будут вопросы - пишите <a href="mailto:ai@revisium.com">ai@revisium.com</a>. ');
define('AI_STR_051', 'Отчет по ');
define('AI_STR_052', 'Эвристический анализ обнаружил подозрительные файлы. Проверьте их на наличие вредоносного кода.');
define('AI_STR_053', 'Много косвенных вызовов функции');
define('AI_STR_054', 'Подозрение на обфусцированные переменные');
define('AI_STR_055', 'Подозрительное использование массива глобальных переменных');
define('AI_STR_056', 'Дробление строки на символы');
define('AI_STR_057', 'Сканирование выполнено в экспресс-режиме. Многие вредоносные скрипты могут быть не обнаружены.<br> Рекомендуем проверить сайт в режиме "Эксперт" или "Параноидальный". Подробно описано в <a href="https://revisium.com/ai/faq.php">FAQ</a> и инструкции к скрипту.');
define('AI_STR_058', 'Обнаружены фишинговые страницы');

define('AI_STR_059', 'Мобильных редиректов');
define('AI_STR_060', 'Вредоносных скриптов');
define('AI_STR_061', 'JS Вирусов');
define('AI_STR_062', 'Фишинговых страниц');
define('AI_STR_063', 'Исполняемых файлов');
define('AI_STR_064', 'IFRAME вставок');
define('AI_STR_065', 'Пропущенных больших файлов');
define('AI_STR_066', 'Ошибок чтения файлов');
define('AI_STR_067', 'Зашифрованных файлов');
define('AI_STR_068', 'Подозрительных (эвристика)');
define('AI_STR_069', 'Символических ссылок');
define('AI_STR_070', 'Скрытых файлов');
define('AI_STR_072', 'Рекламных ссылок и кодов');
define('AI_STR_073', 'Пустых ссылок');
define('AI_STR_074', 'Сводный отчет');
define('AI_STR_075', 'Скрипт бесплатный только для личного некоммерческого использования. Есть <a href="https://revisium.com/ai/faq.php#faq11" target=_blank>коммерческая лицензия</a> (пункт №11).');

$tmp_str = <<<HTML_FOOTER
   <div class="disclaimer"><span class="vir">[!]</span> Отказ от гарантий: невозможно гарантировать обнаружение всех вредоносных скриптов. Поэтому разработчик сканера не несет ответственности за возможные последствия работы сканера AI-Bolit или неоправданные ожидания пользователей относительно функциональности и возможностей.
   </div>
   <div class="thanx">
      Замечания и предложения по работе скрипта, а также не обнаруженные вредоносные скрипты вы можете присылать на <a href="mailto:ai@revisium.com">ai@revisium.com</a>.<br/>
      Также будем чрезвычайно благодарны за любые упоминания сканера AI-Bolit на вашем сайте, в блоге, среди друзей, знакомых и клиентов. <br/>Ссылку можно поставить на страницу <a href="https://revisium.com/ai/">https://revisium.com/ai/</a>.<br/> 
     <p>Получить консультацию или задать вопросы можно по email <a href="mailto:ai@revisium.com">ai@revisium.com</a>.</p> 
	</div>
HTML_FOOTER;

define('AI_STR_076', $tmp_str);
define('AI_STR_077', "Подозрительные параметры времени изменения файла");
define('AI_STR_078', "Подозрительные атрибуты файла");
define('AI_STR_079', "Подозрительное местоположение файла");
define('AI_STR_080', "Обращаем внимание, что обнаруженные файлы не всегда являются вирусами и хакерскими скриптами. Сканер старается минимизировать число ложных обнаружений, но это не всегда возможно, так как найденный фрагмент может встречаться как во вредоносных скриптах, так и в обычных.");
define('AI_STR_081', "Уязвимости в скриптах");
define('AI_STR_082', "Добавленные файлы");
define('AI_STR_083', "Измененные файлы");
define('AI_STR_084', "Удаленные файлы");
define('AI_STR_085', "Добавленные каталоги");
define('AI_STR_086', "Удаленные каталоги");
define('AI_STR_087', "Изменения в файловой структуре");

$l_Offer =<<<OFFER
    <div>
	 <div class="crit" style="font-size: 17px;"><b>Внимание! Наш сканер обнаружил подозрительный или вредоносный код</b>.</div> 
	 <br/>Скорее всего, ваш сайт был взломан и заражен. Рекомендуем срочно <a href="https://revisium.com/ru/order/" target=_blank>обратиться за консультацией</a> к специалистам по информационной безопасности.
	</div>
	<br/>
	<div>
	   Пришлите нам отчет в архиве .zip на <a href="mailto:ai@revisium.com">ai@revisium.com</a> для проверки вашего сайта на вирусы и взлом.<p>
	   Компания "<a href="https://revisium.com/">Ревизиум</a>" - лечение сайта от вирусов и защита от взлома.
	   <p><hr size=1></p>
	   Также выполните дополнительный анализ новым <b><a href="http://rescan.pro/?utm=aibolit" target=_blank>веб-сканером ReScan.Pro</a></b>.
	</div>
	<br/>
	
    <div class="caution">@@CAUTION@@</div>
OFFER;

} else {
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ENGLISH INTERFACE
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
$msg1 = "\"Display _MENU_ records\"";
$msg2 = "\"Not found\"";
$msg3 = "\"Display from _START_ to _END_ of _TOTAL_ files\"";
$msg4 = "\"No files\"";
$msg5 = "\"(total _MAX_)\"";
$msg6 = "\"Filter/Search:\"";
$msg7 = "\"First\"";
$msg8 = "\"Previous\"";
$msg9 = "\"Next\"";
$msg10 = "\"Last\"";
$msg11 = "\": activate to sort row ascending order\"";
$msg12 = "\": activate to sort row descending order\"";

define('AI_STR_001', 'AI-Bolit v@@VERSION@@ Scan Report:');
define('AI_STR_002', '');
define('AI_STR_003', 'Caution! Do not leave either ai-bolit.php or report file on server and do not provide direct links to the report file. Report file contains sensitive information about your website which could be used by hackers. So keep it in safe place and don\'t leave on website!');
define('AI_STR_004', 'Path');
define('AI_STR_005', 'iNode Changed');
define('AI_STR_006', 'Modified');
define('AI_STR_007', 'Size');
define('AI_STR_008', 'PHP Info');
define('AI_STR_009', "Your password for AI-BOLIT is too weak. Password must be more than 8 character length, contain both latin letters in upper and lower case, and digits. E.g. <b>%s</b>");
define('AI_STR_010', "Open AI-BOLIT with password specified in the beggining of file in PASS variable. <br/>E.g. http://you_website.com/ai-bolit.php?p=<b>%s</b>");
define('AI_STR_011', 'Current folder is not readable. Please change permission for <b>rwxr-xr-x</b> or using command line <b>chmod +r folder_name</b>');
define('AI_STR_012', "<div class=\"rep\">%s malicious signatures known, %s virus signatures and other malicious code. Elapsed: <b>%s</b
>.<br/>Started: %s. Stopped: %s</div> ");
define('AI_STR_013', 'Scanned %s folders and %s files.');
define('AI_STR_014', '<div class="rep" style="color: #0000A0">Attention! Script has performed quick scan. It scans only .html/.js/.php files  in quick scan mode so some of malicious scripts might not be detected. <br>Please launch script from a command line thru SSH to perform full scan.');
define('AI_STR_015', '<div class="title">Critical</div>');
define('AI_STR_016', 'Shell script signatures detected. Might be a malicious or hacker\'s scripts');
define('AI_STR_017', 'Shell scripts signatures not detected.');
define('AI_STR_018', 'Javascript virus signatures detected:');
define('AI_STR_019', 'Unix executables signatures and odd scripts detected. They might be a malicious binaries or rootkits:');
define('AI_STR_020', 'Suspicious encoded strings, extra .php extention or external includes detected in PHP files. Might be a malicious or hacker\'s script:');
define('AI_STR_021', 'Might be a malicious or hacker\'s script:');
define('AI_STR_022', 'Symlinks:');
define('AI_STR_023', 'Hidden files:');
define('AI_STR_024', 'Files might be a part of doorway:');
define('AI_STR_025', 'Doorway folders not detected');
define('AI_STR_026', 'Warnings');
define('AI_STR_027', 'Malicious code in .htaccess (redirect to external server, extention handler replacement or malicious code auto-append):');
define('AI_STR_028', 'Non-PHP file has PHP signature. Check for malicious code:');
define('AI_STR_029', 'This script has black-SEO links or linkfarm. Check if it was installed by yourself:');
define('AI_STR_030', 'Reading error. Skipped.');
define('AI_STR_031', 'These files have invisible links, might be black-seo stuff:');
define('AI_STR_032', 'List of invisible links:');
define('AI_STR_033', 'Displayed first ');
define('AI_STR_034', 'Folders contained too many .php or .html files. Might be a doorway:');
define('AI_STR_035', 'Suspicious code detected. It\'s usually used in malicious scrips:');
define('AI_STR_036', 'The following list of files specified in .adirignore has been skipped:');
define('AI_STR_037', 'CMS found:');
define('AI_STR_038', 'Large files (greater than %s! Skipped:');
define('AI_STR_039', 'Files greater than %s not found');
define('AI_STR_040', 'Files recommended to be remove due to security reason:');
define('AI_STR_041', 'Potentially unsafe! Folders which are writable for scripts:');
define('AI_STR_042', 'Writable folders not found');
define('AI_STR_043', 'Memory used: ');
define('AI_STR_044', 'Quick scan through the files from ' . DOUBLECHECK_FILE . '. For full scan remove ' . DOUBLECHECK_FILE . ' and launch scanner once again.');
define('AI_STR_045', '<div class="notice"><span class="vir">[!]</span> Ai-BOLIT is working in quick scan mode, only .php, .html, .htaccess files will be checked. Change the following setting \'scan_all_files\' => 1 to perform full scanning.</b>. </div>');
define('AI_STR_050', "I'm sincerely appreciate reports for any bugs you may found in the script. Please email me: <a href=\"mailto:audit@revisium.com\">audit@revisium.com</a>.<p> Also I appriciate any reference to the script in your blog or forum posts. Thank you for the link to download page: <a href=\"https://revisium.com/aibo/\">https://revisium.com/aibo/</a>");
define('AI_STR_051', 'Report for ');
define('AI_STR_052', 'Heuristic Analyzer has detected suspicious files. Check if they are malware.');
define('AI_STR_053', 'Function called by reference');
define('AI_STR_054', 'Suspected for obfuscated variables');
define('AI_STR_055', 'Suspected for $GLOBAL array usage');
define('AI_STR_056', 'Abnormal split of string');
define('AI_STR_057', 'Scanning has been done in simple mode. It is strongly recommended to perform scanning in "Expert" mode. See readme.txt for details.');
define('AI_STR_058', 'Phishing pages detected:');

define('AI_STR_059', 'Mobile redirects');
define('AI_STR_060', 'Malware');
define('AI_STR_061', 'JS viruses');
define('AI_STR_062', 'Phishing pages');
define('AI_STR_063', 'Unix executables');
define('AI_STR_064', 'IFRAME injections');
define('AI_STR_065', 'Skipped big files');
define('AI_STR_066', 'Reading errors');
define('AI_STR_067', 'Encrypted files');
define('AI_STR_068', 'Suspicious (heuristics)');
define('AI_STR_069', 'Symbolic links');
define('AI_STR_070', 'Hidden files');
define('AI_STR_072', 'Adware and spam links');
define('AI_STR_073', 'Empty links');
define('AI_STR_074', 'Summary');
define('AI_STR_075', 'For non-commercial use only. Please, purchase the license for commercial usage of the scanner. Email us: ai@revisium.com');

$tmp_str =<<<HTML_FOOTER
		   <div class="disclaimer"><span class="vir">[!]</span> Disclaimer: We're not liable to you for any damages, including general, special, incidental or consequential damages arising out of the use or inability to use the script (including but not limited to loss of data or report being rendered inaccurate or failure of the script). There's no warranty for the program. Use at your own risk. 
		   </div>
		   <div class="thanx">
		      We're greatly appreciate for any references in the social networks, forums or blogs to our scanner AI-BOLIT <a href="https://revisium.com/aibo/">https://revisium.com/aibo/</a>.<br/> 
		     <p>Contact us via email if you have any questions regarding the scanner or need report analysis: <a href="mailto:ai@revisium.com">ai@revisium.com</a>.</p> 
			</div>
HTML_FOOTER;
define('AI_STR_076', $tmp_str);
define('AI_STR_077', "Suspicious file mtime and ctime");
define('AI_STR_078', "Suspicious file permissions");
define('AI_STR_079', "Suspicious file location");
define('AI_STR_081', "Vulnerable Scripts");
define('AI_STR_082', "Added files");
define('AI_STR_083', "Modified files");
define('AI_STR_084', "Deleted files");
define('AI_STR_085', "Added directories");
define('AI_STR_086', "Deleted directories");
define('AI_STR_087', "Integrity Check Report");

$l_Offer =<<<HTML_OFFER_EN
<div>
 <div class="crit" style="font-size: 17px;"><b>Attention! The scanner has detected malicious files.</b></div> 
 <br/>Most likely the website has been compromised. Please, <a href="https://revisium.com/en/contacts/" target=_blank>contact website security experts</a> or experienced webmaster as soon as possible to check the report or remove the malware from files.
 <p><hr size=1></p>
 Also, online website analysis is available using our new <b><a href="http://rescan.pro/?utm=aibo" target=_blank>ReScan.Pro Web Scanner</a></b>.
</div>
<br/>
<div>
   <a href="mailto:ai@revisium.com">ai@revisium.com</a>, <a href="https://revisium.com/en/contacts/">https://revisium.com/en/home/</a>
</div>
<div class="caution">@@CAUTION@@</div>
HTML_OFFER_EN;

define('AI_STR_080', "Notice! Some of detected files may not contain malicious code. Scanner tries to minimize a number of false positives, but sometimes it's impossible, because same piece of code may be used either in malware or in normal scripts.");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

$l_Template =<<<MAIN_PAGE
<html>
<head>
<!-- revisium.com/ai/ -->
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" >
<META NAME="ROBOTS" CONTENT="NOINDEX,NOFOLLOW">
<title>@@HEAD_TITLE@@</title>
<style type="text/css" title="currentStyle">
	@import "https://revisium.com/extra/media/css/demo_page2.css";
	@import "https://revisium.com/extra/media/css/jquery.dataTables2.css";
</style>

<script type="text/javascript" language="javascript" src="https://yandex.st/jquery/2.1.0/jquery.min.js"></script>
<script type="text/javascript" language="javascript" src="https://datatables.net/download/build/jquery.dataTables.js"></script>

<style type="text/css">
 body 
 {
   font-family: Tahoma;
   color: #5a5a5a;
   background: #FFFFFF;
   font-size: 14px;
   margin: 20px;
   padding: 0;
 }

.header
 {
   font-size: 34px;
   margin: 0 0 10px 0;
 }

 .hidd
 {
    display: none;
 }
 
 .ok
 {
    color: green;
 }
 
 .line_no
 {
   -webkit-border-radius: 6px;
   -moz-border-radius: 6px;
   border-radius: 6px;

   background: #DAF2C1;
   padding: 2px 5px 2px 5px;
   margin: 0 5px 0 5px;
 }
 
 .credits_header 
 {
  -webkit-border-radius: 6px;
   -moz-border-radius: 6px;
   border-radius: 6px;

   background: #F2F2F2;
   padding: 10px;
   font-size: 11px;
    margin: 0 0 10px 0;
 }
 
 .marker
 {
    color: #FF0090;
	font-weight: 100;
	background: #FF0090;
	padding: 2px 0px 2px 0px;
	width: 2px;
 }
 
 .title
 {
   font-size: 24px;
   margin: 20px 0 10px 0;
   color: #9CA9D1;
}

.summary 
{
  float: left;
  width: 500px;
}

.summary TD
{
  font-size: 12px;
  border-bottom: 1px solid #F0F0F0;
  font-weight: 700;
  padding: 10px 0 10px 0;
}
 
.crit, .vir
{
  color: #D84B55;
}

.intitem
{
  color:#4a6975;
}

.spacer
{
   margin: 0 0 50px 0;
   clear:both;
}

.warn
{
  color: #F6B700;
}

.clear
{
   clear: both;
}

.offer
{
  -webkit-border-radius: 6px;
   -moz-border-radius: 6px;
   border-radius: 6px;

   width: 500px;
   background: #ECF7DE;
   color: #747474;
   font-size: 11px;
   font-family: Arial;
   padding: 20px;
   margin: 20px 0 0 500px;
   
   font-size: 16px;
}
 
.flist
{
   font-family: Arial;
}

.flist TD
{
   font-size: 11px;
   padding: 5px;
}

.flist TH
{
   font-size: 12px;
   height: 30px;
   padding: 5px;
   background: #CEE9EF;
}


.it
{
   font-size: 14px;
   font-weight: 100;
   margin-top: 10px;
}

.crit .it A {
   color: #E50931; 
   line-height: 25px;
   text-decoration: none;
}

.warn .it A {
   color: #F2C900; 
   line-height: 25px;
   text-decoration: none;
}



.details
{
   font-family: Calibri;
   font-size: 12px;
   margin: 10px 10px 10px 0px;
}

.crit .details
{
   color: #A08080;
}

.warn .details
{
   color: #808080;
}

.details A
{
  color: #FFF;
  font-weight: 700;
  text-decoration: none;
  padding: 2px;
  background: #E5CEDE;
  -webkit-border-radius: 7px;
   -moz-border-radius: 7px;
   border-radius: 7px;
}

.details A:hover
{
   background: #A0909B;
}

.ctd
{
   margin: 10px 0px 10px 0;
   align:center;
}

.ctd A 
{
   color: #0D9922;
}

.disclaimer
{
   color: darkgreen;
   margin: 10px 10px 10px 0;
}

.note_vir
{
   margin: 10px 0 10px 0;
   //padding: 10px;
   color: #FF4F4F;
   font-size: 15px;
   font-weight: 700;
   clear:both;
  
}

.note_warn
{
   margin: 10px 0 10px 0;
   color: #F6B700;
   font-size: 15px;
   font-weight: 700;
   clear:both;
}

.note_int
{
   margin: 10px 0 10px 0;
   color: #60b5d6;
   font-size: 15px;
   font-weight: 700;
   clear:both;
}

.updateinfo
{
  color: #FFF;
  text-decoration: none;
  background: #E5CEDE;
  -webkit-border-radius: 7px;
   -moz-border-radius: 7px;
   border-radius: 7px;

  margin: 10px 0 10px 0px;   
  padding: 10px;
}


.caution
{
  color: #EF7B75;
  text-decoration: none;
  margin: 20px 0 0px 0px;   
  font-size: 12px;
}

.footer
{
  color: #303030;
  text-decoration: none;
  background: #F4F4F4;
  -webkit-border-radius: 7px;
   -moz-border-radius: 7px;
   border-radius: 7px;

  margin: 80px 0 10px 0px;   
  padding: 10px;
}

.rep
{
  color: #303030;
  text-decoration: none;
  background: #94DDDB;
  -webkit-border-radius: 7px;
   -moz-border-radius: 7px;
   border-radius: 7px;

  margin: 10px 0 10px 0px;   
  padding: 10px;
  font-size: 12px;
}

</style>

</head>
<body>

<div class="header">@@MAIN_TITLE@@ @@PATH_URL@@ (@@MODE@@)</div>
<div class="credits_header">@@CREDITS@@</div>
<div class="details_header">
   @@STAT@@<br/>
   @@SCANNED@@ @@MEMORY@@.
 </div>

 @@WARN_QUICK@@
 
 <div class="summary">
@@SUMMARY@@
 </div>
 
 <div class="offer">
@@OFFER@@
 </div>
  
 <div class="clear"></div>
 
 @@MAIN_CONTENT@@
 
	<div class="footer">
	@@FOOTER@@
	</div>
	
<script language="javascript">

function hsig(id) {
  var divs = document.getElementsByTagName("tr");
  for(var i = 0; i < divs.length; i++){
     
     if (divs[i].getAttribute('o') == id) {
        divs[i].innerHTML = '';
     }
  }

  return false;
}


$(document).ready(function(){
    $('#table_crit').dataTable({
       "aLengthMenu": [[100 , 500, -1], [100, 500, "All"]],
       "aoColumns": [
                                     {"iDataSort": 7, "width":"70%"},
                                     {"iDataSort": 5},
                                     {"iDataSort": 6},
                                     {"bSortable": true},
                                     {"bVisible": false},
                                     {"bVisible": false},
                                     {"bVisible": false},
                                     {"bVisible": false}
                     ],
		"paging": true,
       "iDisplayLength": 500,
		"oLanguage": {
			"sLengthMenu": $msg1,
			"sZeroRecords": $msg2,
			"sInfo": $msg3,
			"sInfoEmpty": $msg4,
			"sInfoFiltered": $msg5,
			"sSearch":       $msg6,
			"sUrl":          "",
			"oPaginate": {
				"sFirst": $msg7,
				"sPrevious": $msg8,
				"sNext": $msg9,
				"sLast": $msg10
			},
			"oAria": {
				"sSortAscending": $msg11,
				"sSortDescending": $msg12	
			}
		}

     } );

});

$(document).ready(function(){
    $('#table_vir').dataTable({
       "aLengthMenu": [[100 , 500, -1], [100, 500, "All"]],
		"paging": true,
       "aoColumns": [
                                     {"iDataSort": 7, "width":"70%"},
                                     {"iDataSort": 5},
                                     {"iDataSort": 6},
                                     {"bSortable": true},
                                     {"bVisible": false},
                                     {"bVisible": false},
                                     {"bVisible": false},
                                     {"bVisible": false}
                     ],
       "iDisplayLength": 500,
		"oLanguage": {
			"sLengthMenu": $msg1,
			"sZeroRecords": $msg2,
			"sInfo": $msg3,
			"sInfoEmpty": $msg4,
			"sInfoFiltered": $msg5,
			"sSearch":       $msg6,
			"sUrl":          "",
			"oPaginate": {
				"sFirst": $msg7,
				"sPrevious": $msg8,
				"sNext": $msg9,
				"sLast": $msg10
			},
			"oAria": {
				"sSortAscending":  $msg11,
				"sSortDescending": $msg12	
			}
		},

     } );

});

if ($('#table_warn0')) {
    $('#table_warn0').dataTable({
       "aLengthMenu": [[100 , 500, -1], [100, 500, "All"]],
		"paging": true,
       "aoColumns": [
                                     {"iDataSort": 7, "width":"70%"},
                                     {"iDataSort": 5},
                                     {"iDataSort": 6},
                                     {"bSortable": true},
                                     {"bVisible": false},
                                     {"bVisible": false},
                                     {"bVisible": false},
                                     {"bVisible": false}
                     ],
			         "iDisplayLength": 500,
			  		"oLanguage": {
			  			"sLengthMenu": $msg1,
			  			"sZeroRecords": $msg2,
			  			"sInfo": $msg3,
			  			"sInfoEmpty": $msg4,
			  			"sInfoFiltered": $msg5,
			  			"sSearch":       $msg6,
			  			"sUrl":          "",
			  			"oPaginate": {
			  				"sFirst": $msg7,
			  				"sPrevious": $msg8,
			  				"sNext": $msg9,
			  				"sLast": $msg10
			  			},
			  			"oAria": {
			  				"sSortAscending":  $msg11,
			  				"sSortDescending": $msg12	
			  			}
		}

     } );
}

if ($('#table_warn1')) {
    $('#table_warn1').dataTable({
       "aLengthMenu": [[100 , 500, -1], [100, 500, "All"]],
		"paging": true,
       "aoColumns": [
                                     {"iDataSort": 7, "width":"70%"},
                                     {"iDataSort": 5},
                                     {"iDataSort": 6},
                                     {"bSortable": true},
                                     {"bVisible": false},
                                     {"bVisible": false},
                                     {"bVisible": false},
                                     {"bVisible": false}
                     ],
			         "iDisplayLength": 500,
			  		"oLanguage": {
			  			"sLengthMenu": $msg1,
			  			"sZeroRecords": $msg2,
			  			"sInfo": $msg3,
			  			"sInfoEmpty": $msg4,
			  			"sInfoFiltered": $msg5,
			  			"sSearch":       $msg6,
			  			"sUrl":          "",
			  			"oPaginate": {
			  				"sFirst": $msg7,
			  				"sPrevious": $msg8,
			  				"sNext": $msg9,
			  				"sLast": $msg10
			  			},
			  			"oAria": {
			  				"sSortAscending":  $msg11,
			  				"sSortDescending": $msg12	
			  			}
		}

     } );
}


</script>
<!-- @@SERVICE_INFO@@  -->
 </body>
</html>
MAIN_PAGE;

$g_AiBolitAbsolutePath = dirname(__FILE__);

if (file_exists($g_AiBolitAbsolutePath . '/ai-design.html')) {
  $l_Template = file_get_contents($g_AiBolitAbsolutePath . '/ai-design.html');
}

$l_Template = str_replace('@@MAIN_TITLE@@', AI_STR_001, $l_Template);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//BEGIN_SIG 13/08/2017 04:06:53
$g_DBShe = unserialize(base64_decode("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"));
$gX_DBShe = unserialize(base64_decode("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"));
$g_FlexDBShe = unserialize(base64_decode("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"));
$gX_FlexDBShe = unserialize(base64_decode("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"));
$gXX_FlexDBShe = unserialize(base64_decode("YTo1NjQ6e2k6MDtzOjUyOiJtYWlsXHMqXChcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbIjtpOjE7czoxNDoiQk9UTkVUXHMrUEFORUwiO2k6MjtzOjE4OiI9PVxzKlsnIl00NlwuMjI5XC4iO2k6MztzOjE4OiI9PVxzKlsnIl05MVwuMjQzXC4iO2k6NDtzOjU6IkpUZXJtIjtpOjU7czo1OiJPbmV0NyI7aTo2O3M6OToiXCRwYXNzX3VwIjtpOjc7czo1OiJ4Q2VkeiI7aTo4O3M6MTE2OiJpZlxzKlwoXHMqZnVuY3Rpb25fZXhpc3RzXHMqXChccypbJyJdezAsMX1cYihmdHBfZXhlY3xzeXN0ZW18c2hlbGxfZXhlY3xwYXNzdGhydXxwb3Blbnxwcm9jX29wZW4pWyciXXswLDF9XHMqXClccypcKSI7aTo5O3M6Mjc6IlwkT09PLis/PVxzKnVybGRlY29kZVxzKlwoPyI7aToxMDtzOjM4OiJzdHJlYW1fc29ja2V0X2NsaWVudFxzKlwoXHMqWyciXXRjcDovLyI7aToxMTtzOjE1OiJwY250bF9leGVjXHMqXCgiO2k6MTI7czozMToiPVxzKmFycmF5X21hcFxzKlwoP1xzKnN0cnJldlxzKiI7aToxMztzOjMyOiJzdHJfaXJlcGxhY2VccypcKD9ccypbJyJdPC9oZWFkPiI7aToxNDtzOjIzOiJjb3B5XHMqXChccypbJyJdaHR0cDovLyI7aToxNTtzOjE5MDoibW92ZV91cGxvYWRlZF9maWxlXHMqXCg/XHMqXCRfRklMRVNcW1xzKlsnIl17MCwxfWZpbGVuYW1lWyciXXswLDF9XHMqXF1cW1xzKlsnIl17MCwxfXRtcF9uYW1lWyciXXswLDF9XHMqXF1ccyosXHMqXCRfRklMRVNcW1xzKlsnIl17MCwxfWZpbGVuYW1lWyciXXswLDF9XHMqXF1cW1xzKlsnIl17MCwxfW5hbWVbJyJdezAsMX1ccypcXSI7aToxNjtzOjI4OiJlY2hvXHMqXCg/XHMqWyciXU5PIEZJTEVbJyJdIjtpOjE3O3M6MTU6IlsnIl0vXC5cKi9lWyciXSI7aToxODtzOjcwOiJlY2hvXHMrc3RyaXBzbGFzaGVzXHMqXChccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbIjtpOjE5O3M6MTU6Ii91c3Ivc2Jpbi9odHRwZCI7aToyMDtzOjcwOiI9XHMqXCRHTE9CQUxTXFtccypbJyJdXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpWyciXVxzKlxdIjtpOjIxO3M6MTU6IlwkYXV0aF9wYXNzXHMqPSI7aToyMjtzOjI5OiJlY2hvXHMrWyciXXswLDF9Z29vZFsnIl17MCwxfSI7aToyMztzOjIyOiJldmFsXHMqXChccypnZXRfb3B0aW9uIjtpOjI0O3M6ODA6IldCU19ESVJccypcLlxzKlsnIl17MCwxfXRlbXAvWyciXXswLDF9XHMqXC5ccypcJGFjdGl2ZUZpbGVccypcLlxzKlsnIl17MCwxfVwudG1wIjtpOjI1O3M6ODM6Im1vdmVfdXBsb2FkZWRfZmlsZVxzKlwoXHMqXCRfRklMRVNcW1snIl1bYS16QS1aMC05X10rWyciXVxdXFtbJyJddG1wX25hbWVbJyJdXF1ccyosIjtpOjI2O3M6ODE6Im1haWxcKFwkX1BPU1RcW1snIl17MCwxfWVtYWlsWyciXXswLDF9XF0sXHMqXCRfUE9TVFxbWyciXXswLDF9c3ViamVjdFsnIl17MCwxfVxdLCI7aToyNztzOjc3OiJtYWlsXHMqXChcJGVtYWlsXHMqLFxzKlsnIl17MCwxfT1cP1VURi04XD9CXD9bJyJdezAsMX1cLmJhc2U2NF9lbmNvZGVcKFwkZnJvbSI7aToyODtzOjY5OiJcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxzKlxbXHMqW2EtekEtWjAtOV9dK1xzKlxdXCgiO2k6Mjk7czoxOToiWyciXS9cZCsvXFthLXpcXVwqZSI7aTozMDtzOjM4OiJKUmVzcG9uc2U6OnNldEJvZHlccypcKFxzKnByZWdfcmVwbGFjZSI7aTozMTtzOjYyOiJAP2ZpbGVfcHV0X2NvbnRlbnRzXChcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKSI7aTozMjtzOjkxOiJtYWlsXChccypzdHJpcHNsYXNoZXNcKFwkdG9cKVxzKixccypzdHJpcHNsYXNoZXNcKFwkc3ViamVjdFwpXHMqLFxzKnN0cmlwc2xhc2hlc1woXCRtZXNzYWdlIjtpOjMzO3M6NjM6IlwkW2EtekEtWjAtOV9dK1xzKlwoXHMqXCRbYS16QS1aMC05X10rXHMqXChccypcJFthLXpBLVowLTlfXStcKCI7aTozNDtzOjIzOiJpc193cml0YWJsZT1pc193cml0YWJsZSI7aTozNTtzOjM4OiJAbW92ZV91cGxvYWRlZF9maWxlXChccypcJHVzZXJmaWxlX3RtcCI7aTozNjtzOjI2OiJleGl0XChcKTpleGl0XChcKTpleGl0XChcKSI7aTozNztzOjY3OiJcYihpbmNsdWRlfGluY2x1ZGVfb25jZXxyZXF1aXJlfHJlcXVpcmVfb25jZSlccypcKD9ccypbJyJdL3Zhci90bXAvIjtpOjM4O3M6MTc6Ij1ccypbJyJdL3Zhci90bXAvIjtpOjM5O3M6NTk6IlwoXHMqXCRzZW5kXHMqLFxzKlwkc3ViamVjdFxzKixccypcJG1lc3NhZ2VccyosXHMqXCRoZWFkZXJzIjtpOjQwO3M6ODM6IlxiKGZ0cF9leGVjfHN5c3RlbXxzaGVsbF9leGVjfHBhc3N0aHJ1fHBvcGVufHByb2Nfb3BlbilcKFsnIl1sd3AtZG93bmxvYWRccytodHRwOi8vIjtpOjQxO3M6MTAxOiJzdHJfcmVwbGFjZVwoWyciXS5bJyJdXHMqLFxzKlsnIl0uWyciXVxzKixccypzdHJfcmVwbGFjZVwoWyciXS5bJyJdXHMqLFxzKlsnIl0uWyciXVxzKixccypzdHJfcmVwbGFjZSI7aTo0MjtzOjM2OiIvYWRtaW4vY29uZmlndXJhdGlvblwucGhwL2xvZ2luXC5waHAiO2k6NDM7czo3MToic2VsZWN0XHMqY29uZmlndXJhdGlvbl9pZCxccytjb25maWd1cmF0aW9uX3RpdGxlLFxzK2NvbmZpZ3VyYXRpb25fdmFsdWUiO2k6NDQ7czo1MDoidXBkYXRlXHMqY29uZmlndXJhdGlvblxzK3NldFxzK2NvbmZpZ3VyYXRpb25fdmFsdWUiO2k6NDU7czozNzoic2VsZWN0XHMqbGFuZ3VhZ2VzX2lkLFxzK25hbWUsXHMrY29kZSI7aTo0NjtzOjUyOiJjXC5sZW5ndGhcKTt9cmV0dXJuXHMqXFxbJyJdXFxbJyJdO31pZlwoIWdldENvb2tpZVwoIjtpOjQ3O3M6NDU6ImlmXChmaWxlX3B1dF9jb250ZW50c1woXCRpbmRleF9wYXRoLFxzKlwkY29kZSI7aTo0ODtzOjM2OiJleGVjXHMre1snIl0vYmluL3NoWyciXX1ccytbJyJdLWJhc2giO2k6NDk7czo1MDoiPGlmcmFtZVxzK3NyYz1bJyJdaHR0cHM6Ly9kb2NzXC5nb29nbGVcLmNvbS9mb3Jtcy8iO2k6NTA7czoyMjoiLFsnIl08XD9waHBcXG5bJyJdXC5cJCI7aTo1MTtzOjcyOiI8XD9waHBccytcYihpbmNsdWRlfGluY2x1ZGVfb25jZXxyZXF1aXJlfHJlcXVpcmVfb25jZSlccypcKFxzKlsnIl0vaG9tZS8iO2k6NTI7czoyMjoieHJ1bWVyX3NwYW1fbGlua3NcLnR4dCI7aTo1MztzOjMzOiJDb21maXJtXHMrVHJhbnNhY3Rpb25ccytQYXNzd29yZDoiO2k6NTQ7czo3NzoiYXJyYXlfbWVyZ2VcKFwkZXh0XHMqLFxzKmFycmF5XChbJyJdd2Vic3RhdFsnIl0sWyciXWF3c3RhdHNbJyJdLFsnIl10ZW1wb3JhcnkiO2k6NTU7czo5MjoiXGIoZnRwX2V4ZWN8c3lzdGVtfHNoZWxsX2V4ZWN8cGFzc3RocnV8cG9wZW58cHJvY19vcGVuKVwoWyciXW15c3FsZHVtcFxzKy1oXHMrbG9jYWxob3N0XHMrLXUiO2k6NTY7czoyODoiTW90aGVyWyciXXNccytNYWlkZW5ccytOYW1lOiI7aTo1NztzOjM5OiJsb2NhdGlvblwucmVwbGFjZVwoXFxbJyJdXCR1cmxfcmVkaXJlY3QiO2k6NTg7czozNjoiY2htb2RcKGRpcm5hbWVcKF9fRklMRV9fXCksXHMqMDUxMVwpIjtpOjU5O3M6ODU6IlxiKGZ0cF9leGVjfHN5c3RlbXxzaGVsbF9leGVjfHBhc3N0aHJ1fHBvcGVufHByb2Nfb3BlbilcKFsnIl17MCwxfWN1cmxccystT1xzK2h0dHA6Ly8iO2k6NjA7czoyOToiXClcKSxQSFBfVkVSU0lPTixtZDVfZmlsZVwoXCQiO2k6NjE7czozNDoiXCRxdWVyeVxzKyxccytbJyJdZnJvbSUyMGpvc191c2VycyI7aTo2MjtzOjE3OiJcYmV2YWxcKFsnIl1ccyovLyI7aTo2MztzOjE4OiJcYmV2YWxcKFsnIl1ccyovXCoiO2k6NjQ7czoxMDQ6IlwkW2EtekEtWjAtOV9dK1xzKj1cJFthLXpBLVowLTlfXStccypcKFwkW2EtekEtWjAtOV9dK1xzKixccypcJFthLXpBLVowLTlfXStccypcKFsnIl1ccyp7XCRbYS16QS1aMC05X10rIjtpOjY1O3M6MzE6IiFlcmVnXChbJyJdXF5cKHVuc2FmZV9yYXdcKVw/XCQiO2k6NjY7czozNToiXCRiYXNlX2RvbWFpblxzKj1ccypnZXRfYmFzZV9kb21haW4iO2k6Njc7czo5OiJzZXhzZXhzZXgiO2k6Njg7czoyMzoiXCt1bmlvblwrc2VsZWN0XCswLDAsMCwiO2k6Njk7czozNzoiY29uY2F0XCgweDIxN2UscGFzc3dvcmQsMHgzYSx1c2VybmFtZSI7aTo3MDtzOjM0OiJncm91cF9jb25jYXRcKDB4MjE3ZSxwYXNzd29yZCwweDNhIjtpOjcxO3M6NTc6IlwqL1xzKlxiKGluY2x1ZGV8aW5jbHVkZV9vbmNlfHJlcXVpcmV8cmVxdWlyZV9vbmNlKVxzKi9cKiI7aTo3MjtzOjg6ImFiYWtvL0FPIjtpOjczO3M6NDg6ImlmXChccypzdHJwb3NcKFxzKlwkdmFsdWVccyosXHMqXCRtYXNrXHMqXClccypcKSI7aTo3NDtzOjEwNjoidW5saW5rXChccypcJF9TRVJWRVJcW1xzKlsnIl17MCwxfURPQ1VNRU5UX1JPT1RbJyJdezAsMX1cXVxzKlwuXHMqWyciXXswLDF9L2Fzc2V0cy9jYWNoZS90ZW1wL0ZpbGVTZXR0aW5ncyI7aTo3NTtzOjM4OiJzZXRUaW1lb3V0XChccypbJyJdbG9jYXRpb25cLnJlcGxhY2VcKCI7aTo3NjtzOjQzOiJzdHJwb3NcKFwkaW1ccyosXHMqWyciXTxcP1snIl1ccyosXHMqXCRpXCsxIjtpOjc3O3M6MjA6IlwkX1JFUVVFU1RcW1snIl1sYWxhIjtpOjc4O3M6MjM6IjBccypcKFxzKmd6dW5jb21wcmVzc1woIjtpOjc5O3M6MTU6Imd6aW5mbGF0ZVwoXChcKCI7aTo4MDtzOjQyOiJcJGtleVxzKj1ccypcJF9HRVRcW1snIl17MCwxfXFbJyJdezAsMX1cXTsiO2k6ODE7czoyNzoic3RybGVuXChccypcJHBhdGhUb0RvclxzKlwpIjtpOjgyO3M6NjQ6Imlzc2V0XChccypcJF9DT09LSUVcW1xzKm1kNVwoXHMqXCRfU0VSVkVSXFtccypbJyJdezAsMX1IVFRQX0hPU1QiO2k6ODM7czoyNzoiQGNoZGlyXChccypcJF9QT1NUXFtccypbJyJdIjtpOjg0O3M6ODQ6Ii9pbmRleFwucGhwXD9vcHRpb249Y29tX2NvbnRlbnQmdmlldz1hcnRpY2xlJmlkPVsnIl1cLlwkcG9zdFxbWyciXXswLDF9aWRbJyJdezAsMX1cXSI7aTo4NTtzOjU1OiJcJG91dFxzKlwuPVxzKlwkdGV4dHtccypcJGlccyp9XHMqXF5ccypcJGtleXtccypcJGpccyp9IjtpOjg2O3M6OToiTDNaaGNpOTNkIjtpOjg3O3M6NDc6InN0cnRvbG93ZXJcKFxzKnN1YnN0clwoXHMqXCR1c2VyX2FnZW50XHMqLFxzKjAsIjtpOjg4O3M6NDQ6ImNobW9kXChccypcJFtccyVcLkBcLVwrXChcKS9cd10rP1xzKixccyowNDA0IjtpOjg5O3M6NDQ6ImNobW9kXChccypcJFtccyVcLkBcLVwrXChcKS9cd10rP1xzKixccyowNzU1IjtpOjkwO3M6NDI6IkB1bWFza1woXHMqMDc3N1xzKiZccyp+XHMqXCRmaWxlcGVybWlzc2lvbiI7aTo5MTtzOjIzOiJbJyJdXHMqXHxccyovYmluL3NoWyciXSI7aTo5MjtzOjE2OiI7XHMqL2Jpbi9zaFxzKi1pIjtpOjkzO3M6NDE6ImlmXHMqXChmdW5jdGlvbl9leGlzdHNcKFxzKlsnIl1wY250bF9mb3JrIjtpOjk0O3M6MjY6Ij1ccypbJyJdc2VuZG1haWxccyotdFxzKi1mIjtpOjk1O3M6MTU6Ii90bXAvdG1wLXNlcnZlciI7aTo5NjtzOjE1OiIvdG1wL1wuSUNFLXVuaXgiO2k6OTc7czoyOToiZXhlY1woXHMqWyciXS9iaW4vc2hbJyJdXHMqXCkiO2k6OTg7czoyNzoiXC5cLi9cLlwuL1wuXC4vXC5cLi9tb2R1bGVzIjtpOjk5O3M6MzM6InRvdWNoXHMqXChccypkaXJuYW1lXChccypfX0ZJTEVfXyI7aToxMDA7czo0OToiQHRvdWNoXHMqXChccypcJGN1cmZpbGVccyosXHMqXCR0aW1lXHMqLFxzKlwkdGltZSI7aToxMDE7czoxODoiLVwqLVxzKmNvbmZccyotXCotIjtpOjEwMjtzOjQ0OiJvcGVuXHMqXChccypNWUZJTEVccyosXHMqWyciXVxzKj5ccyp0YXJcLnRtcCI7aToxMDM7czo3NDoiXCRyZXQgPSBcJHRoaXMtPl9kYi0+dXBkYXRlT2JqZWN0XCggXCR0aGlzLT5fdGJsLCBcJHRoaXMsIFwkdGhpcy0+X3RibF9rZXkiO2k6MTA0O3M6MTk6ImRpZVwoXHMqWyciXW5vIGN1cmwiO2k6MTA1O3M6NTQ6InN1YnN0clwoXHMqXCRyZXNwb25zZVxzKixccypcJGluZm9cW1xzKlsnIl1oZWFkZXJfc2l6ZSI7aToxMDY7czoxMDg6ImlmXChccyohc29ja2V0X3NlbmR0b1woXHMqXCRzb2NrZXRccyosXHMqXCRkYXRhXHMqLFxzKnN0cmxlblwoXHMqXCRkYXRhXHMqXClccyosXHMqMFxzKixccypcJGlwXHMqLFxzKlwkcG9ydCI7aToxMDc7czo1MDoiPGlucHV0XHMrdHlwZT1zdWJtaXRccyt2YWx1ZT1VcGxvYWRccyovPlxzKjwvZm9ybT4iO2k6MTA4O3M6NTg6InJvdW5kXHMqXChccypcKFxzKlwkcGFja2V0c1xzKlwqXHMqNjVcKVxzKi9ccyoxMDI0XHMqLFxzKjIiO2k6MTA5O3M6NTc6IkBlcnJvcl9yZXBvcnRpbmdcKFxzKjBccypcKTtccyppZlxzKlwoXHMqIWlzc2V0XHMqXChccypcJCI7aToxMTA7czozMDoiZWxzZVxzKntccyplY2hvXHMqWyciXWZhaWxbJyJdIjtpOjExMTtzOjUxOiJ0eXBlPVsnIl1zdWJtaXRbJyJdXHMqdmFsdWU9WyciXVVwbG9hZCBmaWxlWyciXVxzKj4iO2k6MTEyO3M6Mzc6ImhlYWRlclwoXHMqWyciXUxvY2F0aW9uOlxzKlwkbGlua1snIl0iO2k6MTEzO3M6MzE6ImVjaG9ccypbJyJdPGI+VXBsb2FkPHNzPlN1Y2Nlc3MiO2k6MTE0O3M6NDM6Im5hbWU9WyciXXVwbG9hZGVyWyciXVxzK2lkPVsnIl11cGxvYWRlclsnIl0iO2k6MTE1O3M6MjE6Ii1JL3Vzci9sb2NhbC9iYW5kbWFpbiI7aToxMTY7czoyNDoidW5saW5rXChccypfX0ZJTEVfX1xzKlwpIjtpOjExNztzOjU2OiJtYWlsXChccypcJGFyclxbWyciXXRvWyciXVxdXHMqLFxzKlwkYXJyXFtbJyJdc3VialsnIl1cXSI7aToxMTg7czoxMjc6ImlmXChpc3NldFwoXCRfUkVRVUVTVFxbWyciXVthLXpBLVowLTlfXStbJyJdXF1cKVwpXHMqe1xzKlwkW2EtekEtWjAtOV9dK1xzKj1ccypcJF9SRVFVRVNUXFtbJyJdW2EtekEtWjAtOV9dK1snIl1cXTtccypleGl0XChcKTsiO2k6MTE5O3M6MTM6Im51bGxfZXhwbG9pdHMiO2k6MTIwO3M6NDY6IjxcP1xzKlwkW2EtekEtWjAtOV9dK1woXHMqXCRbYS16QS1aMC05X10rXHMqXCkiO2k6MTIxO3M6OToidG12YXN5bmdyIjtpOjEyMjtzOjEyOiJ0bWhhcGJ6Y2VyZmYiO2k6MTIzO3M6MTM6Im9uZnI2NF9xcnBicXIiO2k6MTI0O3M6MTQ6IlsnIl1uZmZyZWdbJyJdIjtpOjEyNTtzOjk6ImZnZV9lYmcxMyI7aToxMjY7czo3OiJjdWN2YXNiIjtpOjEyNztzOjE0OiJbJyJdZmxmZ3J6WyciXSI7aToxMjg7czoxMjoiWyciXXJpbnlbJyJdIjtpOjEyOTtzOjk6ImV0YWxmbml6ZyI7aToxMzA7czoxMjoic3NlcnBtb2NudXpnIjtpOjEzMTtzOjEzOiJlZG9jZWRfNDZlc2FiIjtpOjEzMjtzOjE0OiJbJyJddHJlc3NhWyciXSI7aToxMzM7czoxNzoiWyciXTMxdG9yX3J0c1snIl0iO2k6MTM0O3M6MTU6IlsnIl1vZm5pcGhwWyciXSI7aToxMzU7czoxNDoiWyciXWZsZmdyelsnIl0iO2k6MTM2O3M6MTI6IlsnIl1yaW55WyciXSI7aToxMzc7czo0MjoiQFwkW2EtekEtWjAtOV9dK1woXHMqXCRbYS16QS1aMC05X10rXHMqXCk7IjtpOjEzODtzOjQ4OiJwYXJzZV9xdWVyeV9zdHJpbmdcKFxzKlwkRU5We1xzKlsnIl1RVUVSWV9TVFJJTkciO2k6MTM5O3M6MzE6ImV2YWxccypcKFxzKm1iX2NvbnZlcnRfZW5jb2RpbmciO2k6MTQwO3M6MjQ6IlwpXHMqe1xzKnBhc3N0aHJ1XChccypcJCI7aToxNDE7czoxNToiSFRUUF9BQ0NFUFRfQVNFIjtpOjE0MjtzOjIxOiJmdW5jdGlvblxzKkN1cmxBdHRhY2siO2k6MTQzO3M6MTg6IkBzeXN0ZW1cKFxzKlsnIl1cJCI7aToxNDQ7czoyMzoiZWNob1woXHMqaHRtbFwoXHMqYXJyYXkiO2k6MTQ1O3M6NTY6IlwkY29kZT1bJyJdJTFzY3JpcHRccyp0eXBlPVxcWyciXXRleHQvamF2YXNjcmlwdFxcWyciXSUzIjtpOjE0NjtzOjIyOiJhcnJheVwoXHMqWyciXSUxaHRtbCUzIjtpOjE0NztzOjE5OiJidWRha1xzKi1ccypleHBsb2l0IjtpOjE0ODtzOjkxOiJcYihmdHBfZXhlY3xzeXN0ZW18c2hlbGxfZXhlY3xwYXNzdGhydXxwb3Blbnxwcm9jX29wZW4pXHMqXChccypbJyJdXCRbYS16QS1aMC05X10rWyciXVxzKlwpIjtpOjE0OTtzOjk6IkdBR0FMPC9iPiI7aToxNTA7czozODoiZXhpdFwoWyciXTxzY3JpcHQ+ZG9jdW1lbnRcLmxvY2F0aW9uXC4iO2k6MTUxO3M6Mzc6ImRpZVwoWyciXTxzY3JpcHQ+ZG9jdW1lbnRcLmxvY2F0aW9uXC4iO2k6MTUyO3M6MzY6InNldF90aW1lX2xpbWl0XChccyppbnR2YWxcKFxzKlwkYXJndiI7aToxNTM7czozMzoiZWNob1xzKlwkcHJld3VlXC5cJGxvZ1wuXCRwb3N0d3VlIjtpOjE1NDtzOjQyOiJjb25uXHMqPVxzKmh0dHBsaWJcLkhUVFBDb25uZWN0aW9uXChccyp1cmkiO2k6MTU1O3M6MzY6ImlmXHMqXChccypcJF9QT1NUXFtbJyJdezAsMX1jaG1vZDc3NyI7aToxNTY7czoyNjoiPFw/XHMqZWNob1xzKlwkY29udGVudDtcPz4iO2k6MTU3O3M6ODQ6IlwkdXJsXHMqXC49XHMqWyciXVw/W2EtekEtWjAtOV9dKz1bJyJdXHMqXC5ccypcJF9HRVRcW1xzKlsnIl1bYS16QS1aMC05X10rWyciXVxzKlxdOyI7aToxNTg7czoxMDg6ImNvcHlcKFxzKlwkX0ZJTEVTXFtccypbJyJdezAsMX1bYS16QS1aMC05X10rWyciXXswLDF9XHMqXF1cW1xzKlsnIl17MCwxfXRtcF9uYW1lWyciXXswLDF9XHMqXF1ccyosXHMqXCRfUE9TVCI7aToxNTk7czoxMTU6Im1vdmVfdXBsb2FkZWRfZmlsZVwoXHMqXCRfRklMRVNcW1xzKlsnIl17MCwxfVthLXpBLVowLTlfXStbJyJdezAsMX1ccypcXVxbWyciXXswLDF9dG1wX25hbWVbJyJdezAsMX1cXVxbXHMqXCRpXHMqXF0iO2k6MTYwO3M6MzI6ImRuc19nZXRfcmVjb3JkXChccypcJGRvbWFpblxzKlwuIjtpOjE2MTtzOjM0OiJmdW5jdGlvbl9leGlzdHNccypcKFxzKlsnIl1nZXRteHJyIjtpOjE2MjtzOjI0OiJuc2xvb2t1cFwuZXhlXHMqLXR5cGU9TVgiO2k6MTYzO3M6MTI6Im5ld1xzKk1DdXJsOyI7aToxNjQ7czo0NDoiXCRmaWxlX2RhdGFccyo9XHMqWyciXTxzY3JpcHRccypzcmM9WyciXWh0dHAiO2k6MTY1O3M6NDA6ImZwdXRzXChcJGZwLFxzKlsnIl1JUDpccypcJGlwXHMqLVxzKkRBVEUiO2k6MTY2O3M6Mjg6ImNobW9kXChccypfX0RJUl9fXHMqLFxzKjA0MDAiO2k6MTY3O3M6NDA6IkNvZGVNaXJyb3JcLmRlZmluZU1JTUVcKFxzKlsnIl10ZXh0L21pcmMiO2k6MTY4O3M6NDM6IlxdXHMqXClccypcLlxzKlsnIl1cXG5cPz5bJyJdXHMqXClccypcKVxzKnsiO2k6MTY5O3M6Njc6IlwkZ3pwXHMqPVxzKlwkYmd6RXhpc3RccypcP1xzKkBnem9wZW5cKFwkdG1wZmlsZSxccypbJyJdcmJbJyJdXHMqXCkiO2k6MTcwO3M6NzU6ImZ1bmN0aW9uPHNzPnNtdHBfbWFpbFwoXCR0b1xzKixccypcJHN1YmplY3RccyosXHMqXCRtZXNzYWdlXHMqLFxzKlwkaGVhZGVycyI7aToxNzE7czo2NDoiXCRfUE9TVFxbWyciXXswLDF9YWN0aW9uWyciXXswLDF9XF1ccyo9PVxzKlsnIl1nZXRfYWxsX2xpbmtzWyciXSI7aToxNzI7czozODoiPVxzKmd6aW5mbGF0ZVwoXHMqYmFzZTY0X2RlY29kZVwoXHMqXCQiO2k6MTczO3M6NDE6ImNobW9kXChcJGZpbGUtPmdldFBhdGhuYW1lXChcKVxzKixccyowNzc3IjtpOjE3NDtzOjYzOiJcJF9QT1NUXFtbJyJdezAsMX10cDJbJyJdezAsMX1cXVxzKlwpXHMqYW5kXHMqaXNzZXRcKFxzKlwkX1BPU1QiO2k6MTc1O3M6MTA5OiJoZWFkZXJcKFxzKlsnIl1Db250ZW50LVR5cGU6XHMqaW1hZ2UvanBlZ1snIl1ccypcKTtccypyZWFkZmlsZVwoXHMqWyciXVthLXpBLVowLTlfXStbJyJdXHMqXCk7XHMqZXhpdFwoXHMqXCk7IjtpOjE3NjtzOjMxOiI9PlxzKkBcJGYyXChfX0ZJTEVfX1xzKixccypcJGYxIjtpOjE3NztzOjgzOiJcYmV2YWxcKFxzKlthLXpBLVowLTlfXStcKFxzKlwkW2EtekEtWjAtOV9dK1xzKixccypcJFthLXpBLVowLTlfXStccypcKVxzKlwpO1xzKlw/PiI7aToxNzg7czozNzoiaWZccypcKFxzKmlzX2NyYXdsZXIxXChccypcKVxzKlwpXHMqeyI7aToxNzk7czo0ODoiXCRlY2hvXzFcLlwkZWNob18yXC5cJGVjaG9fM1wuXCRlY2hvXzRcLlwkZWNob181IjtpOjE4MDtzOjM1OiJmaWxlX2dldF9jb250ZW50c1woXHMqX19GSUxFX19ccypcKSI7aToxODE7czo4MzoiQFxiKGZ0cF9leGVjfHN5c3RlbXxzaGVsbF9leGVjfHBhc3N0aHJ1fHBvcGVufHByb2Nfb3BlbilcKFxzKkB1cmxlbmNvZGVcKFxzKlwkX1BPU1QiO2k6MTgyO3M6OTU6IlwkR0xPQkFMU1xbWyciXVthLXpBLVowLTlfXStbJyJdXF1cW1wkR0xPQkFMU1xbWyciXVthLXpBLVowLTlfXStbJyJdXF1cW1xkK1xdXChyb3VuZFwoXGQrXClcKVxdIjtpOjE4MztzOjI1OiJmdW5jdGlvblxzK2Vycm9yXzQwNFwoXCl7IjtpOjE4NDtzOjY4OiJcYihmdHBfZXhlY3xzeXN0ZW18c2hlbGxfZXhlY3xwYXNzdGhydXxwb3Blbnxwcm9jX29wZW4pXChccypbJyJdcGVybCI7aToxODU7czo3MDoiXGIoZnRwX2V4ZWN8c3lzdGVtfHNoZWxsX2V4ZWN8cGFzc3RocnV8cG9wZW58cHJvY19vcGVuKVwoXHMqWyciXXB5dGhvbiI7aToxODY7czo3MzoiaWZccypcKGlzc2V0XChcJF9HRVRcW1snIl1bYS16QS1aMC05X10rWyciXVxdXClcKVxzKntccyplY2hvXHMqWyciXW9rWyciXSI7aToxODc7czozOToicmVscGF0aHRvYWJzcGF0aFwoXHMqXCRfR0VUXFtccypbJyJdY3B5IjtpOjE4ODtzOjQ1OiJodHRwOi8vLis/Ly4rP1wucGhwXD9hPVxkKyZjPVthLXpBLVowLTlfXSsmcz0iO2k6MTg5O3M6MTY6ImZ1bmN0aW9uXHMrd3NvRXgiO2k6MTkwO3M6NTE6ImZvcmVhY2hcKFxzKlwkdG9zXHMqYXNccypcJHRvXClccyp7XHMqbWFpbFwoXHMqXCR0byI7aToxOTE7czoxMDI6ImhlYWRlclwoXHMqWyciXUNvbnRlbnQtVHlwZTpccyppbWFnZS9qcGVnWyciXVxzKlwpO1xzKnJlYWRmaWxlXChbJyJdaHR0cDovLy4rP1wuanBnWyciXVwpO1xzKmV4aXRcKFwpOyI7aToxOTI7czoxMjoiPFw/PVwkY2xhc3M7IjtpOjE5MztzOjUwOiI8aW5wdXRccyp0eXBlPSJmaWxlIlxzKnNpemU9IlxkKyJccypuYW1lPSJ1cGxvYWQiPiI7aToxOTQ7czoxMTA6IlwkbWVzc2FnZXNcW1xdXHMqPVxzKlwkX0ZJTEVTXFtccypbJyJdezAsMX11c2VyZmlsZVsnIl17MCwxfVxzKlxdXFtccypbJyJdezAsMX1uYW1lWyciXXswLDF9XHMqXF1cW1xzKlwkaVxzKlxdIjtpOjE5NTtzOjU1OiI8aW5wdXRccyp0eXBlPVsnIl1maWxlWyciXVxzKm5hbWU9WyciXXVzZXJmaWxlWyciXVxzKi8+IjtpOjE5NjtzOjEzOiJEZXZhcnRccytIVFRQIjtpOjE5NztzOjg3OiJAXCR7XHMqW2EtekEtWjAtOV9dK1xzKn1cKFxzKlsnIl1bJyJdXHMqLFxzKlwke1xzKlthLXpBLVowLTlfXStccyp9XChccypcJFthLXpBLVowLTlfXSsiO2k6MTk4O3M6OTI6IlwkR0xPQkFMU1xbXHMqWyciXXswLDF9W2EtekEtWjAtOV9dK1snIl17MCwxfVxzKlxdXChccypcJFthLXpBLVowLTlfXStcW1xzKlwkW2EtekEtWjAtOV9dK1xdIjtpOjE5OTtzOjUzOiJlcnJvcl9yZXBvcnRpbmdcKFxzKjBccypcKTtccypcJHVybFxzKj1ccypbJyJdaHR0cDovLyI7aToyMDA7czoxMjA6IlwkW2EtekEtWjAtOV9dKz1bJyJdaHR0cDovLy4rP1snIl07XHMqXCRbYS16QS1aMC05X10rPWZvcGVuXChcJFthLXpBLVowLTlfXSssWyciXXJbJyJdXCk7XHMqcmVhZGZpbGVcKFwkW2EtekEtWjAtOV9dK1wpOyI7aToyMDE7czo3NToiYXJyYXlcKFxzKlsnIl08IS0tWyciXVxzKlwuXHMqbWQ1XChccypcJHJlcXVlc3RfdXJsXHMqXC5ccypyYW5kXChcZCssXHMqXGQrIjtpOjIwMjtzOjE0OiJ3c29IZWFkZXJccypcKCI7aToyMDM7czo2OToiZWNob1woWyciXTxmb3JtIG1ldGhvZD1bJyJdcG9zdFsnIl1ccyplbmN0eXBlPVsnIl1tdWx0aXBhcnQvZm9ybS1kYXRhIjtpOjIwNDtzOjQzOiJmaWxlX2dldF9jb250ZW50c1woXHMqYmFzZTY0X2RlY29kZVwoXHMqXCRfIjtpOjIwNTtzOjY0OiJyZWxwYXRodG9hYnNwYXRoXChccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbIjtpOjIwNjtzOjQwOiJtYWlsXChcJHRvXHMqLFxzKlsnIl0uKz9bJyJdXHMqLFxzKlwkdXJsIjtpOjIwNztzOjUxOiJpZlxzKlwoXHMqIWZ1bmN0aW9uX2V4aXN0c1woXHMqWyciXXN5c19nZXRfdGVtcF9kaXIiO2k6MjA4O3M6MTc6Ijx0aXRsZT5ccypWYVJWYVJhIjtpOjIwOTtzOjM4OiJlbHNlaWZcKFxzKlwkc3FsdHlwZVxzKj09XHMqWyciXXNxbGl0ZSI7aToyMTA7czoxOToiPVsnIl1cKVxzKlwpO1xzKlw/PiI7aToyMTE7czoyNDoiZWNob1xzK2Jhc2U2NF9kZWNvZGVcKFwkIjtpOjIxMjtzOjUwOiJcI1thLXpBLVowLTlfXStcIy4rPzwvc2NyaXB0Pi4rP1wjL1thLXpBLVowLTlfXStcIyI7aToyMTM7czozNDoiZnVuY3Rpb25ccytfX2ZpbGVfZ2V0X3VybF9jb250ZW50cyI7aToyMTQ7czo1NDoiXCRmXHMqPVxzKlwkZlxkK1woWyciXVsnIl1ccyosXHMqZXZhbFwoXCRbYS16QS1aMC05X10rIjtpOjIxNTtzOjMyOiJldmFsXChcJGNvbnRlbnRcKTtccyplY2hvXHMqWyciXSI7aToyMTY7czoyOToiQ1VSTE9QVF9VUkxccyosXHMqWyciXXNtdHA6Ly8iO2k6MjE3O3M6Nzc6IjxoZWFkPlxzKjxzY3JpcHQ+XHMqd2luZG93XC50b3BcLmxvY2F0aW9uXC5ocmVmPVsnIl0uKz9ccyo8L3NjcmlwdD5ccyo8L2hlYWQ+IjtpOjIxODtzOjcwOiJcJFthLXpBLVowLTlfXStccyo9XHMqZm9wZW5cKFxzKlsnIl1bYS16QS1aMC05X10rXC5waHBbJyJdXHMqLFxzKlsnIl13IjtpOjIxOTtzOjE2OiJAYXNzZXJ0XChccypbJyJdIjtpOjIyMDtzOjg4OiJcJFthLXpBLVowLTlfXSs9XCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUylcW1xzKlsnIl1kb1snIl1ccypcXTtccyppbmNsdWRlIjtpOjIyMTtzOjc3OiJlY2hvXHMrXCRbYS16QS1aMC05X10rO21rZGlyXChccypbJyJdW2EtekEtWjAtOV9dK1snIl1ccypcKTtmaWxlX3B1dF9jb250ZW50cyI7aToyMjI7czo2NzoiXCRmcm9tXHMqPVxzKlwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtccypbJyJdZnJvbSI7aToyMjM7czoxOToiPVxzKnhkaXJcKFxzKlwkcGF0aCI7aToyMjQ7czozMDoiXCRfW2EtekEtWjAtOV9dK1woXHMqXCk7XHMqXD8+IjtpOjIyNTtzOjEwOiJ0YXJccystemNDIjtpOjIyNjtzOjgzOiJlY2hvXHMrc3RyX3JlcGxhY2VcKFxzKlsnIl1cW1BIUF9TRUxGXF1bJyJdXHMqLFxzKmJhc2VuYW1lXChcJF9TRVJWRVJcW1snIl1QSFBfU0VMRiI7aToyMjc7czo0MDoiZnVuY3Rpb25fZXhpc3RzXChccypbJyJdZlwkW2EtekEtWjAtOV9dKyI7aToyMjg7czo0MDoiXCRjdXJfY2F0X2lkXHMqPVxzKlwoXHMqaXNzZXRcKFxzKlwkX0dFVCI7aToyMjk7czozNToiaHJlZj1bJyJdPFw/cGhwXHMrZWNob1xzK1wkY3VyX3BhdGgiO2k6MjMwO3M6MzM6Ij1ccyplc2NfdXJsXChccypzaXRlX3VybFwoXHMqWyciXSI7aToyMzE7czo4NToiXlxzKjxcP3BocFxzKmhlYWRlclwoXHMqWyciXUxvY2F0aW9uOlxzKlsnIl1ccypcLlxzKlsnIl1ccypodHRwOi8vLis/WyciXVxzKlwpO1xzKlw/PiI7aToyMzI7czoxNDoiPHRpdGxlPlxzKml2bnoiO2k6MjMzO3M6NjM6Il5ccyo8XD9waHBccypoZWFkZXJcKFsnIl1Mb2NhdGlvbjpccypodHRwOi8vLis/WyciXVxzKlwpO1xzKlw/PiI7aToyMzQ7czo2MToiZ2V0X3VzZXJzXChccyphcnJheVwoXHMqWyciXXJvbGVbJyJdXHMqPT5ccypbJyJdYWRtaW5pc3RyYXRvciI7aToyMzU7czo3MToiXCR0b1xzKj1ccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbXHMqWyciXXRvX2FkZHJlc3MiO2k6MjM2O3M6MTk6ImltYXBfaGVhZGVyaW5mb1woXCQiO2k6MjM3O3M6MzQ6ImV2YWxcKFxzKlsnIl1cPz5bJyJdXHMqXC5ccypqb2luXCgiO2k6MjM4O3M6MzU6ImJlZ2luXHMrbW9kOlxzK1RoYW5rc1xzK2ZvclxzK3Bvc3RzIjtpOjIzOTtzOjMxOiJbJyJdXHMqXF5ccypcJFthLXpBLVowLTlfXStccyo7IjtpOjI0MDtzOjY1OiJcJFthLXpBLVowLTlfXStccypcLlxzKlwkW2EtekEtWjAtOV9dK1xzKlxeXHMqXCRbYS16QS1aMC05X10rXHMqOyI7aToyNDE7czoxMjA6ImlmXChpc3NldFwoXCRfUkVRVUVTVFxbWyciXVthLXpBLVowLTlfXStbJyJdXF1cKVxzKiYmXHMqbWQ1XChcJF9SRVFVRVNUXFtbJyJdezAsMX1bYS16QS1aMC05X10rWyciXXswLDF9XF1cKVxzKj09XHMqWyciXSI7aToyNDI7czoxMjoiXC53d3cvLzpwdHRoIjtpOjI0MztzOjYzOiIlNjMlNzIlNjklNzAlNzQlMkUlNzMlNzIlNjMlM0QlMjclNjglNzQlNzQlNzAlM0ElMkYlMkYlNzMlNkYlNjEiO2k6MjQ0O3M6Mjc6IndwLW9wdGlvbnNcLnBocFxzKj5ccypFcnJvciI7aToyNDU7czo4OToic3RyX3JlcGxhY2VcKGFycmF5XChbJyJdZmlsdGVyU3RhcnRbJyJdLFsnIl1maWx0ZXJFbmRbJyJdXCksXHMqYXJyYXlcKFsnIl1cKi9bJyJdLFsnIl0vXCoiO2k6MjQ2O3M6Mzc6ImZpbGVfZ2V0X2NvbnRlbnRzXChfX0ZJTEVfX1wpLFwkbWF0Y2giO2k6MjQ3O3M6MzA6InRvdWNoXChccypkaXJuYW1lXChccypfX0ZJTEVfXyI7aToyNDg7czoyMToiXHxib3RcfHNwaWRlclx8d2dldC9pIjtpOjI0OTtzOjYyOiJzdHJfcmVwbGFjZVwoWyciXTwvYm9keT5bJyJdLFthLXpBLVowLTlfXStcLlsnIl08L2JvZHk+WyciXSxcJCI7aToyNTA7czozNDoiZXhwbG9kZVwoWyciXTt0ZXh0O1snIl0sXCRyb3dcWzBcXSI7aToyNTE7czo5MDoibWFpbFwoXHMqc3RyaXBzbGFzaGVzXChccypcJFthLXpBLVowLTlfXStccypcKVxzKixccypzdHJpcHNsYXNoZXNcKFxzKlwkW2EtekEtWjAtOV9dK1xzKlwpIjtpOjI1MjtzOjIwODoiPVxzKm1haWxcKFxzKnN0cmlwc2xhc2hlc1woXHMqXCRfUE9TVFxbWyciXXswLDF9W2EtekEtWjAtOV9dK1snIl17MCwxfVxdXClccyosXHMqc3RyaXBzbGFzaGVzXChccypcJF9QT1NUXFtbJyJdezAsMX1bYS16QS1aMC05X10rWyciXXswLDF9XF1cKVxzKixccypzdHJpcHNsYXNoZXNcKFxzKlwkX1BPU1RcW1snIl17MCwxfVthLXpBLVowLTlfXStbJyJdezAsMX1cXSI7aToyNTM7czoxNTM6Ij1ccyptYWlsXChccypcJF9QT1NUXFtbJyJdezAsMX1bYS16QS1aMC05X10rWyciXXswLDF9XF1ccyosXHMqXCRfUE9TVFxbWyciXXswLDF9W2EtekEtWjAtOV9dK1snIl17MCwxfVxdXHMqLFxzKlwkX1BPU1RcW1snIl17MCwxfVthLXpBLVowLTlfXStbJyJdezAsMX1cXSI7aToyNTQ7czoxNDoiTGliWG1sMklzQnVnZ3kiO2k6MjU1O3M6OToibWFhZlxzK3lhIjtpOjI1NjtzOjM0OiJlY2hvIFthLXpBLVowLTlfXStccypcKFsnIl1odHRwOi8vIjtpOjI1NztzOjU0OiJcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbWyciXWFzc3VudG8iO2k6MjU4O3M6MTI6ImBjaGVja3N1ZXhlYyI7aToyNTk7czoxODoid2hpY2hccytzdXBlcmZldGNoIjtpOjI2MDtzOjQ1OiJybWRpcnNcKFwkZGlyXHMqXC5ccypbJyJdL1snIl1ccypcLlxzKlwkY2hpbGQiO2k6MjYxO3M6NDI6ImV4cGxvZGVcKFxzKlxcWyciXTt0ZXh0O1xcWyciXVxzKixccypcJHJvdyI7aToyNjI7czozNzoiPVxzKlsnIl1waHBfdmFsdWVccythdXRvX3ByZXBlbmRfZmlsZSI7aToyNjM7czozNToiaWZccypcKFxzKmlzX3dyaXRhYmxlXChccypcJHd3d1BhdGgiO2k6MjY0O3M6NDY6ImZvcGVuXChccypcJFthLXpBLVowLTlfXStccypcLlxzKlsnIl0vd3AtYWRtaW4iO2k6MjY1O3M6MjI6InJldHVyblxzKlsnIl0vdmFyL3d3dy8iO2k6MjY2O3M6MjA6IlsnIl07XCRcd3sxLDQ1fTtbJyJdIjtpOjI2NztzOjE0MToiY2FsbF91c2VyX2Z1bmNfYXJyYXlcKFxzKlsnIl1bYS16QS1aMC05X10rWyciXVxzKixccyphcnJheVwoXHMqWyciXS4qP1snIl1ccyosXHMqZ2V0ZW52XChccypbJyJdLio/WyciXVxzKlwpXHMqLFxzKlsnIl0uKj9bJyJdXHMqXClccypcKTtccyp9IjtpOjI2ODtzOjExNDoiXCRbYS16QS1aMC05X10rXHMqPVxzKmNoclwoXGQrXHMqXF5ccypcZCtcKVwuY2hyXChcZCtccypcXlxzKlxkK1wpXC5jaHJcKFxkK1xzKlxeXHMqXGQrXClcLmNoclwoXGQrXHMqXF5ccypcZCtcKVwuIjtpOjI2OTtzOjM2OiI8c2NyaXB0XHMrc3JjPVsnIl0vXD9cJFNFUlZFUl9JUD1cZCsiO2k6MjcwO3M6NTg6IkA/XCR7XHMqWyciXXswLDF9XHd7MSw0NX1bJyJdezAsMX1ccyp9XChccypcJFx3ezEsNDV9XHMqXCkiO2k6MjcxO3M6NDI6IkA/XCR7XHMqXCRcd3sxLDQ1fVxzKn1cKFxzKlwkXHd7MSw0NX1ccypcKSI7aToyNzI7czoxNDE6IlxiKGZvcGVufGZpbGVfZ2V0X2NvbnRlbnRzfGZpbGVfcHV0X2NvbnRlbnRzfHN0YXR8Y2htb2R8ZmlsZXxzeW1saW5rKVxzKlwoXHMqWyciXWh0dHA6Ly9bJyJdXHMqXC5ccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKSI7aToyNzM7czoxODY6IlwkW2EtekEtWjAtOV9dK1xzKntccypcZCtccyp9XC5cJFthLXpBLVowLTlfXStccyp7XHMqXGQrXHMqfVwuXCRbYS16QS1aMC05X10rXHMqe1xzKlxkK1xzKn1cLlwkW2EtekEtWjAtOV9dK1xzKntccypcZCtccyp9XC5cJFthLXpBLVowLTlfXStccyp7XHMqXGQrXHMqfVwuXCRbYS16QS1aMC05X10rXHMqe1xzKlxkK1xzKn1cLiI7aToyNzQ7czoxNjoidGFncy9cJDYvXCQ0L1wkNyI7aToyNzU7czozMDoic3RyX3JlcGxhY2VcKFxzKlsnIl1cLmh0YWNjZXNzIjtpOjI3NjtzOjQzOiJmdW5jdGlvblxzK19cZCtcKFxzKlwkW2EtekEtWjAtOV9dK1xzKlwpe1wkIjtpOjI3NztzOjIxOiJleHBsb2RlXChcXFsnIl07dGV4dDsiO2k6Mjc4O3M6MTIzOiJzdWJzdHJcKFxzKlwkW2EtekEtWjAtOV9dK1xzKixccypcZCtccyosXHMqXGQrXHMqXCk7XHMqXCRbYS16QS1aMC05X10rXHMqPVxzKnByZWdfcmVwbGFjZVwoXHMqXCRbYS16QS1aMC05X10rXHMqLFxzKnN0cnRyXCgiO2k6Mjc5O3M6NjY6ImFycmF5X2ZsaXBcKFxzKmFycmF5X21lcmdlXChccypyYW5nZVwoXHMqWyciXUFbJyJdXHMqLFxzKlsnIl1aWyciXSI7aToyODA7czo2MzoiXCRfU0VSVkVSXFtccypbJyJdRE9DVU1FTlRfUk9PVFsnIl1ccypcXVxzKlwuXHMqWyciXS9cLmh0YWNjZXNzIjtpOjI4MTtzOjMxOiJcJGluc2VydF9jb2RlXHMqPVxzKlsnIl08aWZyYW1lIjtpOjI4MjtzOjQxOiJhc3NlcnRfb3B0aW9uc1woXHMqQVNTRVJUX1dBUk5JTkdccyosXHMqMCI7aToyODM7czoxNToiTXVzdEBmQFxzK1NoZWxsIjtpOjI4NDtzOjY2OiJcYmV2YWxcKFxzKlwkW2EtekEtWjAtOV9dK1woXHMqXCRbYS16QS1aMC05X10rXChccypcJFthLXpBLVowLTlfXSsiO2k6Mjg1O3M6MzQ6ImZ1bmN0aW9uX2V4aXN0c1woXHMqWyciXXBjbnRsX2ZvcmsiO2k6Mjg2O3M6NDA6InN0cl9yZXBsYWNlXChbJyJdXC5odGFjY2Vzc1snIl1ccyosXHMqXCQiO2k6Mjg3O3M6MzM6Ij1ccypAP2d6aW5mbGF0ZVwoXHMqc3RycmV2XChccypcJCI7aToyODg7czoyMjoiZ1woXHMqWyciXUZpbGVzTWFuWyciXSI7aToyODk7czoyODoic3RyX3JlcGxhY2VcKFsnIl0vXD9hbmRyWyciXSI7aToyOTA7czoyMDQ6IlwkW2EtekEtWjAtOV9dK1xzKj1ccypcJF9SRVFVRVNUXFtbJyJdezAsMX1bYS16QS1aMC05X10rWyciXXswLDF9XF07XHMqXCRbYS16QS1aMC05X10rXHMqPVxzKmFycmF5XChccypcJF9SRVFVRVNUXFtccypbJyJdezAsMX1bYS16QS1aMC05X10rWyciXXswLDF9XHMqXF1ccypcKTtccypcJFthLXpBLVowLTlfXStccyo9XHMqYXJyYXlfZmlsdGVyXChccypcJCI7aToyOTE7czoxMjg6IlwkW2EtekEtWjAtOV9dK1xzKlwuPVxzKlwkW2EtekEtWjAtOV9dK3tcZCt9XHMqXC5ccypcJFthLXpBLVowLTlfXSt7XGQrfVxzKlwuXHMqXCRbYS16QS1aMC05X10re1xkK31ccypcLlxzKlwkW2EtekEtWjAtOV9dK3tcZCt9IjtpOjI5MjtzOjc0OiJzdHJwb3NcKFwkbCxbJyJdTG9jYXRpb25bJyJdXCkhPT1mYWxzZVx8XHxzdHJwb3NcKFwkbCxbJyJdU2V0LUNvb2tpZVsnIl1cKSI7aToyOTM7czo5NzoiYWRtaW4vWyciXSxbJyJdYWRtaW5pc3RyYXRvci9bJyJdLFsnIl1hZG1pbjEvWyciXSxbJyJdYWRtaW4yL1snIl0sWyciXWFkbWluMy9bJyJdLFsnIl1hZG1pbjQvWyciXSI7aToyOTQ7czoxNToiWyciXWNoZWNrc3VleGVjIjtpOjI5NTtzOjU1OiJpZlxzKlwoXHMqXCR0aGlzLT5pdGVtLT5oaXRzXHMqPj1bJyJdXGQrWyciXVwpXHMqe1xzKlwkIjtpOjI5NjtzOjQ3OiJleHBsb2RlXChbJyJdXFxuWyciXSxccypcJF9QT1NUXFtbJyJddXJsc1snIl1cXSI7aToyOTc7czoxMTQ6ImlmXChpbmlfZ2V0XChbJyJdYWxsb3dfdXJsX2ZvcGVuWyciXVwpXHMqPT1ccyoxXClccyp7XHMqXCRbYS16QS1aMC05X10rXHMqPVxzKmZpbGVfZ2V0X2NvbnRlbnRzXChcJFthLXpBLVowLTlfXStcKSI7aToyOTg7czoxMjI6ImlmXChccypcJGZwXHMqPVxzKmZzb2Nrb3BlblwoXCR1XFtbJyJdaG9zdFsnIl1cXSwhZW1wdHlcKFwkdVxbWyciXXBvcnRbJyJdXF1cKVxzKlw/XHMqXCR1XFtbJyJdcG9ydFsnIl1cXVxzKjpccyo4MFxzKlwpXCl7IjtpOjI5OTtzOjg5OiJpbmNsdWRlXChccypbJyJdZGF0YTp0ZXh0L3BsYWluO2Jhc2U2NFxzKixccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbOyI7aTozMDA7czoyMToiaW5jbHVkZVwoXHMqWyciXXpsaWI6IjtpOjMwMTtzOjIxOiJpbmNsdWRlXChccypbJyJdL3RtcC8iO2k6MzAyO3M6NzA6IlwkZG9jXHMqPVxzKkpGYWN0b3J5OjpnZXREb2N1bWVudFwoXCk7XHMqXCRkb2MtPmFkZFNjcmlwdFwoWyciXWh0dHA6Ly8iO2k6MzAzO3M6MzA6IlwkZGVmYXVsdF91c2VfYWpheFxzKj1ccyp0cnVlOyI7aTozMDQ7czoxMDoiZGVrY2FoWyciXSI7aTozMDU7czoyMzoic3Vic3RyXChtZDVcKHN0cnJldlwoXCQiO2k6MzA2O3M6MTM6Ij09WyciXVwpXHMqXC4iO2k6MzA3O3M6MTAzOiJpZlxzKlwoXHMqXChccypcJFthLXpBLVowLTlfXStccyo9XHMqc3RycnBvc1woXCRbYS16QS1aMC05X10rXHMqLFxzKlsnIl1cPz5bJyJdXHMqXClccypcKVxzKj09PVxzKmZhbHNlIjtpOjMwODtzOjE1MzoiXCRfU0VSVkVSXFtbJyJdRE9DVU1FTlRfUk9PVFsnIl1ccypcLlxzKlsnIl0vWyciXVxzKlwuXHMqXCRbYS16QS1aMC05X10rXHMqXC5ccypbJyJdL1snIl1ccypcLlxzKlwkW2EtekEtWjAtOV9dK1xzKlwuXHMqWyciXS9bJyJdXHMqXC5ccypcJFthLXpBLVowLTlfXSssIjtpOjMwOTtzOjMwOiJmb3BlblxzKlwoXHMqWyciXWJhZF9saXN0XC50eHQiO2k6MzEwO3M6NDk6IkA/ZmlsZV9nZXRfY29udGVudHNcKEA/YmFzZTY0X2RlY29kZVwoQD91cmxkZWNvZGUiO2k6MzExO3M6MjU6Ilwke1thLXpBLVowLTlfXSt9XChccypcKTsiO2k6MzEyO3M6NjA6InN1YnN0clwoc3ByaW50ZlwoWyciXSVvWyciXSxccypmaWxlcGVybXNcKFwkZmlsZVwpXCksXHMqLTRcKSI7aTozMTM7czo1NToiXCRbYS16QS1aMC05X10rXChbJyJdWyciXVxzKixccypldmFsXChcJFthLXpBLVowLTlfXStcKSI7aTozMTQ7czoxNjoid3NvU2VjUGFyYW1ccypcKCI7aTozMTU7czoxODoid2hpY2hccytzdXBlcmZldGNoIjtpOjMxNjtzOjY3OiJjb3B5XChccypbJyJdaHR0cDovLy4rP1wudHh0WyciXVxzKixccypbJyJdW2EtekEtWjAtOV9dK1wucGhwWyciXVwpIjtpOjMxNztzOjI4OiJcJHNldGNvb2tccypcKTtzZXRjb29raWVcKFwkIjtpOjMxODtzOjQ5MjoiQD9cYihldmFsfGJhc2U2NF9kZWNvZGV8c3RycmV2fHByZWdfcmVwbGFjZXxwcmVnX3JlcGxhY2VfY2FsbGJhY2t8dXJsZGVjb2RlfHN0cnN0cnxnemluZmxhdGV8c3ByaW50ZnxnenVuY29tcHJlc3N8YXNzZXJ0fHN0cl9yb3QxM3xtZDV8YXJyYXlfd2Fsa3xhcnJheV9maWx0ZXIpXHMqXChAP1xiKGV2YWx8YmFzZTY0X2RlY29kZXxzdHJyZXZ8cHJlZ19yZXBsYWNlfHByZWdfcmVwbGFjZV9jYWxsYmFja3x1cmxkZWNvZGV8c3Ryc3RyfGd6aW5mbGF0ZXxzcHJpbnRmfGd6dW5jb21wcmVzc3xhc3NlcnR8c3RyX3JvdDEzfG1kNXxhcnJheV93YWxrfGFycmF5X2ZpbHRlcilccypcKEA/XGIoZXZhbHxiYXNlNjRfZGVjb2RlfHN0cnJldnxwcmVnX3JlcGxhY2V8cHJlZ19yZXBsYWNlX2NhbGxiYWNrfHVybGRlY29kZXxzdHJzdHJ8Z3ppbmZsYXRlfHNwcmludGZ8Z3p1bmNvbXByZXNzfGFzc2VydHxzdHJfcm90MTN8bWQ1fGFycmF5X3dhbGt8YXJyYXlfZmlsdGVyKVxzKlwoIjtpOjMxOTtzOjQxOiJcLlxzKmJhc2U2NF9kZWNvZGVcKFxzKlwkaW5qZWN0XHMqXClccypcLiI7aTozMjA7czozOToiKGNoclwoW1xzXHdcJFxeXCtcLVwqL10rXClccypcLlxzKil7NCx9IjtpOjMyMTtzOjQyOiI9XHMqQD9mc29ja29wZW5cKFxzKlwkYXJndlxbXGQrXF1ccyosXHMqODAiO2k6MzIyO3M6MzU6IlwuXC4vXC5cLi9lbmdpbmUvZGF0YS9kYmNvbmZpZ1wucGhwIjtpOjMyMztzOjg1OiJyZWN1cnNlX2NvcHlcKFxzKlwkc3JjXHMqLFxzKlwkZHN0XHMqXCk7XHMqaGVhZGVyXChccypbJyJdbG9jYXRpb246XHMqXCRkc3RbJyJdXHMqXCk7IjtpOjMyNDtzOjE3OiJHYW50ZW5nZXJzXHMrQ3JldyI7aTozMjU7czoxNTU6IlwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtbJyJdezAsMX1ccypbYS16QS1aMC05X10rXHMqWyciXXswLDF9XF1cKFxzKlsnIl17MCwxfVwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtccypbYS16QS1aMC05X10rIjtpOjMyNjtzOjQwOiJmd3JpdGVcKFwkW2EtekEtWjAtOV9dK1xzKixccypbJyJdPFw/cGhwIjtpOjMyNztzOjU2OiJAP2NyZWF0ZV9mdW5jdGlvblwoXHMqWyciXVsnIl1ccyosXHMqQD9maWxlX2dldF9jb250ZW50cyI7aTozMjg7czoxMDQ6IlxdXChbJyJdXCRfWyciXVxzKixccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbXHMqWyciXXswLDF9W2EtekEtWjAtOV9dK1snIl17MCwxfVxzKlxdIjtpOjMyOTtzOjM5OiJpZlxzKlwoXHMqaXNzZXRcKFxzKlwkX0dFVFxbXHMqWyciXXBpbmciO2k6MzMwO3M6MzA6InJlYWRfZmlsZVwoXHMqWyciXWRvbWFpbnNcLnR4dCI7aTozMzE7czozODoiXGJldmFsXChccypbJyJde1xzKlwkW2EtekEtWjAtOV9dK1xzKn0iO2k6MzMyO3M6MTA4OiJpZlxzKlwoXHMqZmlsZV9leGlzdHNcKFxzKlwkW2EtekEtWjAtOV9dK1xzKlwpXHMqXClccyp7XHMqY2htb2RcKFxzKlwkW2EtekEtWjAtOV9dK1xzKixccyowXGQrXCk7XHMqfVxzKmVjaG8iO2k6MzMzO3M6MTE6Ij09WyciXVwpXCk7IjtpOjMzNDtzOjU1OiJcJFthLXpBLVowLTlfXSs9dXJsZGVjb2RlXChbJyJdLis/WyciXVwpO2lmXChwcmVnX21hdGNoIjtpOjMzNTtzOjgwOiJcJFthLXpBLVowLTlfXStccyo9XHMqZGVjcnlwdF9TT1woXHMqXCRbYS16QS1aMC05X10rXHMqLFxzKlsnIl1bYS16QS1aMC05X10rWyciXSI7aTozMzY7czoxMDU6Ij1ccyptYWlsXChccypiYXNlNjRfZGVjb2RlXChccypcJFthLXpBLVowLTlfXStcW1xkK1xdXHMqXClccyosXHMqYmFzZTY0X2RlY29kZVwoXHMqXCRbYS16QS1aMC05X10rXFtcZCtcXSI7aTozMzc7czoyNjoiZXZhbFwoXHMqWyciXXJldHVyblxzK2V2YWwiO2k6MzM4O3M6MTAwOiI9XHMqYmFzZTY0X2VuY29kZVwoXHMqXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUylcW1snIl1bYS16QS1aMC05X10rWyciXVxdXCk7XHMqaGVhZGVyIjtpOjMzOTtzOjEwNzoiQGluaV9zZXRcKFsnIl1lcnJvcl9sb2dbJyJdLE5VTExcKTtccypAaW5pX3NldFwoWyciXWxvZ19lcnJvcnNbJyJdLDBcKTtccypmdW5jdGlvblxzK3JlYWRfZmlsZVwoXCRmaWxlX25hbWUiO2k6MzQwO3M6Mzc6IlwkdGV4dFxzKj1ccypodHRwX2dldFwoXHMqWyciXWh0dHA6Ly8iO2k6MzQxO3M6MTQzOiJcJFthLXpBLVowLTlfXStccyo9XHMqc3RyX3JlcGxhY2VcKFsnIl08L2JvZHk+WyciXVxzKixccypbJyJdWyciXVxzKixccypcJFthLXpBLVowLTlfXStcKTtccypcJFthLXpBLVowLTlfXStccyo9XHMqc3RyX3JlcGxhY2VcKFsnIl08L2h0bWw+WyciXSI7aTozNDI7czoxNTg6IlwjW2EtekEtWjAtOV9dK1wjXHMqaWZcKGVtcHR5XChcJFthLXpBLVowLTlfXStcKVwpXHMqe1xzKlwkW2EtekEtWjAtOV9dK1xzKj1ccypbJyJdPHNjcmlwdC4rPzwvc2NyaXB0PlsnIl07XHMqZWNob1xzK1wkW2EtekEtWjAtOV9dKztccyp9XHMqXCMvW2EtekEtWjAtOV9dK1wjIjtpOjM0MztzOjY2OiJcLlwkX1JFUVVFU1RcW1xzKlsnIl1bYS16QS1aMC05X10rWyciXVxzKlxdXHMqLFxzKnRydWVccyosXHMqMzAyXCkiO2k6MzQ0O3M6MTA0OiI9XHMqY3JlYXRlX2Z1bmN0aW9uXHMqXChccypudWxsXHMqLFxzKlthLXpBLVowLTlfXStcKFxzKlwkW2EtekEtWjAtOV9dK1xzKlwpXHMqXCk7XHMqXCRbYS16QS1aMC05X10rXChcKSI7aTozNDU7czo1NDoiPVxzKmZpbGVfZ2V0X2NvbnRlbnRzXChbJyJdaHR0cHM/Oi8vXGQrXC5cZCtcLlxkK1wuXGQrIjtpOjM0NjtzOjU3OiJDb250ZW50LXR5cGU6XHMqYXBwbGljYXRpb24vdm5kXC5hbmRyb2lkXC5wYWNrYWdlLWFyY2hpdmUiO2k6MzQ3O3M6MjA6InNsdXJwXHxtc25ib3RcfHRlb21hIjtpOjM0ODtzOjI3OiJcJEdMT0JBTFNcW25leHRcXVxbWyciXW5leHQiO2k6MzQ5O3M6MTc5OiI7QD9cJFthLXpBLVowLTlfXStcKFxiKGV2YWx8YmFzZTY0X2RlY29kZXxzdHJyZXZ8cHJlZ19yZXBsYWNlfHByZWdfcmVwbGFjZV9jYWxsYmFja3x1cmxkZWNvZGV8c3Ryc3RyfGd6aW5mbGF0ZXxzcHJpbnRmfGd6dW5jb21wcmVzc3xhc3NlcnR8c3RyX3JvdDEzfG1kNXxhcnJheV93YWxrfGFycmF5X2ZpbHRlcilcKCI7aTozNTA7czoyOToiaGVhZGVyXChfW2EtekEtWjAtOV9dK1woXGQrXCkiO2k6MzUxO3M6MTk1OiJpZlxzKlwoaXNzZXRcKFwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtbJyJdW2EtekEtWjAtOV9dK1snIl1cXVwpXHMqJiZccyptZDVcKFwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtbJyJdW2EtekEtWjAtOV9dK1snIl1cXVwpXHMqPT09XHMqWyciXVthLXpBLVowLTlfXStbJyJdXCkiO2k6MzUyO3M6OTA6IlwuPVxzKmNoclwoXCRbYS16QS1aMC05X10rXHMqPj5ccypcKFxkK1xzKlwqXHMqXChcZCtccyotXHMqXCRbYS16QS1aMC05X10rXClcKVxzKiZccypcZCtcKSI7aTozNTM7czozMToiLT5wcmVwYXJlXChbJyJdU0hPV1xzK0RBVEFCQVNFUyI7aTozNTQ7czoyMzoic29ja3Nfc3lzcmVhZFwoXCRjbGllbnQiO2k6MzU1O3M6MjQ6IjwlZXZhbFwoXHMqUmVxdWVzdFwuSXRlbSI7aTozNTY7czo5OToiXCRfUE9TVFxbWyciXVthLXpBLVowLTlfXStbJyJdXF07XHMqXCRbYS16QS1aMC05X10rXHMqPVxzKmZvcGVuXChccypcJF9HRVRcW1snIl1bYS16QS1aMC05X10rWyciXVxdIjtpOjM1NztzOjQwOiJ1cmw9WyciXWh0dHA6Ly9zY2FuNHlvdVwubmV0L3JlbW90ZVwucGhwIjtpOjM1ODtzOjYwOiJjYWxsX3VzZXJfZnVuY1woXHMqXCRbYS16QS1aMC05X10rXHMqLFxzKlwkW2EtekEtWjAtOV9dK1wpO30iO2k6MzU5O3M6Nzk6InByZWdfcmVwbGFjZVwoXHMqWyciXS8uKz8vZVsnIl1ccyosXHMqXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUykiO2k6MzYwO3M6MTA2OiI9XHMqZmlsZV9nZXRfY29udGVudHNcKFxzKlsnIl0uKz9bJyJdXCk7XHMqXCRbYS16QS1aMC05X10rXHMqPVxzKmZvcGVuXChccypcJFthLXpBLVowLTlfXStccyosXHMqWyciXXdbJyJdIjtpOjM2MTtzOjU5OiJpZlwoXHMqXCRbYS16QS1aMC05X10rXClccyp7XHMqZXZhbFwoXCRbYS16QS1aMC05X10rXCk7XHMqfSI7aTozNjI7czoxNzk6ImFycmF5X21hcFwoXHMqWyciXVxiKGV2YWx8YmFzZTY0X2RlY29kZXxzdHJyZXZ8cHJlZ19yZXBsYWNlfHByZWdfcmVwbGFjZV9jYWxsYmFja3x1cmxkZWNvZGV8c3Ryc3RyfGd6aW5mbGF0ZXxzcHJpbnRmfGd6dW5jb21wcmVzc3xhc3NlcnR8c3RyX3JvdDEzfG1kNXxhcnJheV93YWxrfGFycmF5X2ZpbHRlcilbJyJdIjtpOjM2MztzOjE4NzoiPVxzKlwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtbJyJdW2EtekEtWjAtOV9dK1snIl1cXTtccypcJFthLXpBLVowLTlfXStccyo9XHMqZmlsZV9wdXRfY29udGVudHNcKFxzKlwkW2EtekEtWjAtOV9dK1xzKixccypmaWxlX2dldF9jb250ZW50c1woXHMqXCRbYS16QS1aMC05X10rXHMqXClccypcKSI7aTozNjQ7czo2MToiPFw/XHMqXCRbYS16QS1aMC05X10rPVsnIl0uKz9bJyJdO1xzKmhlYWRlclxzKlwoWyciXUxvY2F0aW9uOiI7aTozNjU7czoyNToiPCEtLVwjZXhlY1xzK2NtZFxzKj1ccypcJCI7aTozNjY7czo4MToiaWZcKFxzKnN0cmlwb3NcKFxzKlwkW2EtekEtWjAtOV9dK1xzKixccypbJyJdYW5kcm9pZFsnIl1ccypcKVxzKiE9PVxzKmZhbHNlXClccyp7IjtpOjM2NztzOjkwOiJcLj1ccypbJyJdPGRpdlxzK3N0eWxlPVsnIl1kaXNwbGF5Om5vbmU7WyciXT5bJyJdXHMqXC5ccypcJFthLXpBLVowLTlfXStccypcLlxzKlsnIl08L2Rpdj4iO2k6MzY4O3M6MTE0OiI9ZmlsZV9leGlzdHNcKFwkW2EtekEtWjAtOV9dK1wpXD9AZmlsZW10aW1lXChcJFthLXpBLVowLTlfXStcKTpcJFthLXpBLVowLTlfXSs7QGZpbGVfcHV0X2NvbnRlbnRzXChcJFthLXpBLVowLTlfXSsiO2k6MzY5O3M6ODk6IlwkW2EtekEtWjAtOV9dK1xzKlxbXHMqW2EtekEtWjAtOV9dK1xzKlxdXChccypcJFthLXpBLVowLTlfXStcW1xzKlthLXpBLVowLTlfXStccypcXVxzKlwpIjtpOjM3MDtzOjk2OiJcJFthLXpBLVowLTlfXSssWyciXXNsdXJwWyciXVwpXHMqIT09XHMqZmFsc2VccypcfFx8XHMqc3RycG9zXChccypcJFthLXpBLVowLTlfXSssWyciXXNlYXJjaFsnIl0iO2k6MzcxO3M6NjM6IlwkW2EtekEtWjAtOV9dK1woXHMqXCRbYS16QS1aMC05X10rXChccypcJFthLXpBLVowLTlfXStcKVxzKlwpOyI7aTozNzI7czoxNzoiY2xhc3NccytNQ3VybFxzKnsiO2k6MzczO3M6NTY6IkBpbmlfc2V0XChbJyJdZGlzcGxheV9lcnJvcnNbJyJdLDBcKTtccypAZXJyb3JfcmVwb3J0aW5nIjtpOjM3NDtzOjY5OiJpZlwoXHMqZmlsZV9leGlzdHNcKFxzKlwkZmlsZXBhdGhccypcKVxzKlwpXHMqe1xzKmVjaG9ccytbJyJddXBsb2FkZWQiO2k6Mzc1O3M6MzA6InJldHVyblxzK1JDNDo6RW5jcnlwdFwoXCRhLFwkYiI7aTozNzY7czozMjoiZnVuY3Rpb25ccytnZXRIVFRQUGFnZVwoXHMqXCR1cmwiO2k6Mzc3O3M6MjE6Ij1ccypyZXF1ZXN0XChccypjaHJcKCI7aTozNzg7czo1NToiO1xzKmFycmF5X2ZpbHRlclwoXCRbYS16QS1aMC05X10rXHMqLFxzKmJhc2U2NF9kZWNvZGVcKCI7aTozNzk7czoyMzQ6ImNhbGxfdXNlcl9mdW5jXChccypbJyJdXGIoZXZhbHxiYXNlNjRfZGVjb2RlfHN0cnJldnxwcmVnX3JlcGxhY2V8cHJlZ19yZXBsYWNlX2NhbGxiYWNrfHVybGRlY29kZXxzdHJzdHJ8Z3ppbmZsYXRlfHNwcmludGZ8Z3p1bmNvbXByZXNzfGFzc2VydHxzdHJfcm90MTN8bWQ1fGFycmF5X3dhbGt8YXJyYXlfZmlsdGVyKVsnIl1ccyosXHMqXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUylcWyI7aTozODA7czoyNDc6ImNhbGxfdXNlcl9mdW5jX2FycmF5XChccypbJyJdXGIoZXZhbHxiYXNlNjRfZGVjb2RlfHN0cnJldnxwcmVnX3JlcGxhY2V8cHJlZ19yZXBsYWNlX2NhbGxiYWNrfHVybGRlY29kZXxzdHJzdHJ8Z3ppbmZsYXRlfHNwcmludGZ8Z3p1bmNvbXByZXNzfGFzc2VydHxzdHJfcm90MTN8bWQ1fGFycmF5X3dhbGt8YXJyYXlfZmlsdGVyKVsnIl1ccyosXHMqYXJyYXlcKFwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFsiO2k6MzgxO3M6ODc6ImlmIFwoIT9cJF9TRVJWRVJcW1snIl1IVFRQX1VTRVJfQUdFTlRbJyJdXF1ccypPUlxzKlwoc3Vic3RyXChcJF9TRVJWRVJcW1snIl1SRU1PVEVfQUREUiI7aTozODI7czo1OToicmVscGF0aHRvYWJzcGF0aFwoXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUykiO2k6MzgzO3M6Njg6IlwkZGF0YVxbWyciXWNjX2V4cF9tb250aFsnIl1cXVxzKixccypzdWJzdHJcKFwkZGF0YVxbWyciXWNjX2V4cF95ZWFyIjtpOjM4NDtzOjQwOiJcJFthLXpBLVowLTlfXStccyooXFsuezEsNDB9XF0pezEsfVxzKlwoIjtpOjM4NTtzOjMzOiJjYWxsX3VzZXJfZnVuY1woXHMqQD91bmhleFwoXHMqMHgiO2k6Mzg2O3M6Mjk6IlwuXC46OlxbXHMqcGhwcm94eVxzKlxdOjpcLlwuIjtpOjM4NztzOjQ0OiJbJyJdXHMqXC5ccypjaHJcKFxzKlxkKy5cZCtccypcKVxzKlwuXHMqWyciXSI7aTozODg7czozMjoicHJlZ19yZXBsYWNlLio/L2VbJyJdXHMqLFxzKlsnIl0iO2k6Mzg5O3M6ODU6IlwkW2EtekEtWjAtOV9dK1woXCRbYS16QS1aMC05X10rXChcJFthLXpBLVowLTlfXStcKFwkW2EtekEtWjAtOV9dK1woXCRbYS16QS1aMC05X10rXCkiO2k6MzkwO3M6MjM6In1ldmFsXChiemRlY29tcHJlc3NcKFwkIjtpOjM5MTtzOjU4OiIvdXNyL2xvY2FsL3BzYS9hcGFjaGUvYmluL2h0dHBkXHMrLURGUk9OVFBBR0VccystREhBVkVfU1NMIjtpOjM5MjtzOjU3OiJpY29udlwoYmFzZTY0X2RlY29kZVwoWyciXS4rP1snIl1cKVxzKixccypiYXNlNjRfZGVjb2RlXCgiO2k6MzkzO3M6MzM6Ijxicj5bJyJdXC5waHBfdW5hbWVcKFwpXC5bJyJdPGJyPiI7aTozOTQ7czo2NjoiXCk7QFwkW2EtekEtWjAtOV9dK1xbY2hyXChcZCtcKVxdXChcJFthLXpBLVowLTlfXStcW2NoclwoXGQrXClcXVwoIjtpOjM5NTtzOjExNToiXGIoZm9wZW58ZmlsZV9nZXRfY29udGVudHN8ZmlsZV9wdXRfY29udGVudHN8c3RhdHxjaG1vZHxmaWxlfHN5bWxpbmspXChccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKSI7aTozOTY7czo5NToiXGIoZm9wZW58ZmlsZV9nZXRfY29udGVudHN8ZmlsZV9wdXRfY29udGVudHN8c3RhdHxjaG1vZHxmaWxlfHN5bWxpbmspXChbJyJdaHR0cDovL3Bhc3RlYmluXC5jb20iO2k6Mzk3O3M6MTA5OiI7XCRbYS16QS1aMC05X10rPVwkW2EtekEtWjAtOV9dK1woXCRbYS16QS1aMC05X10rLFwkW2EtekEtWjAtOV9dK1wpO1wkW2EtekEtWjAtOV9dK1woXCRbYS16QS1aMC05X10rXCk7XHMqXD8+IjtpOjM5ODtzOjgzOiJcJF9TRVJWRVJcW1snIl1SRVFVRVNUX1VSSVsnIl1cXVwpLFsnIl1bYS16QS1aMC05X10rWyciXVwpXCl7XHMqaW5jbHVkZVwoZ2V0Y3dkXChcKSI7aTozOTk7czo4NDoid3Bfc2V0X2F1dGhfY29va2llXChcJHVzZXJfaWRcKTtccypkb19hY3Rpb25cKFsnIl13cF9sb2dpblsnIl1ccyosXHMqXCR1c2VyX2xvZ2luXCk7IjtpOjQwMDtzOjU4OiJhcnJheV9kaWZmX3VrZXlcKFwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpIjtpOjQwMTtzOjY2OiI9Zm9wZW5cKGJhc2U2NF9kZWNvZGVcKFwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFsiO2k6NDAyO3M6MTk6Ii1leGVjIHRvdWNoIC1hY20gLXIiO2k6NDAzO3M6MjM0OiJcJFthLXpBLVowLTlfXStccypcLj1ccypzdWJzdHJcKFwkW2EtekEtWjAtOV9dKyxccypcJFthLXpBLVowLTlfXStccypcK1xzKlxkKyxccypcJEdMT0JBTFNcW1snIl1bYS16QS1aMC05X10rWyciXVxdXChcJFthLXpBLVowLTlfXStcW1wkW2EtekEtWjAtOV9dK1xdXClcKTtccypcJFthLXpBLVowLTlfXStccypcKz1ccypcJEdMT0JBTFNcW1snIl1bYS16QS1aMC05X10rWyciXVxdXChcJFthLXpBLVowLTlfXSsiO2k6NDA0O3M6ODA6Im1vdmVfdXBsb2FkZWRfZmlsZVwoXHMqXCRpbWFnZSxccypkaXJuYW1lXChfX0ZJTEVfX1wpXHMqXC5ccypbJyJdL1snIl1ccypcLlxzKlwkIjtpOjQwNTtzOjM5OiJcJHN0cj0iPGgxPjQwMyBGb3JiaWRkZW48L2gxPjwhLS0gdG9rZW4iO2k6NDA2O3M6Njk6IkA/aW5jbHVkZV9vbmNlXHMqXChccypkaXJuYW1lXChfX0ZJTEVfX1wpXHMqXC5ccyonLydccypcLlxzKnVybGRlY29kZSI7aTo0MDc7czoxMTM6IlwkbG9jYWxwYXRoPWdldGVudlwoIlNDUklQVF9OQU1FIlwpO1wkYWJzb2x1dGVwYXRoPWdldGVudlwoIlNDUklQVF9GSUxFTkFNRSJcKTtcJHJvb3RfcGF0aD1zdWJzdHJcKFwkYWJzb2x1dGVwYXRoIjtpOjQwODtzOjEyNToiXCR0cGxccyo9XHMqXCR0cGxfcGF0aFw/XHMqQGZpbGVfZ2V0X2NvbnRlbnRzXChcJHJvb3RfcGF0aFwuXCR0cGxfcGF0aFwpOlxzKlsnIl1bJyJdO1xzKmlmIFwoc3RycG9zXChcJHRwbCxccypbJyJdXFtDT05URU5UXF0iO2k6NDA5O3M6MTk6Ii8vOnB0dGhbJyJdezAsMX1cKTsiO2k6NDEwO3M6OTc6IlwkW2EtekEtWjAtOV9dK1xzKj1ccypcJFthLXpBLVowLTlfXStcKFxzKlwkW2EtekEtWjAtOV9dK1xbXHMqXCRbYS16QS1aMC05X10rXFtccypcJFthLXpBLVowLTlfXSsiO2k6NDExO3M6MTQ6IlwkY2xvYWtub3JlZGlyIjtpOjQxMjtzOjQ0OiJPcHRpb25zXHMqXCtFeGVjQ0dJXHMqRm9yY2VUeXBlXHMqY2dpLXNjcmlwdCI7aTo0MTM7czo1NjoiXC5vcGVuXChbJyJdR0VUWyciXVxzKixccypbJyJdaHR0cDovL1xkK1wuXGQrXC5cZCtcLlxkKy8iO2k6NDE0O3M6MzA6InJlcXVpcmVccysiXCRkaXIvYmluL3Bzb2Nrc2QiOyI7aTo0MTU7czo0NjoiZXhwbG9kZVwoWyciXS4qP1snIl1ccyosXHMqZ3ppbmZsYXRlXChzdWJzdHJcKCI7aTo0MTY7czozNjoiZnB1dHNcKFxzKlwkXHd7MSw0NX1ccyosXHMqWyciXTwucGhwIjtpOjQxNztzOjY5OiJcJFx3ezEsNDV9XHMqPVxzKlwkXHd7MSw0NX1cKFsnIl1bJyJdXHMqLFxzKlwkXHd7MSw0NX1cKFxzKlwkXHd7MSw0NX0iO2k6NDE4O3M6NTY6IjtccypcJFx3ezEsNDV9PXN0cnJldlwoXHMqWyciXVx3ezEsNDV9WyciXVwpXHMqXC5ccypbJyJdIjtpOjQxOTtzOjQ2OiI8ZGl2PlwjY29udGVudFwjPC9kaXY+XHMqPGRpdj5cI2xpbmtzMlwjPC9kaXY+IjtpOjQyMDtzOjI4OiJuZXdccypDbHVlXFxQc29ja3NkXFxBcHBcKFwpIjtpOjQyMTtzOjE1OiJbJyJdL2V0Yy9wYXNzd2QiO2k6NDIyO3M6MTU6IlsnIl0vdmFyL2NwYW5lbCI7aTo0MjM7czoxNDoiWyciXS9ldGMvaHR0cGQiO2k6NDI0O3M6MjA6IlsnIl0vZXRjL25hbWVkXC5jb25mIjtpOjQyNTtzOjEzOiI4OVwuMjQ5XC4yMVwuIjtpOjQyNjtzOjE1OiIxMDlcLjIzOFwuMjQyXC4iO2k6NDI3O3M6NjU6IlxiKGluY2x1ZGV8aW5jbHVkZV9vbmNlfHJlcXVpcmV8cmVxdWlyZV9vbmNlKVxzKlwoP1xzKlsnIl1pbWFnZXMvIjtpOjQyODtzOjcxOiJcYihmdHBfZXhlY3xzeXN0ZW18c2hlbGxfZXhlY3xwYXNzdGhydXxwb3Blbnxwcm9jX29wZW4pXHMqXChAP3VybGVuY29kZSI7aTo0Mjk7czo3MToiXGIoZnRwX2V4ZWN8c3lzdGVtfHNoZWxsX2V4ZWN8cGFzc3RocnV8cG9wZW58cHJvY19vcGVuKVwoP1snIl1jZFxzKy90bXAiO2k6NDMwO3M6MjM6Ii92YXIvcW1haWwvYmluL3NlbmRtYWlsIjtpOjQzMTtzOjUxOiJcJFthLXpBLVowLTlfXSsgPSBcJFthLXpBLVowLTlfXStcKFsnIl17MCwxfWh0dHA6Ly8iO2k6NDMyO3M6MTU6IlsnIl1cKVwpXCk7IlwpOyI7aTo0MzM7czo5MjoiXCRbYS16QS1aMC05X10rPVsnIl1bYS16QS1aMC05L1wrXD1fXStbJyJdO1xzKmVjaG9ccytiYXNlNjRfZGVjb2RlXChcJFthLXpBLVowLTlfXStcKTtccypcPz4iO2k6NDM0O3M6NjI6IlwkW2EtekEtWjAtOV9dKy0+X3NjcmlwdHNcW1xzKmd6dW5jb21wcmVzc1woXHMqYmFzZTY0X2RlY29kZVwoIjtpOjQzNTtzOjM0OiJcJFthLXpBLVowLTlfXStccyo9XHMqWyciXWV2YWxbJyJdIjtpOjQzNjtzOjQzOiJcJFthLXpBLVowLTlfXStccyo9XHMqWyciXWJhc2U2NF9kZWNvZGVbJyJdIjtpOjQzNztzOjQ1OiJcJFthLXpBLVowLTlfXStccyo9XHMqWyciXWNyZWF0ZV9mdW5jdGlvblsnIl0iO2k6NDM4O3M6MzY6IlwkW2EtekEtWjAtOV9dK1xzKj1ccypbJyJdYXNzZXJ0WyciXSI7aTo0Mzk7czo0MjoiXCRbYS16QS1aMC05X10rXHMqPVxzKlsnIl1wcmVnX3JlcGxhY2VbJyJdIjtpOjQ0MDtzOjIxNjoiXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuXHMqIjtpOjQ0MTtzOjE1MDoiXCRbYS16QS1aMC05X10rXFtccypcJFthLXpBLVowLTlfXStccypcXVxbXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwuIjtpOjQ0MjtzOjQzOiJcJFthLXpBLVowLTlfXStccypcKFxzKlwkW2EtekEtWjAtOV9dK1xzKlxbIjtpOjQ0MztzOjYzOiJcJFthLXpBLVowLTlfXStccypcKFxzKlwkW2EtekEtWjAtOV9dK1xzKlwoXHMqXCRbYS16QS1aMC05X10rXFsiO2k6NDQ0O3M6NTA6IlwkW2EtekEtWjAtOV9dK1xzKlwoXHMqXCRbYS16QS1aMC05X10rXHMqXChccypbJyJdIjtpOjQ0NTtzOjcwOiJcJFthLXpBLVowLTlfXStccypcKFxzKlwkW2EtekEtWjAtOV9dK1xzKlwoXHMqXCRbYS16QS1aMC05X10rXHMqXClccyosIjtpOjQ0NjtzOjY5OiJcJFthLXpBLVowLTlfXStccypcKFxzKlsnIl1bJyJdXHMqLFxzKmV2YWxcKFwkW2EtekEtWjAtOV9dK1xzKlwpXHMqXCkiO2k6NDQ3O3M6MjM2OiJcJFthLXpBLVowLTlfXStccyo9XHMqXCRbYS16QS1aMC05X10rXChbJyJdWyciXVxzKixccypcJFthLXpBLVowLTlfXStcKFxzKlwkW2EtekEtWjAtOV9dK1woXHMqWyciXVthLXpBLVowLTlfXStbJyJdXHMqLFxzKlsnIl1bJyJdXHMqLFxzKlwkW2EtekEtWjAtOV9dK1xzKlwuXHMqXCRbYS16QS1aMC05X10rXHMqXC5ccypcJFthLXpBLVowLTlfXStccypcLlxzKlwkW2EtekEtWjAtOV9dK1xzKlwpXHMqXClccypcKSI7aTo0NDg7czoxNDM6IlwkW2EtekEtWjAtOV9dK1xzKj1ccypbJyJdXCRbYS16QS1aMC05X10rPUBbYS16QS1aMC05X10rXChbJyJdLis/WyciXVwpO1thLXpBLVowLTlfXStcKCFcJFthLXpBLVowLTlfXStcKXtcJFthLXpBLVowLTlfXSs9QFthLXpBLVowLTlfXStcKFxzKlwpIjtpOjQ0OTtzOjExNDoiXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVwoXHMqWyciXVsnIl1ccyosXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVwoXHMqXCRbYS16QS1aMC05X10rXFtccypcZCtccypcXVxzKlwpIjtpOjQ1MDtzOjMyOiJcJFthLXpBLVowLTlfXStcKFxzKkBcJF9DT09LSUVcWyI7aTo0NTE7czoyOToiXCRbYS16QS1aMC05X10rXChbJyJdLi5lWyciXSwiO2k6NDUyO3M6NzA6IkBcJFthLXpBLVowLTlfXSsmJkBcJFthLXpBLVowLTlfXStcKFwkW2EtekEtWjAtOV9dKyxcJFthLXpBLVowLTlfXStcKTsiO2k6NDUzO3M6MjM0OiJcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbXHMqWyciXVthLXpBLVowLTlfXStbJyJdXHMqXF1cKFxzKlxiKGV2YWx8YmFzZTY0X2RlY29kZXxzdHJyZXZ8cHJlZ19yZXBsYWNlfHByZWdfcmVwbGFjZV9jYWxsYmFja3x1cmxkZWNvZGV8c3Ryc3RyfGd6aW5mbGF0ZXxzcHJpbnRmfGd6dW5jb21wcmVzc3xhc3NlcnR8c3RyX3JvdDEzfG1kNXxhcnJheV93YWxrfGFycmF5X2ZpbHRlcikiO2k6NDU0O3M6MTg2OiJcYihldmFsfGJhc2U2NF9kZWNvZGV8c3RycmV2fHByZWdfcmVwbGFjZXxwcmVnX3JlcGxhY2VfY2FsbGJhY2t8dXJsZGVjb2RlfHN0cnN0cnxnemluZmxhdGV8c3ByaW50ZnxnenVuY29tcHJlc3N8YXNzZXJ0fHN0cl9yb3QxM3xtZDV8YXJyYXlfd2Fsa3xhcnJheV9maWx0ZXIpXChccypcJFthLXpBLVowLTlfXStcKFxzKlsnIl0iO2k6NDU1O3M6MjMzOiJAP1wkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtbJyJdW2EtekEtWjAtOV9dK1snIl1cXVwoXGIoZXZhbHxiYXNlNjRfZGVjb2RlfHN0cnJldnxwcmVnX3JlcGxhY2V8cHJlZ19yZXBsYWNlX2NhbGxiYWNrfHVybGRlY29kZXxzdHJzdHJ8Z3ppbmZsYXRlfHNwcmludGZ8Z3p1bmNvbXByZXNzfGFzc2VydHxzdHJfcm90MTN8bWQ1fGFycmF5X3dhbGt8YXJyYXlfZmlsdGVyKVwoWyciXSI7aTo0NTY7czoxODE6IlwkW2EtekEtWjAtOV9dKz1cJFthLXpBLVowLTlfXStcKFsnIl0uKz9bJyJdLFwkW2EtekEtWjAtOV9dKyxcJFthLXpBLVowLTlfXStcKTtcJFthLXpBLVowLTlfXSs9XCRbYS16QS1aMC05X10rXChcJFthLXpBLVowLTlfXSssXCRbYS16QS1aMC05X10rXCk7XCRbYS16QS1aMC05X10rXChcJFthLXpBLVowLTlfXStcKTsiO2k6NDU3O3M6MTMxOiJAP2FycmF5X21hcFwoQD9cJHtccypbJyJdXHd7MSw0NX1bJyJdXHMqfXtccypcd3sxLDQ1fVxzKn1ccyosXHMqYXJyYXlcKEA/XCRccyp7XHMqWyciXVx3ezEsNDV9WyciXVxzKn17XHMqWyciXVx3ezEsNDV9WyciXVxzKn1cKVwpOyI7aTo0NTg7czo2NToiQD9cJHtAP1snIl1cd3sxLDQ1fVsnIl19XFtcZCtcXVwoQD9cJHtbJyJdXHd7MSw0NX1bJyJdfVxbXGQrXF1cKToiO2k6NDU5O3M6ODU6Ilwke1snIl1cd3sxLDQ1fVsnIl19XFtbJyJdXHd7MSw0NX1bJyJdXF1cKFwke1snIl1cd3sxLDQ1fVsnIl19XFtbJyJdXHd7MSw0NX1bJyJdXF1cKTsiO2k6NDYwO3M6ODM6IkA/XCR7WyciXVx3ezEsNDV9WyciXX09QD9cJHtbJyJdXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpWyciXX07QD9cKFwoIjtpOjQ2MTtzOjg0OiJAP3JlZ2lzdGVyX3NodXRkb3duX2Z1bmN0aW9uXChAP1wke0A/WyciXV8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVsnIl0iO2k6NDYyO3M6NDc6IlwkXHd7MSw0NX17XGQrfVwoXCRcd3sxLDQ1fXtcZCt9XCk6QD9cJFx3ezEsNDV9IjtpOjQ2MztzOjQ4OiI7XCR7WyciXUdMT0JBTFNbJyJdfVxbWyciXVx3ezEsNDV9WyciXVxdXChcKTtcPz4iO2k6NDY0O3M6NzQ6ImlmXChpc3NldFwoXCRfQ09PS0lFXFtbJyJdXHd7MSw0NX1bJyJdXF1cKVwpe1xzKlwkY2g9Y3VybF9pbml0XChbJyJdaHR0cDovIjtpOjQ2NTtzOjEyMjoiaWZcKFwkcGFnZVxzKj1ccypcJF9HRVRcW1snIl1wWyciXVxdXClccyp7XHMqXCRleHRzXHMqPVxzKmFycmF5XCgiXC5odG1sIixccyoiXC5odG0iLFxzKiJcLnBocCJcKTtccyplcnJvcl9yZXBvcnRpbmdcKDBcKTsiO2k6NDY2O3M6OTQ6ImlmXHMqXChzdHJsZW5cKFwkbGlua1wpXHMqPlxzKlxkK1wpXHMqe1xzKlwkZnBccyo9XHMqQD9mb3BlblxzKlwoXHMqXCRjYWNoZVxzKixccypbJyJdd1snIl1cKTsiO2k6NDY3O3M6Njg6IlwkbGlua2VyXHMqPVxzKnN0cl9yZXBsYWNlXChbJyJdPHJlcGxhY2U+WyciXSxccypcJHBhcmFtLFxzKlwkbGlua2VyIjtpOjQ2ODtzOjg0OiJnZXRcKFsnIl1odHRwOi8vWyciXVwuXCRfQ09PS0lFXFtbJyJdXHd7MSw0NX1bJyJdXF1cLlsnIl0vXD9cd3sxLDQ1fT1bJyJdXC5cJF9DT09LSUUiO2k6NDY5O3M6NzU6ImlmXHMqXChjb3B5XChcJF9GSUxFU1xbWyciXVx3ezEsNDV9WyciXVxdXFtbJyJdXHd7MSw0NX1bJyJdXF0sXHMqXCRcd3sxLDQ1fSI7aTo0NzA7czo2OToiZXJyb3JfcmVwb3J0aW5nXChcZCtcKTtccypkZWZpbmVcKFsnIl1QQVNTV09SRFsnIl1ccyosXHMqWyciXVx3ezEsNDV9IjtpOjQ3MTtzOjc3OiJleHRyYWN0XChcJF9TRVJWRVJcKTtccyphcnJheV9maWx0ZXJcKFwoYXJyYXlcKVwkXHd7MSw0NX1ccyosXHMqXCRcd3sxLDQ1fVwpOyI7aTo0NzI7czo3MjoicmVnaXN0ZXJfc2h1dGRvd25fZnVuY3Rpb25ccypcKFwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpIjtpOjQ3MztzOjc2OiJcJHtcd3sxLDQ1fVwoWyciXS4qP1snIl1cKX1ccyo9XHMqXCR7XHd7MSw0NX1cKFsnIl0uKj9bJyJdXCl9XChcJHtcd3sxLDQ1fVwoIjtpOjQ3NDtzOjUxOiJcJFx3ezEsNDV9XFtccypjaHJcKFxzKlxkK1xzKlwpXHMqXF1cKFxzKlx3ezEsNDV9XCgiO2k6NDc1O3M6MTE4OiJcJHBhdGg9XCRfU0VSVkVSXFtbJyJdRE9DVU1FTlRfUk9PVFsnIl1cXVwuWyciXVthLXpBLVowLTlfXStbJyJdO1xcc1wqaW5jbHVkZVwoXCRwYXRoXC5cJF9HRVRcW1snIl1wWyciXVxdXCk7XFxzXCpkaWU7IjtpOjQ3NjtzOjQyOiJmdW5jdGlvbiBDcmVhdGVMaW5rXChcJGRpcixcJHJlcGxhY2VzdHIxXCkiO2k6NDc3O3M6MTA0OiJcJGZwXHMqPVxzKmZzb2Nrb3BlblwoWyciXXVkcDovL1wkaG9zdFsnIl1ccyosXHMqXCRwb3J0LFxzKlwkZXJybm8sXHMqXCRlcnJzdHIsXHMqXGQrXHMqXCk7XHMqaWZcKFwkZnBcKSI7aTo0Nzg7czo1ODoiO1xzKmluY2x1ZGVfb25jZVwoXHMqc3lzX2dldF90ZW1wX2RpclwoXClccypcLlxzKlsnIl0vU0VTUyI7aTo0Nzk7czo3ODoiXCR1cmxccyo9XHMqWyciXXJlZmVyZXI6WyciXVwuc3RydG9sb3dlclwoXCRfU0VSVkVSXFtbJyJdSFRUUF9SRUZFUkVSWyciXVxdXCk7IjtpOjQ4MDtzOjk1OiJcJGlwXHMqPVxzKlwkX1NFUlZFUlxbWyciXVJFTU9URV9BRERSWyciXVxdO1xzKlwkdXJsXHMqPVxzKlwkX0dFVFxbWyciXWlkWyciXVxdO1xzKlwkdGFyZ2V0XHMqPSI7aTo0ODE7czo4MjoiUmV3cml0ZVJ1bGVccypcXlwoXFtBLVphLXowLTktXF1cK1wpXC5odG1sXCRccypcd3sxLDQ1fVwucGhwXD9cd3sxLDQ1fT1cJDFccypcW0xcXSI7aTo0ODI7czo4MToiZmlsZV9wdXRfY29udGVudHNcKFwkZGlyXC5bJyJdL1snIl1cLlwkZmlsZSxccypcJHRlbXBzdHJcKTtccyplY2hvXHMqWyciXWxpbmtieW1lIjtpOjQ4MztzOjU3OiJpZlwoc3RycG9zXChcJHF1ZXJ5U3RyLFsnIl1hY3Rpb249c2l0ZW1hcFsnIl1cKSE9PWZhbHNlXCkiO2k6NDg0O3M6Mzk6IkVuY29kZVxzK2J5XHMraHR0cDovL1d3d1wuUEhQSmlhTWlcLkNvbSI7aTo0ODU7czo4MToiXCRbYS16QS1aMC05X10rXChccypcJFthLXpBLVowLTlfXStccypcKFxzKlwkW2EtekEtWjAtOV9dK1xzKlwuXHMqXCRbYS16QS1aMC05X10rIjtpOjQ4NjtzOjU3OiJlY2hvXHMqWyciXWdvb2dsZS1zaXRlLXZlcmlmaWNhdGlvbjpccypnb29nbGVbJyJdXC5cJF9HRVQiO2k6NDg3O3M6Mjc6ImZpbHRlcl92YXJccypcKFxzKlwkX1NFUlZFUiI7aTo0ODg7czoyNDoiUGx1Z2luIE5hbWU6XHMqV1BDb3JlU3lzIjtpOjQ4OTtzOjgzOiItPkF1dGhvcml6ZVxzKlwoXHMqXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUylcW1snIl1cd3sxLDQ1fVsnIl1cXVwpOyI7aTo0OTA7czo0NToiLT5BdXRob3JpemVccypcKFxzKlsnIl17MCwxfVxkK1snIl17MCwxfVxzKlwpIjtpOjQ5MTtzOjM3OiJcJFVTRVItPkF1dGhvcml6ZVwoXHMqXCRcd3sxLDQ1fVxzKlwpIjtpOjQ5MjtzOjI2OiJDcmVkaXRccypDYXJkXHMqPFx3ezEsNDV9QCI7aTo0OTM7czo4MjoiXCRcd3sxLDQ1fVxzKj1ccypcJFx3ezEsNDV9XChbJyJdWyciXVxzKixccypcJFx3ezEsNDV9XHMqXCk7XHMqQFwkXHd7MSw0NX1cKFxzKlwpOyI7aTo0OTQ7czo1NDoiY2FsbF91c2VyX2Z1bmNcKFxzKmNyZWF0ZV9mdW5jdGlvblwoXHMqbnVsbFxzKixccypwYWNrIjtpOjQ5NTtzOjUzOiJmaWxlX2dldF9jb250ZW50c1woXHMqcGFja1woXHMqWyciXUhcKlsnIl1ccyosXHMqam9pbiI7aTo0OTY7czo0NzoicGFja1woWyciXUgxMzBbJyJdLFwkaGVhZGVyXHMqXC5ccypbJyJdXHd7MSw0NX0iO2k6NDk3O3M6NzQ6IlxiKGluY2x1ZGV8aW5jbHVkZV9vbmNlfHJlcXVpcmV8cmVxdWlyZV9vbmNlKVxzKlwoXHMqWyciXXBocDovL2lucHV0WyciXVwpIjtpOjQ5ODtzOjc3OiJcJFx3ezEsNDV9XChccypcJFxzKntccypbJyJdXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpWyciXX1ccypcWyI7aTo0OTk7czoxMTQ6IlwkX1x3ezEsNDV9XHMqPVxzKlwkX1x3ezEsNDV9XChccypcZCtccypcKVxzKlwuXHMqXCRfXHd7MSw0NX1cKFxzKlxkK1xzKlwpXHMqXC5ccypcJF9cd3sxLDQ1fVwoXHMqXGQrXHMqXClccypcLlxzKiI7aTo1MDA7czoxNzoiPVsnIl1cKVwpO1snIl1cKTsiO2k6NTAxO3M6NDg6IkBhc3NlcnRfb3B0aW9uc1woXHMqQVNTRVJUX1FVSUVUX0VWQUxccyosXHMqMVwpOyI7aTo1MDI7czo2ODoiYXJyYXlfZmlsdGVyXChccyphcnJheVwoXHMqXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUykiO2k6NTAzO3M6MTA2OiJmaWx0ZXJfdmFyXChccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKXtccypcd3sxLDQ1fVxzKn1ccyosXHMqRklMVEVSX0NBTExCQUNLXHMqLFxzKmFycmF5IjtpOjUwNDtzOjQ2OiJwcmVnX21hdGNoX2FsbFwoIi88SWZNb2R1bGVcXHNcK21vZF9yZXdyaXRlXC5jIjtpOjUwNTtzOjIzOiI8dGl0bGU+U2hlbGxccytVcGxvYWRlciI7aTo1MDY7czo3NDoiXD9vcHRpb249Y29tX2NvbmZpZyZ2aWV3PWNvbXBvbmVudCZjb21wb25lbnQ9Y29tX21lZGlhJnBhdGgmdG1wbD1jb21wb25lbnQiO2k6NTA3O3M6MzA6Ijx0aXRsZT53aG9pc3RvcnlcLmNvbVxzK3BhcnNlciI7aTo1MDg7czoyOToibXllY2hvXChccypbJyJdU2hlbGxccyt1cGxvYWQiO2k6NTA5O3M6Nzc6ImFycmF5X21hcFwoXHMqY3JlYXRlX2Z1bmN0aW9uXChccypbJyJdWyciXVxzKixcJFx3ezEsNDV9XCksYXJyYXlcKFxzKlsnIl1bJyJdIjtpOjUxMDtzOjQzOiJ0cmlnZ2VyX2Vycm9yXHMqXChcJDxzcD5ccyosXHMqRV9VU0VSX0VSUk9SIjtpOjUxMTtzOjg0OiJpdGVyYXRvcl9hcHBseVxzKlwoXHMqXCRcd3sxLDQ1fVxzKixccypcJFx3ezEsNDV9XHMqLFxzKmFycmF5XHMqXChccypcJFx3ezEsNDV9XHMqXCkiO2k6NTEyO3M6Nzk6ImFycmF5X21hcFxzKlwoXHMqXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUylcW1xzKlsnIl08d3BbJyJdXHMqXF0iO2k6NTEzO3M6OTM6ImNyZWF0ZV9mdW5jdGlvblwoWyciXVsnIl1ccyosXHMqXCRcd3sxLDQ1fXtcZCt9XHMqXC5ccypcJFx3ezEsNDV9e1xkK31ccypcLlxzKlwkXHd7MSw0NX17XGQrfSI7aTo1MTQ7czo1NDoiYWRkX2FjdGlvblwoWyciXXdwX2Zvb3RlclsnIl1ccyosXHMqWyciXXdwX2Z1bmNfanF1ZXJ5IjtpOjUxNTtzOjY5OiJmb3BlblwoXHMqYmFzZTY0X2RlY29kZVwoXHMqXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUykiO2k6NTE2O3M6OTI6IlwkW2EtekEtWjAtOV9dK1xzKj1ccypcJFthLXpBLVowLTlfXStcKFxzKlsnIl1ccypbJyJdXHMqLFxzKlwkW2EtekEtWjAtOV9dK1wpO1xzKlwkbFwoXHMqXCk7IjtpOjUxNztzOjM2OiJyZXF1aXJlXHMqWyciXVwkZGlyL2Jpbi9wc29ja3NkWyciXTsiO2k6NTE4O3M6MTcxOiJcJFthLXpBLVowLTlfXStccyo9XHMqYXJyYXlcKFxzKlwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtccypbJyJdW2EtekEtWjAtOV9dK1snIl1ccypcXVxzKlwpO1xzKkA/YXJyYXlfZmlsdGVyXChcJFthLXpBLVowLTlfXStccyosXHMqXCRbYS16QS1aMC05X10rXHMqXCkiO2k6NTE5O3M6MTAyOiJpZlwoaXNfb2JqZWN0XChcJF9TRVNTSU9OXFsiX19kZWZhdWx0IlxdXFsidXNlciJcXVwpXHMqJiZccyohXChcJF9TRVNTSU9OXFsiX19kZWZhdWx0IlxdXFsidXNlciJcXS0+aWQiO2k6NTIwO3M6MTY6Ilwke1wke1snIl1cXHhcZCsiO2k6NTIxO3M6NTU6InJldHVyblxzKlwkXHd7MSw0NX1ccypcXlxzKnN0cl9yZXBlYXRccypcKFxzKlwkXHd7MSw0NX0iO2k6NTIyO3M6MTM2OiJcYihpbmNsdWRlfGluY2x1ZGVfb25jZXxyZXF1aXJlfHJlcXVpcmVfb25jZSlccypcKD9ccypcJF9TRVJWRVJcW1snIl17MCwxfURPQ1VNRU5UX1JPT1RbJyJdezAsMX1cXVxzKlwuXHMqWyciXVtccyVcLkBcLVwrXChcKS9cd10rP1wuanBnIjtpOjUyMztzOjEzNjoiXGIoaW5jbHVkZXxpbmNsdWRlX29uY2V8cmVxdWlyZXxyZXF1aXJlX29uY2UpXHMqXCg/XHMqXCRfU0VSVkVSXFtbJyJdezAsMX1ET0NVTUVOVF9ST09UWyciXXswLDF9XF1ccypcLlxzKlsnIl1bXHMlXC5AXC1cK1woXCkvXHddKz9cLmdpZiI7aTo1MjQ7czoxMzY6IlxiKGluY2x1ZGV8aW5jbHVkZV9vbmNlfHJlcXVpcmV8cmVxdWlyZV9vbmNlKVxzKlwoP1xzKlwkX1NFUlZFUlxbWyciXXswLDF9RE9DVU1FTlRfUk9PVFsnIl17MCwxfVxdXHMqXC5ccypbJyJdW1xzJVwuQFwtXCtcKFwpL1x3XSs/XC5wbmciO2k6NTI1O3M6MTA2OiJcYihpbmNsdWRlfGluY2x1ZGVfb25jZXxyZXF1aXJlfHJlcXVpcmVfb25jZSlccypcKD9ccypbJyJdW1xzJVwuQFwtXCtcKFwpL1x3XSs/L1tccyVcLkBcLVwrXChcKS9cd10rP1wucG5nIjtpOjUyNjtzOjEwNjoiXGIoaW5jbHVkZXxpbmNsdWRlX29uY2V8cmVxdWlyZXxyZXF1aXJlX29uY2UpXHMqXCg/XHMqWyciXVtccyVcLkBcLVwrXChcKS9cd10rPy9bXHMlXC5AXC1cK1woXCkvXHddKz9cLmpwZyI7aTo1Mjc7czoxMDY6IlxiKGluY2x1ZGV8aW5jbHVkZV9vbmNlfHJlcXVpcmV8cmVxdWlyZV9vbmNlKVxzKlwoP1xzKlsnIl1bXHMlXC5AXC1cK1woXCkvXHddKz8vW1xzJVwuQFwtXCtcKFwpL1x3XSs/XC5naWYiO2k6NTI4O3M6MTA2OiJcYihpbmNsdWRlfGluY2x1ZGVfb25jZXxyZXF1aXJlfHJlcXVpcmVfb25jZSlccypcKD9ccypbJyJdW1xzJVwuQFwtXCtcKFwpL1x3XSs/L1tccyVcLkBcLVwrXChcKS9cd10rP1wuaWNvIjtpOjUyOTtzOjEwODoiXGIoaW5jbHVkZXxpbmNsdWRlX29uY2V8cmVxdWlyZXxyZXF1aXJlX29uY2UpXHMqXChccypkaXJuYW1lXChccypfX0ZJTEVfX1xzKlwpXHMqXC5ccypbJyJdL3dwLWNvbnRlbnQvdXBsb2FkIjtpOjUzMDtzOjY3OiJcYihpbmNsdWRlfGluY2x1ZGVfb25jZXxyZXF1aXJlfHJlcXVpcmVfb25jZSlccypcKD9ccypbJyJdL3Zhci93d3cvIjtpOjUzMTtzOjY0OiJcYihpbmNsdWRlfGluY2x1ZGVfb25jZXxyZXF1aXJlfHJlcXVpcmVfb25jZSlccypcKD9ccypbJyJdL2hvbWUvIjtpOjUzMjtzOjIzNzoiXGIoZXZhbHxiYXNlNjRfZGVjb2RlfHN0cnJldnxwcmVnX3JlcGxhY2V8cHJlZ19yZXBsYWNlX2NhbGxiYWNrfHVybGRlY29kZXxzdHJzdHJ8Z3ppbmZsYXRlfHNwcmludGZ8Z3p1bmNvbXByZXNzfGFzc2VydHxzdHJfcm90MTN8bWQ1fGFycmF5X3dhbGt8YXJyYXlfZmlsdGVyKVwoXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUylcW1snIl17MCwxfVthLXpBLVowLTlfXStbJyJdezAsMX1cXVwpIjtpOjUzMztzOjI1MDoiXGIoZXZhbHxhc3NlcnR8XCRcd3sxLDQwfShcW1teXV17MSwxMH1cXVxzKil7MCw0fXxcJFx3ezEsNDB9KFx7W159XXsxLDEwfVx9XHMqKXswLDR9KVxzKlwoXHMqXGIoZXZhbHxiYXNlNjRfZGVjb2RlfHN0cnJldnxwcmVnX3JlcGxhY2V8cHJlZ19yZXBsYWNlX2NhbGxiYWNrfHVybGRlY29kZXxzdHJzdHJ8Z3ppbmZsYXRlfHNwcmludGZ8Z3p1bmNvbXByZXNzfGFzc2VydHxzdHJfcm90MTN8bWQ1fGFycmF5X3dhbGt8YXJyYXlfZmlsdGVyKSI7aTo1MzQ7czo0MzoiPVxzKndwX2luc2VydF91c2VyXChccypcJFthLXpBLVowLTlfXStccypcKSI7aTo1MzU7czo1NDoiXCR3cF90ZW1wbGF0ZVxzKj1ccypAP3ByZWdfcmVwbGFjZVwoWyciXS8uKz8vXFx4NjVbJyJdIjtpOjUzNjtzOjY2OiJcKFwkXyhHRVR8UE9TVHxTRVJWRVJ8Q09PS0lFfFJFUVVFU1R8RklMRVMpXFtccypiYXNlNjRfZGVjb2RlXHMqXCgiO2k6NTM3O3M6NzE6Ilwkd3BhdXRvcFxzKj1ccypwcmVfdGVybV9uYW1lXChccypcJHdwX2tzZXNfZGF0YVxzKixccypcJHdwX25vbmNlXHMqXCk7IjtpOjUzODtzOjI1OiI8XD9ccyplY2hvXHMqXGQrXCtcZCs7XD8+IjtpOjUzOTtzOjgwOiJpZlwoXHMqXCRfKEdFVHxQT1NUfFNFUlZFUnxDT09LSUV8UkVRVUVTVHxGSUxFUylcW1snIl1pZFsnIl1cXVxzKj09XHMqWyciXXRlbXBJZCI7aTo1NDA7czoyMzoiZWNob1xzKiJmaWxlIHRlc3Qgb2theSIiO2k6NTQxO3M6Mzg6IkBcJHtbYS16QS1aMC05X10rfVwoXCRbYS16QS1aMC05X10rXCk7IjtpOjU0MjtzOjI4OiJyZXF1aXJlICJcJGRpci9iaW4vcHNvY2tzZCI7IjtpOjU0MztzOjE2NToiXCRbYS16QS1aMC05X10rXHMqPVxzKmFycmF5XChccypcJF8oR0VUfFBPU1R8U0VSVkVSfENPT0tJRXxSRVFVRVNUfEZJTEVTKVxbXHMqWyciXVthLXpBLVowLTlfXStbJyJdXHMqXF1cKTtccypAYXJyYXlfZmlsdGVyXChcJFthLXpBLVowLTlfXStccyosXHMqXCRbYS16QS1aMC05X10rXCk7IjtpOjU0NDtzOjM2OiJjaHJcKFxkKy5cZCtcKVxzKlwuXHMqY2hyXChcZCsuXGQrXCkiO2k6NTQ1O3M6NzA6Ilwke1thLXpBLVowLTlfXStcKFsnIl1bYS16QS1aMC05X10rWyciXVwpfVxzKj1ccypcJHtccypbYS16QS1aMC05X10rXCgiO2k6NTQ2O3M6NTk6IlxiKGluY2x1ZGV8aW5jbHVkZV9vbmNlfHJlcXVpcmV8cmVxdWlyZV9vbmNlKVxzKlwoQD9pbmlfZ2V0IjtpOjU0NztzOjE3OiJcJGRpci9iaW4vcHNvY2tzZCI7aTo1NDg7czoyMToiYXRccytub3dccystZlxzKzFcLnNoIjtpOjU0OTtzOjEwNzoiXCRcd3sxLDQ1fVxzKj1ccypcJFx3ezEsNDV9XChccypbJyJdXCRfXHd7MSw0NX1bJyJdXHMqLFxzKlwkX1x3ezEsNDV9XCk7XHMqXCRcd3sxLDQ1fVwoXHMqXCRfXHd7MSw0NX1ccypcKTsiO2k6NTUwO3M6NDA6IlsnIl1ccypcLlxzKnBocF91bmFtZVwoXHMqXClccypcLlxzKlsnIl0iO2k6NTUxO3M6Mzg6IjtccypmcHV0c1woXCRcd3sxLDQ1fVxzKixccypbJyJdPFw/cGhwIjtpOjU1MjtzOjc2OiJ3aGlsZVxzKlwoXHMqQG9iX2VuZF9jbGVhblwoXHMqXClccypcKTtccypoZWFkZXJcKFsnIl1jb250ZW50LXR5cGU6dGV4dC94bWw7IjtpOjU1MztzOjI3OiJnaXRcLm9zY2hpbmFcLm5ldC9tei9tenBocDIiO2k6NTU0O3M6MzQ6ImZpbGVfZ2V0X2NvbnRlbnRzXChbJyJddGVtcElkXC5waHAiO2k6NTU1O3M6NTU6IjtcJFx3ezEsNDV9XHMqPVxzKnBhY2tcKFxzKlsnIl1IXCpbJyJdLFsnIl1cd3sxLDQ1fVsnIl0iO2k6NTU2O3M6Mjc6ImluY2x1ZGVccypcJHtccypcJFx3ezEsNDV9fSI7aTo1NTc7czoyNjoiU21hcnR5Mzo6cmVkaXJlY3RcKFsnIl1cXHgiO2k6NTU4O3M6MTc6IjxcP3BocFxzK1wke1snIl1HIjtpOjU1OTtzOjE5OiI8XD9waHBccytcJHtbJyJdXFx4IjtpOjU2MDtzOjE5OiJNSUxETkVUXFxzXCtTQ0FOTkVSIjtpOjU2MTtzOjY3OiI9XFsiJ1xdXC57MSwxMH1cWyciXF1cXHNcKlxbXFxcXiZcfFxdXFsnIlxdXC57MSwxMH1cWyciXF1cWztcXFwuL1xdIjtpOjU2MjtzOjY3OiIvXFxcKlwoXFx3XCtcKVxcXCovXFxzXCpAaW5jbHVkZVxcc1wqIlxbXF4iXF1cKyI7XFxzXCovXFxcKlxcMVxcXCovIjtpOjU2MztzOjEwMjoiXFxcJFxcc1wqXFx7XFxzXCoiXFtcXiJcXVwqIlxcc1wqXFx9XFxzXCpcXFxbXFxzXCoiXFtcXiJcXVwqIlxcc1wqXFxcXVxcc1wqPSJcW1xeIlxdXCoiXFxzXCo7XFxzXCpcXFwkIjt9"));
$g_ExceptFlex = unserialize(base64_decode("YToxNDY6e2k6MDtzOjY2OiJyZXF1aXJlXHMqXCg/XHMqXCRfU0VSVkVSXFtccypbJyJdezAsMX1ET0NVTUVOVF9ST09UWyciXXswLDF9XHMqXF0iO2k6MTtzOjcxOiJyZXF1aXJlX29uY2VccypcKD9ccypcJF9TRVJWRVJcW1xzKlsnIl17MCwxfURPQ1VNRU5UX1JPT1RbJyJdezAsMX1ccypcXSI7aToyO3M6NjY6ImluY2x1ZGVccypcKD9ccypcJF9TRVJWRVJcW1xzKlsnIl17MCwxfURPQ1VNRU5UX1JPT1RbJyJdezAsMX1ccypcXSI7aTozO3M6NzE6ImluY2x1ZGVfb25jZVxzKlwoP1xzKlwkX1NFUlZFUlxbXHMqWyciXXswLDF9RE9DVU1FTlRfUk9PVFsnIl17MCwxfVxzKlxdIjtpOjQ7czo2MToiaW5jbHVkZV9vbmNlXChcJF9TRVJWRVJcWydET0NVTUVOVF9ST09UJ1xdXC4nL2JpdHJpeC9tb2R1bGVzLyI7aTo1O3M6NTk6InJlcXVpcmVcKFwkX1NFUlZFUlxbIkRPQ1VNRU5UX1JPT1QiXF1cLiIvYml0cml4L2hlYWRlclwucGhwIjtpOjY7czo1OToicmVxdWlyZVwoXCRfU0VSVkVSXFsiRE9DVU1FTlRfUk9PVCJcXVwuIi9iaXRyaXgvZm9vdGVyXC5waHAiO2k6NztzOjM3OiJlY2hvICI8c2NyaXB0PiBhbGVydFwoJyJcLlwkZGItPmdldEVyIjtpOjg7czo0MDoiZWNobyAiPHNjcmlwdD4gYWxlcnRcKCciXC5cJG1vZGVsLT5nZXRFciI7aTo5O3M6ODoic29ydFwoXCkiO2k6MTA7czoxMDoibXVzdC1yZXZhbCI7aToxMTtzOjY6InJpZXZhbCI7aToxMjtzOjk6ImRvdWJsZXZhbCI7aToxMztzOjE3OiJcJHNtYXJ0eS0+X2V2YWxcKCI7aToxNDtzOjMwOiJwcmVwXHMrcm1ccystcmZccysle2J1aWxkcm9vdH0iO2k6MTU7czoyMjoiVE9ETzpccytybVxzKy1yZlxzK3RoZSI7aToxNjtzOjI3OiJrcnNvcnRcKFwkd3BzbWlsaWVzdHJhbnNcKTsiO2k6MTc7czo2MzoiZG9jdW1lbnRcLndyaXRlXCh1bmVzY2FwZVwoIiUzQ3NjcmlwdCBzcmM9JyIgXCsgZ2FKc0hvc3QgXCsgImdvIjtpOjE4O3M6NjoiXC5leGVjIjtpOjE5O3M6ODoiZXhlY1woXCkiO2k6MjA7czoyMjoiXCR4MT1cJHRoaXMtPncgLSBcJHgxOyI7aToyMTtzOjMxOiJhc29ydFwoXCRDYWNoZURpck9sZEZpbGVzQWdlXCk7IjtpOjIyO3M6MTM6IlwoJ3I1N3NoZWxsJywiO2k6MjM7czoyMzoiZXZhbFwoImxpc3RlbmVyPSJcK2xpc3QiO2k6MjQ7czo4OiJldmFsXChcKSI7aToyNTtzOjMzOiJwcmVnX3JlcGxhY2VfY2FsbGJhY2tcKCcvXFx7XChpbWEiO2k6MjY7czoyMDoiZXZhbFwoX2N0TWVudUluaXRTdHIiO2k6Mjc7czoyOToiYmFzZTY0X2RlY29kZVwoXCRhY2NvdW50S2V5XCkiO2k6Mjg7czozODoiYmFzZTY0X2RlY29kZVwoXCRkYXRhXClcKTtcJGFwaS0+c2V0UmUiO2k6Mjk7czo0ODoicmVxdWlyZVwoXCRfU0VSVkVSXFtcXCJET0NVTUVOVF9ST09UXFwiXF1cLlxcIi9iIjtpOjMwO3M6NjQ6ImJhc2U2NF9kZWNvZGVcKFwkX1JFUVVFU1RcWydwYXJhbWV0ZXJzJ1xdXCk7aWZcKENoZWNrU2VyaWFsaXplZEQiO2k6MzE7czo2MToicGNudGxfZXhlYyc9PiBBcnJheVwoQXJyYXlcKDFcKSxcJGFyUmVzdWx0XFsnU0VDVVJJTkdfRlVOQ1RJTyI7aTozMjtzOjM5OiJlY2hvICI8c2NyaXB0PmFsZXJ0XCgnIlwuQ1V0aWw6OkpTRXNjYXAiO2k6MzM7czo2NjoiYmFzZTY0X2RlY29kZVwoXCRfUkVRVUVTVFxbJ3RpdGxlX2NoYW5nZXJfbGluaydcXVwpO2lmXChzdHJsZW5cKFwkIjtpOjM0O3M6NDQ6ImV2YWxcKCdcJGhleGR0aW1lPSInXC5cJGhleGR0aW1lXC4nIjsnXCk7XCRmIjtpOjM1O3M6NTI6ImVjaG8gIjxzY3JpcHQ+YWxlcnRcKCdcJHJvdy0+dGl0bGUgLSAiXC5fTU9EVUxFX0lTX0UiO2k6MzY7czozNzoiZWNobyAiPHNjcmlwdD5hbGVydFwoJ1wkY2lkcyAiXC5fQ0FOTiI7aTozNztzOjM3OiJpZlwoMVwpe1wkdl9ob3VyPVwoXCRwX2hlYWRlclxbJ210aW1lIjtpOjM4O3M6Njg6ImRvY3VtZW50XC53cml0ZVwodW5lc2NhcGVcKCIlM0NzY3JpcHQlMjBzcmM9JTIyaHR0cCIgXCtcKFwoImh0dHBzOiI9IjtpOjM5O3M6NTc6ImRvY3VtZW50XC53cml0ZVwodW5lc2NhcGVcKCIlM0NzY3JpcHQgc3JjPSciIFwrIHBrQmFzZVVSTCI7aTo0MDtzOjMyOiJlY2hvICI8c2NyaXB0PmFsZXJ0XCgnIlwuSlRleHQ6OiI7aTo0MTtzOjI0OiInZmlsZW5hbWUnXCksXCgncjU3c2hlbGwiO2k6NDI7czozOToiZWNobyAiPHNjcmlwdD5hbGVydFwoJyJcLlwkZXJyTXNnXC4iJ1wpIjtpOjQzO3M6NDI6ImVjaG8gIjxzY3JpcHQ+YWxlcnRcKFxcIkVycm9yIHdoZW4gbG9hZGluZyI7aTo0NDtzOjQzOiJlY2hvICI8c2NyaXB0PmFsZXJ0XCgnIlwuSlRleHQ6Ol9cKCdWQUxJRF9FIjtpOjQ1O3M6ODoiZXZhbFwoXCkiO2k6NDY7czo4OiInc3lzdGVtJyI7aTo0NztzOjY6IidldmFsJyI7aTo0ODtzOjY6IiJldmFsIiI7aTo0OTtzOjc6Il9zeXN0ZW0iO2k6NTA7czo5OiJzYXZlMmNvcHkiO2k6NTE7czoxMDoiZmlsZXN5c3RlbSI7aTo1MjtzOjg6InNlbmRtYWlsIjtpOjUzO3M6ODoiY2FuQ2htb2QiO2k6NTQ7czoxMzoiL2V0Yy9wYXNzd2RcKSI7aTo1NTtzOjI0OiJ1ZHA6Ly8nXC5zZWxmOjpcJF9jX2FkZHIiO2k6NTY7czozMzoiZWRvY2VkXzQ2ZXNhYlwoJydcfCJcKVxcXCknLCdyZWdlIjtpOjU3O3M6OToiZG91YmxldmFsIjtpOjU4O3M6MTY6Im9wZXJhdGluZyBzeXN0ZW0iO2k6NTk7czoxMDoiZ2xvYmFsZXZhbCI7aTo2MDtzOjE5OiJ3aXRoIDAvMC8wIGlmXCgxXCl7IjtpOjYxO3M6NDY6IlwkeDI9XCRwYXJhbVxbWyciXXswLDF9eFsnIl17MCwxfVxdIFwrIFwkd2lkdGgiO2k6NjI7czo5OiJzcGVjaWFsaXMiO2k6NjM7czo4OiJjb3B5XChcKSI7aTo2NDtzOjE5OiJ3cF9nZXRfY3VycmVudF91c2VyIjtpOjY1O3M6NzoiLT5jaG1vZCI7aTo2NjtzOjc6Il9tYWlsXCgiO2k6Njc7czo3OiJfY29weVwoIjtpOjY4O3M6NzoiJmNvcHlcKCI7aTo2OTtzOjQ1OiJzdHJwb3NcKFwkX1NFUlZFUlxbJ0hUVFBfVVNFUl9BR0VOVCdcXSwnRHJ1cGEiO2k6NzA7czoxNjoiZXZhbFwoY2xhc3NTdHJcKSI7aTo3MTtzOjMxOiJmdW5jdGlvbl9leGlzdHNcKCdiYXNlNjRfZGVjb2RlIjtpOjcyO3M6NDQ6ImVjaG8gIjxzY3JpcHQ+YWxlcnRcKCciXC5KVGV4dDo6X1woJ1ZBTElEX0VNIjtpOjczO3M6NDM6IlwkeDE9XCRtaW5feDtcJHgyPVwkbWF4X3g7XCR5MT1cJG1pbl95O1wkeTIiO2k6NzQ7czo0ODoiXCRjdG1cWydhJ1xdXClcKXtcJHg9XCR4IFwqIFwkdGhpcy0+aztcJHk9XChcJHRoIjtpOjc1O3M6NTk6IlsnIl17MCwxfWNyZWF0ZV9mdW5jdGlvblsnIl17MCwxfSxbJyJdezAsMX1nZXRfcmVzb3VyY2VfdHlwIjtpOjc2O3M6NDg6IlsnIl17MCwxfWNyZWF0ZV9mdW5jdGlvblsnIl17MCwxfSxbJyJdezAsMX1jcnlwdCI7aTo3NztzOjY4OiJzdHJwb3NcKFwkX1NFUlZFUlxbWyciXXswLDF9SFRUUF9VU0VSX0FHRU5UWyciXXswLDF9XF0sWyciXXswLDF9THlueCI7aTo3ODtzOjY3OiJzdHJzdHJcKFwkX1NFUlZFUlxbWyciXXswLDF9SFRUUF9VU0VSX0FHRU5UWyciXXswLDF9XF0sWyciXXswLDF9TVNJIjtpOjc5O3M6MjU6InNvcnRcKFwkRGlzdHJpYnV0aW9uXFtcJGsiO2k6ODA7czoyNToic29ydFwoZnVuY3Rpb25cKGEsYlwpe3JldCI7aTo4MTtzOjI1OiJodHRwOi8vd3d3XC5mYWNlYm9va1wuY29tIjtpOjgyO3M6MjU6Imh0dHA6Ly9tYXBzXC5nb29nbGVcLmNvbS8iO2k6ODM7czo0ODoidWRwOi8vJ1wuc2VsZjo6XCRjX2FkZHIsODAsXCRlcnJubyxcJGVycnN0ciwxNTAwIjtpOjg0O3M6MjA6IlwoXC5cKlwodmlld1wpXD9cLlwqIjtpOjg1O3M6NDQ6ImVjaG8gWyciXXswLDF9PHNjcmlwdD5hbGVydFwoWyciXXswLDF9XCR0ZXh0IjtpOjg2O3M6MTc6InNvcnRcKFwkdl9saXN0XCk7IjtpOjg3O3M6NzU6Im1vdmVfdXBsb2FkZWRfZmlsZVwoXCRfRklMRVNcWyd1cGxvYWRlZF9wYWNrYWdlJ1xdXFsndG1wX25hbWUnXF0sXCRtb3NDb25maSI7aTo4ODtzOjEyOiJmYWxzZVwpXCk7XCMiO2k6ODk7czo0Njoic3RycG9zXChcJF9TRVJWRVJcWydIVFRQX1VTRVJfQUdFTlQnXF0sJ01hYyBPUyI7aTo5MDtzOjUwOiJkb2N1bWVudFwud3JpdGVcKHVuZXNjYXBlXCgiJTNDc2NyaXB0IHNyYz0nL2JpdHJpeCI7aTo5MTtzOjI1OiJcJF9TRVJWRVIgXFsiUkVNT1RFX0FERFIiIjtpOjkyO3M6MTc6ImFIUjBjRG92TDJOeWJETXVaIjtpOjkzO3M6NTQ6IkpSZXNwb25zZTo6c2V0Qm9keVwocHJlZ19yZXBsYWNlXChcJHBhdHRlcm5zLFwkcmVwbGFjZSI7aTo5NDtzOjg6Ih+LCAAAAAAAIjtpOjk1O3M6ODoiUEsFBgAAAAAiO2k6OTY7czoxNDoiCQoLDA0gLz5cXVxbXF4iO2k6OTc7czo4OiKJUE5HDQoaCiI7aTo5ODtzOjEwOiJcKTtcI2knLCcmIjtpOjk5O3M6MTU6IlwpO1wjbWlzJywnJyxcJCI7aToxMDA7czoxOToiXCk7XCNpJyxcJGRhdGEsXCRtYSI7aToxMDE7czozNDoiXCRmdW5jXChcJHBhcmFtc1xbXCR0eXBlXF0tPnBhcmFtcyI7aToxMDI7czo4OiIfiwgAAAAAACI7aToxMDM7czo5OiIAAQIDBAUGBwgiO2k6MTA0O3M6MTI6IiFcI1wkJSYnXCpcKyI7aToxMDU7czo3OiKDi42bnp+hIjtpOjEwNjtzOjY6IgkKCwwNICI7aToxMDc7czozMzoiXC5cLi9cLlwuL1wuXC4vXC5cLi9tb2R1bGVzL21vZF9tIjtpOjEwODtzOjMwOiJcJGRlY29yYXRvclwoXCRtYXRjaGVzXFsxXF1cWzAiO2k6MTA5O3M6MjE6IlwkZGVjb2RlZnVuY1woXCRkXFtcJCI7aToxMTA7czoxNzoiX1wuXCtfYWJicmV2aWF0aW8iO2k6MTExO3M6NDU6InN0cmVhbV9zb2NrZXRfY2xpZW50XCgndGNwOi8vJ1wuXCRwcm94eS0+aG9zdCI7aToxMTI7czoyNToiZXZhbFwoZnVuY3Rpb25cKHAsYSxjLGssZSI7aToxMTM7czoyNToiJ3J1bmtpdF9mdW5jdGlvbl9yZW5hbWUnLCI7aToxMTQ7czo2OiKAgYKDhIUiO2k6MTE1O3M6NjoiAQIDBAUGIjtpOjExNjtzOjY6IgAAAAAAACI7aToxMTc7czoyMToiXCRtZXRob2RcKFwkYXJnc1xbMFxdIjtpOjExODtzOjIxOiJcJG1ldGhvZFwoXCRhcmdzXFswXF0iO2k6MTE5O3M6MjQ6IlwkbmFtZVwoXCRhcmd1bWVudHNcWzBcXSI7aToxMjA7czozMToic3Vic3RyXChtZDVcKHN1YnN0clwoXCR0b2tlbiwwLCI7aToxMjE7czoyNDoic3RycmV2XChzdWJzdHJcKHN0cnJldlwoIjtpOjEyMjtzOjM5OiJzdHJlYW1fc29ja2V0X2NsaWVudFwoJ3RjcDovLydcLlwkcHJveHkiO2k6MTIzO3M6MTg6IjwhLS0gUmVkSGVscGVyIC0tPiI7aToxMjQ7czozNjoiXCRlbGVtZW50XFtiXF1cKDBcKSx0aGlzXC50cmFuc2l0aW9uIjtpOjEyNTtzOjMxOiJcJG1ldGhvZFwoXCRyZWxhdGlvblxbJ2l0ZW1OYW1lIjtpOjEyNjtzOjM2OiJcJHZlcnNpb25cWzFcXVwpO31lbHNlaWZcKHByZWdfbWF0Y2giO2k6MTI3O3M6MzQ6IlwkY29tbWFuZFwoXCRjb21tYW5kc1xbXCRpZGVudGlmaWUiO2k6MTI4O3M6NDI6IlwkY2FsbGFibGVcKFwkcmF3XFsnY2FsbGJhY2snXF1cKFwkY1wpLFwkYyI7aToxMjk7czo0MjoiXCRlbFxbdmFsXF1cKFwpXCkgXCRlbFxbdmFsXF1cKGRhdGFcW3N0YXRlIjtpOjEzMDtzOjQ3OiJcJGVsZW1lbnRcW3RcXVwoMFwpLHRoaXNcLnRyYW5zaXRpb25cKCJhZGRDbGFzcyI7aToxMzE7czozMToiXCk7XCNtaXMnLCcgJyxcJGlucHV0XCk7XCRpbnB1dCI7aToxMzI7czozMToia2lsbCAtOSAnXC5cJHBpZFwpO1wkdGhpcy0+Y2xvcyI7aToxMzM7czozMjoiY2FsbF91c2VyX2Z1bmNcKFwkZmlsdGVyLFwkdmFsdWUiO2k6MTM0O3M6MzM6ImNhbGxfdXNlcl9mdW5jXChcJG9wdGlvbnMsXCRlcnJvciI7aToxMzU7czozNjoiY2FsbF91c2VyX2Z1bmNcKFwkbGlzdGVuZXIsXCRldmVudFwpIjtpOjEzNjtzOjY1OiJpZlwoc3RyaXBvc1woXCR1c2VyQWdlbnQsJ0FuZHJvaWQnXCkhPT1mYWxzZVwpe1wkdGhpcy0+bW9iaWxlPXRydSI7aToxMzc7czo1MzoiYmFzZTY0X2RlY29kZVwodXJsZGVjb2RlXChcJGZpbGVcKVwpPT0naW5kZXhcLnBocCdcKXsiO2k6MTM4O3M6NjA6InVybGRlY29kZVwoYmFzZTY0X2RlY29kZVwoXCRpbnB1dFwpXCk7XCRleHBsb2RlQXJyYXk9ZXhwbG9kZSI7aToxMzk7czozNzoiYmFzZTY0X2RlY29kZVwodXJsZGVjb2RlXChcJHJldHVyblVyaSI7aToxNDA7czo0NzoidXJsZGVjb2RlXCh1cmxkZWNvZGVcKHN0cmlwY3NsYXNoZXNcKFwkc2VnbWVudHMiO2k6MTQxO3M6NTM6Im1haWxcKFwkdG8sXCRzdWJqZWN0LFwkYm9keSxcJGhlYWRlclwpO31lbHNle1wkcmVzdWx0IjtpOjE0MjtzOjM4OiI9aW5pX2dldFwoJ2Rpc2FibGVfZnVuY3Rpb25zJ1wpO1wkdGhpcyI7aToxNDM7czo0MjoiPWluaV9nZXRcKCdkaXNhYmxlX2Z1bmN0aW9ucydcKTtpZlwoIWVtcHR5IjtpOjE0NDtzOjM5OiJldmFsXChcJHBocENvZGVcKTt9ZWxzZXtjbGFzc19hbGlhc1woXCQiO2k6MTQ1O3M6NDg6ImV2YWxcKFwkc3RyXCk7fXB1YmxpYyBmdW5jdGlvbiBjb3VudE1lbnVDaGlsZHJlbiI7fQ=="));
$g_AdwareSig = unserialize(base64_decode("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"));
$g_PhishingSig = unserialize(base64_decode("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"));
$g_JSVirSig = unserialize(base64_decode("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"));
$gX_JSVirSig = unserialize(base64_decode("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"));
$g_SusDB = unserialize(base64_decode("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"));
$g_SusDBPrio = unserialize(base64_decode("YToxMjE6e2k6MDtpOjA7aToxO2k6MDtpOjI7aTowO2k6MztpOjA7aTo0O2k6MDtpOjU7aTowO2k6NjtpOjA7aTo3O2k6MDtpOjg7aToxO2k6OTtpOjE7aToxMDtpOjA7aToxMTtpOjA7aToxMjtpOjA7aToxMztpOjA7aToxNDtpOjA7aToxNTtpOjA7aToxNjtpOjA7aToxNztpOjA7aToxODtpOjA7aToxOTtpOjA7aToyMDtpOjA7aToyMTtpOjA7aToyMjtpOjA7aToyMztpOjA7aToyNDtpOjA7aToyNTtpOjA7aToyNjtpOjA7aToyNztpOjA7aToyODtpOjA7aToyOTtpOjE7aTozMDtpOjE7aTozMTtpOjA7aTozMjtpOjA7aTozMztpOjA7aTozNDtpOjA7aTozNTtpOjA7aTozNjtpOjA7aTozNztpOjA7aTozODtpOjA7aTozOTtpOjA7aTo0MDtpOjA7aTo0MTtpOjA7aTo0MjtpOjA7aTo0MztpOjA7aTo0NDtpOjA7aTo0NTtpOjA7aTo0NjtpOjA7aTo0NztpOjA7aTo0ODtpOjA7aTo0OTtpOjA7aTo1MDtpOjA7aTo1MTtpOjA7aTo1MjtpOjA7aTo1MztpOjA7aTo1NDtpOjA7aTo1NTtpOjA7aTo1NjtpOjE7aTo1NztpOjA7aTo1ODtpOjA7aTo1OTtpOjI7aTo2MDtpOjE7aTo2MTtpOjA7aTo2MjtpOjA7aTo2MztpOjA7aTo2NDtpOjI7aTo2NTtpOjA7aTo2NjtpOjA7aTo2NztpOjA7aTo2ODtpOjI7aTo2OTtpOjE7aTo3MDtpOjA7aTo3MTtpOjA7aTo3MjtpOjE7aTo3MztpOjA7aTo3NDtpOjE7aTo3NTtpOjE7aTo3NjtpOjI7aTo3NztpOjE7aTo3ODtpOjM7aTo3OTtpOjI7aTo4MDtpOjA7aTo4MTtpOjI7aTo4MjtpOjA7aTo4MztpOjA7aTo4NDtpOjI7aTo4NTtpOjA7aTo4NjtpOjA7aTo4NztpOjA7aTo4ODtpOjA7aTo4OTtpOjE7aTo5MDtpOjE7aTo5MTtpOjE7aTo5MjtpOjE7aTo5MztpOjA7aTo5NDtpOjI7aTo5NTtpOjI7aTo5NjtpOjI7aTo5NztpOjI7aTo5ODtpOjI7aTo5OTtpOjE7aToxMDA7aToxO2k6MTAxO2k6MztpOjEwMjtpOjM7aToxMDM7aToxO2k6MTA0O2k6MztpOjEwNTtpOjM7aToxMDY7aToyO2k6MTA3O2k6MDtpOjEwODtpOjM7aToxMDk7aToxO2k6MTEwO2k6MTtpOjExMTtpOjM7aToxMTI7aTozO2k6MTEzO2k6MztpOjExNDtpOjE7aToxMTU7aToxO2k6MTE2O2k6MTtpOjExNztpOjQ7aToxMTg7aToxO2k6MTE5O2k6MztpOjEyMDtpOjA7fQ=="));

//END_SIG
////////////////////////////////////////////////////////////////////////////
if (!isCli() && !isset($_SERVER['HTTP_USER_AGENT'])) {
  echo "#####################################################\n";
  echo "# Error: cannot run on php-cgi. Requires php as cli #\n";
  echo "#                                                   #\n";
  echo "# See FAQ: http://revisium.com/ai/faq.php           #\n";
  echo "#####################################################\n";
  exit;
}


if (version_compare(phpversion(), '5.3.1', '<')) {
  echo "#####################################################\n";
  echo "# Warning: PHP Version < 5.3.1                      #\n";
  echo "# Some function might not work properly             #\n";
  echo "# See FAQ: http://revisium.com/ai/faq.php           #\n";
  echo "#####################################################\n";
  exit;
}

if (!(function_exists("file_put_contents") && is_callable("file_put_contents"))) {
    echo "#####################################################\n";
	echo "file_put_contents() is disabled. Cannot proceed.\n";
    echo "#####################################################\n";	
    exit;
}
                              
define('AI_VERSION', '20170812');

////////////////////////////////////////////////////////////////////////////

$l_Res = '';

$g_Structure = array();
$g_Counter = 0;
$g_SpecificExt = false;

$g_UpdatedJsonLog = 0;
$g_NotRead = array();
$g_FileInfo = array();
$g_Iframer = array();
$g_PHPCodeInside = array();
$g_CriticalJS = array();
$g_Phishing = array();
$g_Base64 = array();
$g_HeuristicDetected = array();
$g_HeuristicType = array();
$g_UnixExec = array();
$g_SkippedFolders = array();
$g_UnsafeFilesFound = array();
$g_CMS = array();
$g_SymLinks = array();
$g_HiddenFiles = array();
$g_Vulnerable = array();

$g_TotalFolder = 0;
$g_TotalFiles = 0;

$g_FoundTotalDirs = 0;
$g_FoundTotalFiles = 0;

if (!isCli()) {
   $defaults['site_url'] = 'http://' . $_SERVER['HTTP_HOST'] . '/'; 
}

define('CRC32_LIMIT', pow(2, 31) - 1);
define('CRC32_DIFF', CRC32_LIMIT * 2 -2);

error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
srand(time());

set_time_limit(0);
ini_set('max_execution_time', '900000');
ini_set('realpath_cache_size','16M');
ini_set('realpath_cache_ttl','1200');
ini_set('pcre.backtrack_limit','1000000');
ini_set('pcre.recursion_limit','200000');
ini_set('pcre.jit','1');

if (!function_exists('stripos')) {
	function stripos($par_Str, $par_Entry, $Offset = 0) {
		return strpos(strtolower($par_Str), strtolower($par_Entry), $Offset);
	}
}

define('CMS_BITRIX', 'Bitrix');
define('CMS_WORDPRESS', 'Wordpress');
define('CMS_JOOMLA', 'Joomla');
define('CMS_DLE', 'Data Life Engine');
define('CMS_IPB', 'Invision Power Board');
define('CMS_WEBASYST', 'WebAsyst');
define('CMS_OSCOMMERCE', 'OsCommerce');
define('CMS_DRUPAL', 'Drupal');
define('CMS_MODX', 'MODX');
define('CMS_INSTANTCMS', 'Instant CMS');
define('CMS_PHPBB', 'PhpBB');
define('CMS_VBULLETIN', 'vBulletin');
define('CMS_SHOPSCRIPT', 'PHP ShopScript Premium');

define('CMS_VERSION_UNDEFINED', '0.0');

class CmsVersionDetector {
    private $root_path;
    private $versions;
    private $types;

    public function __construct($root_path = '.') {
        $this->root_path = $root_path;
        $this->versions = array();
        $this->types = array();

        $version = '';

        $dir_list = $this->getDirList($root_path);
        $dir_list[] = $root_path;

        foreach ($dir_list as $dir) {
            if ($this->checkBitrix($dir, $version)) {
               $this->addCms(CMS_BITRIX, $version);
            }

            if ($this->checkWordpress($dir, $version)) {
               $this->addCms(CMS_WORDPRESS, $version);
            }

            if ($this->checkJoomla($dir, $version)) {
               $this->addCms(CMS_JOOMLA, $version);
            }

            if ($this->checkDle($dir, $version)) {
               $this->addCms(CMS_DLE, $version);
            }

            if ($this->checkIpb($dir, $version)) {
               $this->addCms(CMS_IPB, $version);
            }

            if ($this->checkWebAsyst($dir, $version)) {
               $this->addCms(CMS_WEBASYST, $version);
            }

            if ($this->checkOsCommerce($dir, $version)) {
               $this->addCms(CMS_OSCOMMERCE, $version);
            }

            if ($this->checkDrupal($dir, $version)) {
               $this->addCms(CMS_DRUPAL, $version);
            }

            if ($this->checkMODX($dir, $version)) {
               $this->addCms(CMS_MODX, $version);
            }

            if ($this->checkInstantCms($dir, $version)) {
               $this->addCms(CMS_INSTANTCMS, $version);
            }

            if ($this->checkPhpBb($dir, $version)) {
               $this->addCms(CMS_PHPBB, $version);
            }

            if ($this->checkVBulletin($dir, $version)) {
               $this->addCms(CMS_VBULLETIN, $version);
            }

            if ($this->checkPhpShopScript($dir, $version)) {
               $this->addCms(CMS_SHOPSCRIPT, $version);
            }

        }
    }

    function getDirList($target) {
       $remove = array('.', '..'); 
       $directories = array_diff(scandir($target), $remove);

       $res = array();
           
       foreach($directories as $value) 
       { 
          if(is_dir($target . '/' . $value)) 
          {
             $res[] = $target . '/' . $value; 
          } 
       }

       return $res;
    }

    function isCms($name, $version) {
		for ($i = 0; $i < count($this->types); $i++) {
			if ((strpos($this->types[$i], $name) !== false) 
				&& 
			    (strpos($this->versions[$i], $version) !== false)) {
				return true;
			}
		}
    	
		return false;
    }

    function getCmsList() {
      return $this->types;
    }

    function getCmsVersions() {
      return $this->versions;
    }

    function getCmsNumber() {
      return count($this->types);
    }

    function getCmsName($index = 0) {
      return $this->types[$index];
    }

    function getCmsVersion($index = 0) {
      return $this->versions[$index];
    }

    private function addCms($type, $version) {
       $this->types[] = $type;
       $this->versions[] = $version;
    }

    private function checkBitrix($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir .'/bitrix')) {
          $res = true;

          $tmp_content = @file_get_contents($this->root_path .'/bitrix/modules/main/classes/general/version.php');
          if (preg_match('|define\("SM_VERSION","(.+?)"\)|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }

    private function checkWordpress($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir .'/wp-admin')) {
          $res = true;

          $tmp_content = @file_get_contents($dir .'/wp-includes/version.php');
          if (preg_match('|\$wp_version\s*=\s*\'(.+?)\'|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }
       }

       return $res;
    }

    private function checkJoomla($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir .'/libraries/joomla')) {
          $res = true;

          // for 1.5.x
          $tmp_content = @file_get_contents($dir .'/libraries/joomla/version.php');
          if (preg_match('|var\s+\$RELEASE\s*=\s*\'(.+?)\'|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];

             if (preg_match('|var\s+\$DEV_LEVEL\s*=\s*\'(.+?)\'|smi', $tmp_content, $tmp_ver)) {
                $version .= '.' . $tmp_ver[1];
             }
          }

          // for 1.7.x
          $tmp_content = @file_get_contents($dir .'/includes/version.php');
          if (preg_match('|public\s+\$RELEASE\s*=\s*\'(.+?)\'|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];

             if (preg_match('|public\s+\$DEV_LEVEL\s*=\s*\'(.+?)\'|smi', $tmp_content, $tmp_ver)) {
                $version .= '.' . $tmp_ver[1];
             }
          }


	  // for 2.5.x and 3.x 
          $tmp_content = @file_get_contents($dir . '/libraries/cms/version/version.php');
   
          if (preg_match('|const\s+RELEASE\s*=\s*\'(.+?)\'|smi', $tmp_content, $tmp_ver)) {
	      $version = $tmp_ver[1];
 
             if (preg_match('|const\s+DEV_LEVEL\s*=\s*\'(.+?)\'|smi', $tmp_content, $tmp_ver)) { 
		$version .= '.' . $tmp_ver[1];
             }
          }

       }

       return $res;
    }

    private function checkDle($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir .'/engine/engine.php')) {
          $res = true;

          $tmp_content = @file_get_contents($dir . '/engine/data/config.php');
          if (preg_match('|\'version_id\'\s*=>\s*"(.+?)"|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

          $tmp_content = @file_get_contents($dir . '/install.php');
          if (preg_match('|\'version_id\'\s*=>\s*"(.+?)"|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }

    private function checkIpb($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir . '/ips_kernel')) {
          $res = true;

          $tmp_content = @file_get_contents($dir . '/ips_kernel/class_xml.php');
          if (preg_match('|IP.Board\s+v([0-9\.]+)|si', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }

    private function checkWebAsyst($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir . '/wbs/installer')) {
          $res = true;

          $tmp_content = @file_get_contents($dir . '/license.txt');
          if (preg_match('|v([0-9\.]+)|si', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }

    private function checkOsCommerce($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir . '/includes/version.php')) {
          $res = true;

          $tmp_content = @file_get_contents($dir . '/includes/version.php');
          if (preg_match('|([0-9\.]+)|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }

    private function checkDrupal($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir . '/sites/all')) {
          $res = true;

          $tmp_content = @file_get_contents($dir . '/CHANGELOG.txt');
          if (preg_match('|Drupal\s+([0-9\.]+)|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }

    private function checkMODX($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir . '/manager/assets')) {
          $res = true;

          // no way to pick up version
       }

       return $res;
    }

    private function checkInstantCms($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir . '/plugins/p_usertab')) {
          $res = true;

          $tmp_content = @file_get_contents($dir . '/index.php');
          if (preg_match('|InstantCMS\s+v([0-9\.]+)|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }

    private function checkPhpBb($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir . '/includes/acp')) {
          $res = true;

          $tmp_content = @file_get_contents($dir . '/config.php');
          if (preg_match('|phpBB\s+([0-9\.x]+)|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }

    private function checkVBulletin($dir, &$version) {
          $version = CMS_VERSION_UNDEFINED;
          $res = false;
          if (file_exists($dir . '/core/includes/md5_sums_vbulletin.php'))
          {
                $res = true;
                require_once($dir . '/core/includes/md5_sums_vbulletin.php');
                $version = $md5_sum_versions['vb5_connect'];
          }
          else if(file_exists($dir . '/includes/md5_sums_vbulletin.php'))
          {
                $res = true;
                require_once($dir . '/includes/md5_sums_vbulletin.php');
                $version = $md5_sum_versions['vbulletin'];
          }
          return $res;
       }

    private function checkPhpShopScript($dir, &$version) {
       $version = CMS_VERSION_UNDEFINED;
       $res = false;

       if (file_exists($dir . '/install/consts.php')) {
          $res = true;

          $tmp_content = @file_get_contents($dir . '/install/consts.php');
          if (preg_match('|STRING_VERSION\',\s*\'(.+?)\'|smi', $tmp_content, $tmp_ver)) {
             $version = $tmp_ver[1];
          }

       }

       return $res;
    }
}

/**
 * Print file
*/
function printFile() {
	$l_FileName = $_GET['fn'];
	$l_CRC = isset($_GET['c']) ? (int)$_GET['c'] : 0;
	$l_Content = file_get_contents($l_FileName);
	$l_FileCRC = realCRC($l_Content);
	if ($l_FileCRC != $l_CRC) {
		echo 'Доступ запрещен.';
		exit;
	}
	
	echo '<pre>' . htmlspecialchars($l_Content) . '</pre>';
}

/**
 *
 */
function realCRC($str_in, $full = false)
{
        $in = crc32( $full ? normal($str_in) : $str_in );
        return ($in > CRC32_LIMIT) ? ($in - CRC32_DIFF) : $in;
}


/**
 * Determine php script is called from the command line interface
 * @return bool
 */
function isCli()
{
	return php_sapi_name() == 'cli';
}

function myCheckSum($str) {
   return hash('crc32b', $str);
}

 function generatePassword ($length = 9)
  {

    // start with a blank password
    $password = "";

    // define possible characters - any character in this string can be
    // picked for use in the password, so if you want to put vowels back in
    // or add special characters such as exclamation marks, this is where
    // you should do it
    $possible = "2346789bcdfghjkmnpqrtvwxyzBCDFGHJKLMNPQRTVWXYZ";

    // we refer to the length of $possible a few times, so let's grab it now
    $maxlength = strlen($possible);
  
    // check for length overflow and truncate if necessary
    if ($length > $maxlength) {
      $length = $maxlength;
    }
	
    // set up a counter for how many characters are in the password so far
    $i = 0; 
    
    // add random characters to $password until $length is reached
    while ($i < $length) { 

      // pick a random character from the possible ones
      $char = substr($possible, mt_rand(0, $maxlength-1), 1);
        
      // have we already used this character in $password?
      if (!strstr($password, $char)) { 
        // no, so it's OK to add it onto the end of whatever we've already got...
        $password .= $char;
        // ... and increase the counter by one
        $i++;
      }

    }

    // done!
    return $password;

  }

/**
 * Print to console
 * @param mixed $text
 * @param bool $add_lb Add line break
 * @return void
 */
function stdOut($text, $add_lb = true)
{
	if (!isCli())
		return;
		
	if (is_bool($text))
	{
		$text = $text ? 'true' : 'false';
	}
	else if (is_null($text))
	{
		$text = 'null';
	}
	if (!is_scalar($text))
	{
		$text = print_r($text, true);
	}

 	if (!BOOL_RESULT)
 	{
 		@fwrite(STDOUT, $text . ($add_lb ? "\n" : ''));
 	}
}

/**
 * Print progress
 * @param int $num Current file
 */
function printProgress($num, &$par_File)
{
	global $g_CriticalPHP, $g_Base64, $g_Phishing, $g_CriticalJS, $g_Iframer, $g_UpdatedJsonLog, 
               $g_AddPrefix, $g_NoPrefix;

	$total_files = $GLOBALS['g_FoundTotalFiles'];
	$elapsed_time = microtime(true) - START_TIME;
	$percent = number_format($total_files ? $num * 100 / $total_files : 0, 1);
	$stat = '';
	if ($elapsed_time >= 1)
	{
		$elapsed_seconds = round($elapsed_time, 0);
		$fs = floor($num / $elapsed_seconds);
		$left_files = $total_files - $num;
		if ($fs > 0) 
		{
		   $left_time = ($left_files / $fs); //ceil($left_files / $fs);
		   $stat = ' [Avg: ' . round($fs,2) . ' files/s' . ($left_time > 0  ? ' Left: ' . seconds2Human($left_time) : '') . '] [Mlw:' . (count($g_CriticalPHP) + count($g_Base64))  . '|' . (count($g_CriticalJS) + count($g_Iframer) + count($g_Phishing)) . ']';
        }
	}

        $l_FN = $g_AddPrefix . str_replace($g_NoPrefix, '', $par_File); 
	$l_FN = substr($par_File, -60);

	$text = "$percent% [$l_FN] $num of {$total_files}. " . $stat;
	$text = str_pad($text, 160, ' ', STR_PAD_RIGHT);
	stdOut(str_repeat(chr(8), 160) . $text, false);


      	$data = array('self' => __FILE__, 'started' => AIBOLIT_START_TIME, 'updated' => time(), 
                            'progress' => $percent, 'time_elapsed' => $elapsed_seconds, 
                            'time_left' => round($left_time), 'files_left' => $left_files, 
                            'files_total' => $total_files, 'current_file' => substr($g_AddPrefix . str_replace($g_NoPrefix, '', $par_File), -160));

        if (function_exists('aibolit_onProgressUpdate')) { aibolit_onProgressUpdate($data); }

	if (defined('PROGRESS_LOG_FILE') && 
           (time() - $g_UpdatedJsonLog > 1)) {
                if (function_exists('json_encode')) {
             	   file_put_contents(PROGRESS_LOG_FILE, json_encode($data));
                } else {
             	   file_put_contents(PROGRESS_LOG_FILE, serialize($data));
                }

		$g_UpdatedJsonLog = time();
        }
}

/**
 * Seconds to human readable
 * @param int $seconds
 * @return string
 */
function seconds2Human($seconds)
{
	$r = '';
	$_seconds = floor($seconds);
	$ms = $seconds - $_seconds;
	$seconds = $_seconds;
	if ($hours = floor($seconds / 3600))
	{
		$r .= $hours . (isCli() ? ' h ' : ' час ');
		$seconds = $seconds % 3600;
	}

	if ($minutes = floor($seconds / 60))
	{
		$r .= $minutes . (isCli() ? ' m ' : ' мин ');
		$seconds = $seconds % 60;
	}

	if ($minutes < 3) $r .= ' ' . $seconds + ($ms > 0 ? round($ms) : 0) . (isCli() ? ' s' : ' сек'); 

	return $r;
}

if (isCli())
{

	$cli_options = array(
		'm:' => 'memory:',
		's:' => 'size:',
		'a' => 'all',
		'd:' => 'delay:',
		'l:' => 'list:',
		'r:' => 'report:',
		'f' => 'fast',
		'j:' => 'file:',
		'p:' => 'path:',
		'q' => 'quite',
		'e:' => 'cms:',
		'x:' => 'mode:',
		'k:' => 'skip:',
		'i:' => 'idb:',
		'n' => 'sc',
		'o:' => 'json_report:',
		't:' => 'php_report:',
		'z:' => 'progress:',
		'g:' => 'handler:',
		'b' => 'smart',
		'h' => 'help',
	);

	$cli_longopts = array(
		'cmd:',
		'noprefix:',
		'addprefix:',
		'scan:',
		'one-pass',
		'smart',
		'quarantine',
		'with-2check',
		'skip-cache',
		'imake',
		'icheck'
	);
	
	$cli_longopts = array_merge($cli_longopts, array_values($cli_options));

	$options = getopt(implode('', array_keys($cli_options)), $cli_longopts);

	if (isset($options['h']) OR isset($options['help']))
	{
		$memory_limit = ini_get('memory_limit');
		echo <<<HELP
AI-Bolit - Professional Malware File Scanner.

Usage: php {$_SERVER['PHP_SELF']} [OPTIONS] [PATH]
Current default path is: {$defaults['path']}

  -j, --file=FILE      		Full path to single file to check
  -l, --list=FILE      		Full path to create plain text file with a list of found malware
  -o, --json_report=FILE	Full path to create json-file with a list of found malware
  -p, --path=PATH      		Directory path to scan, by default the file directory is used
                       		Current path: {$defaults['path']}
  -m, --memory=SIZE    		Maximum amount of memory a script may consume. Current value: $memory_limit
                       		Can take shorthand byte values (1M, 1G...)
  -s, --size=SIZE      		Scan files are smaller than SIZE. 0 - All files. Current value: {$defaults['max_size_to_scan']}
  -a, --all            		Scan all files (by default scan. js,. php,. html,. htaccess)
  -d, --delay=INT      		Delay in milliseconds when scanning files to reduce load on the file system (Default: 1)
  -x, --mode=INT       		Set scan mode. 0 - for basic, 1 - for expert and 2 for paranoic.
  -k, --skip=jpg,...   		Skip specific extensions. E.g. --skip=jpg,gif,png,xls,pdf
      --scan=php,...   		Scan only specific extensions. E.g. --scan=php,htaccess,js
  -r, --report=PATH/EMAILS
  -z, --progress=FILE  		Runtime progress of scanning, saved to the file, full path required. 
  -g, --hander=FILE    		External php handler for different events, full path to php file required.
      --cmd="command [args...]"
      --smart                   Enable smart mode (skip cache files and optimize scanning)
                       		Run command after scanning
      --one-pass       		Do not calculate remaining time
      --quarantine     		Archive all malware from report
      --with-2check    		Create or use AI-BOLIT-DOUBLECHECK.php file
      --imake
      --icheck
      --idb=file	   	Integrity Check database file

      --help           		Display this help and exit

* Mandatory arguments listed below are required for both full and short way of usage.

HELP;
		exit;
	}

	$l_FastCli = false;
	
	if (
		(isset($options['memory']) AND !empty($options['memory']) AND ($memory = $options['memory']))
		OR (isset($options['m']) AND !empty($options['m']) AND ($memory = $options['m']))
	)
	{
		$memory = getBytes($memory);
		if ($memory > 0)
		{
			$defaults['memory_limit'] = $memory;
			ini_set('memory_limit', $memory);
		}
	}

	if (
		(isset($options['file']) AND !empty($options['file']) AND ($file = $options['file']) !== false)
		OR (isset($options['j']) AND !empty($options['j']) AND ($file = $options['j']) !== false)
	)
	{
		define('SCAN_FILE', $file);
	}


	if (
		(isset($options['list']) AND !empty($options['list']) AND ($file = $options['list']) !== false)
		OR (isset($options['l']) AND !empty($options['l']) AND ($file = $options['l']) !== false)
	)
	{

		define('PLAIN_FILE', $file);
	}

	if (
		(isset($options['json_report']) AND !empty($options['json_report']) AND ($file = $options['json_report']) !== false)
		OR (isset($options['o']) AND !empty($options['o']) AND ($file = $options['o']) !== false)
	)
	{
		define('JSON_FILE', $file);
	}

	if (
		(isset($options['php_report']) AND !empty($options['php_report']) AND ($file = $options['php_report']) !== false)
		OR (isset($options['t']) AND !empty($options['t']) AND ($file = $options['t']) !== false)
	)
	{
		define('PHP_FILE', $file);
	}

	if (isset($options['smart']) OR isset($options['b']))
	{
		define('SMART_SCAN', 1);
	}

	if (
		(isset($options['handler']) AND !empty($options['handler']) AND ($file = $options['handler']) !== false)
		OR (isset($options['g']) AND !empty($options['g']) AND ($file = $options['g']) !== false)
	)
	{
	        if (file_exists($file)) {
		   define('AIBOLIT_EXTERNAL_HANDLER', $file);
                }
	}

	if (
		(isset($options['progress']) AND !empty($options['progress']) AND ($file = $options['progress']) !== false)
		OR (isset($options['z']) AND !empty($options['z']) AND ($file = $options['z']) !== false)
	)
	{
		define('PROGRESS_LOG_FILE', $file);
	}
	if (
		(isset($options['size']) AND !empty($options['size']) AND ($size = $options['size']) !== false)
		OR (isset($options['s']) AND !empty($options['s']) AND ($size = $options['s']) !== false)
	)
	{
		$size = getBytes($size);
		$defaults['max_size_to_scan'] = $size > 0 ? $size : 0;
	}

 	if (
 		(isset($options['file']) AND !empty($options['file']) AND ($file = $options['file']) !== false)
 		OR (isset($options['j']) AND !empty($options['j']) AND ($file = $options['j']) !== false)
 		AND (isset($options['q'])) 
 	
 	)
 	{
 		$BOOL_RESULT = true;
 	}
 
	if (isset($options['f'])) 
	{
	   $l_FastCli = true;
	}
		
	if (isset($options['q']) || isset($options['quite'])) 
	{
 	    $BOOL_RESULT = true;
	}

	define('BOOL_RESULT', $BOOL_RESULT);

	if (
		(isset($options['delay']) AND !empty($options['delay']) AND ($delay = $options['delay']) !== false)
		OR (isset($options['d']) AND !empty($options['d']) AND ($delay = $options['d']) !== false)
	)
	{
		$delay = (int) $delay;
		if (!($delay < 0))
		{
			$defaults['scan_delay'] = $delay;
		}
	}

	if (
		(isset($options['skip']) AND !empty($options['skip']) AND ($ext_list = $options['skip']) !== false)
		OR (isset($options['k']) AND !empty($options['k']) AND ($ext_list = $options['k']) !== false)
	)
	{
		$defaults['skip_ext'] = $ext_list;
	}

	if (isset($options['n']) OR isset($options['skip-cache']))
	{
		$defaults['skip_cache'] = true;
	}

	if (isset($options['all']) OR isset($options['a']))
	{
		$defaults['scan_all_files'] = 1;
	}

	if (isset($options['scan']))
	{
		$ext_list = strtolower(trim($options['scan'], " ,\t\n\r\0\x0B"));
		if ($ext_list != '')
		{
			$l_FastCli = true;
			$g_SensitiveFiles = explode(",", $ext_list);
			stdOut("Scan extensions: " . $ext_list);
			$g_SpecificExt = true;
		}
	}


    if (isset($options['cms'])) {
        define('CMS', $options['cms']);
    } else if (isset($options['e'])) {
        define('CMS', $options['e']);
    }

    if (isset($options['x'])) {
        define('AI_EXPERT', $options['x']);
    } else if (isset($options['mode'])) {
        define('AI_EXPERT', $options['mode']);
    } else {
		define('AI_EXPERT', AI_EXPERT_MODE); 
    }

    if (!defined('SMART_SCAN')) {
       define('SMART_SCAN', 1);
    }


	$l_SpecifiedPath = false;
	if (
		(isset($options['path']) AND !empty($options['path']) AND ($path = $options['path']) !== false)
		OR (isset($options['p']) AND !empty($options['p']) AND ($path = $options['p']) !== false)
	)
	{
		$defaults['path'] = $path;
		$l_SpecifiedPath = true;
	}

	if (
		isset($options['noprefix']) AND !empty($options['noprefix']) AND ($g_NoPrefix = $options['noprefix']) !== false)
		
	{
	} else {
		$g_NoPrefix = '';
	}

	if (
		isset($options['addprefix']) AND !empty($options['addprefix']) AND ($g_AddPrefix = $options['addprefix']) !== false)
		
	{
	} else {
		$g_AddPrefix = '';
	}



	$l_SuffixReport = str_replace('/var/www', '', $defaults['path']);
	$l_SuffixReport = str_replace('/home', '', $l_SuffixReport);
    $l_SuffixReport = preg_replace('#[/\\\.\s]#', '_', $l_SuffixReport);
	$l_SuffixReport .=  "-" . rand(1, 999999);
		
	if (
		(isset($options['report']) AND ($report = $options['report']) !== false)
		OR (isset($options['r']) AND ($report = $options['r']) !== false)
	)
	{
		$report = str_replace('@PATH@', $l_SuffixReport, $report);
		$report = str_replace('@RND@', rand(1, 999999), $report);
		$report = str_replace('@DATE@', date('d-m-Y-h-i'), $report);
		define('REPORT', $report);
		define('NEED_REPORT', true);
	}

	if (
		(isset($options['idb']) AND ($ireport = $options['idb']) !== false)
	)
	{
		$ireport = str_replace('@PATH@', $l_SuffixReport, $ireport);
		$ireport = str_replace('@RND@', rand(1, 999999), $ireport);
		$ireport = str_replace('@DATE@', date('d-m-Y-h-i'), $ireport);
		define('INTEGRITY_DB_FILE', $ireport);
	}

  
    $l_ReportDirName = dirname($report);
	define('QUEUE_FILENAME', ($l_ReportDirName != '' ? $l_ReportDirName . '/' : '') . 'AI-BOLIT-QUEUE-' . md5($defaults['path']) . '.txt');

	defined('REPORT') OR define('REPORT', 'AI-BOLIT-REPORT-' . $l_SuffixReport . '-' . date('d-m-Y_H-i') . '.html');
	
	defined('INTEGRITY_DB_FILE') OR define('INTEGRITY_DB_FILE', 'AINTEGRITY-' . $l_SuffixReport . '-' . date('d-m-Y_H-i'));

	$last_arg = max(1, sizeof($_SERVER['argv']) - 1);
	if (isset($_SERVER['argv'][$last_arg]))
	{
		$path = $_SERVER['argv'][$last_arg];
		if (
			substr($path, 0, 1) != '-'
			AND (substr($_SERVER['argv'][$last_arg - 1], 0, 1) != '-' OR array_key_exists(substr($_SERVER['argv'][$last_arg - 1], -1), $cli_options)))
		{
			$defaults['path'] = $path;
		}
	}	
	
	
	define('ONE_PASS', isset($options['one-pass']));

	define('IMAKE', isset($options['imake']));
	define('ICHECK', isset($options['icheck']));

	if (IMAKE && ICHECK) die('One of the following options must be used --imake or --icheck.');

} else {
   define('AI_EXPERT', AI_EXPERT_MODE); 
   define('ONE_PASS', true);
}

OptimizeSignatures();

$g_DBShe  = array_map('strtolower', $g_DBShe);
$gX_DBShe = array_map('strtolower', $gX_DBShe);

if (!defined('PLAIN_FILE')) { define('PLAIN_FILE', ''); }

// Init
define('MAX_ALLOWED_PHP_HTML_IN_DIR', 600);
define('BASE64_LENGTH', 69);
define('MAX_PREVIEW_LEN', 80);
define('MAX_EXT_LINKS', 1001);

if (defined('AIBOLIT_EXTERNAL_HANDLER')) {
   include_once(AIBOLIT_EXTERNAL_HANDLER);
   stdOut("\nLoaded external handler: " . AIBOLIT_EXTERNAL_HANDLER . "\n");
   if (function_exists("aibolit_onStart")) { aibolit_onStart(); }
}

// Perform full scan when running from command line
if (isCli() || isset($_GET['full'])) {
  $defaults['scan_all_files'] = 1;
}

if ($l_FastCli) {
  $defaults['scan_all_files'] = 0; 
}

if (!isCli()) {
  	define('ICHECK', isset($_GET['icheck']));
  	define('IMAKE', isset($_GET['imake']));
	
	define('INTEGRITY_DB_FILE', 'ai-integrity-db');
}

define('SCAN_ALL_FILES', (bool) $defaults['scan_all_files']);
define('SCAN_DELAY', (int) $defaults['scan_delay']);
define('MAX_SIZE_TO_SCAN', getBytes($defaults['max_size_to_scan']));

if ($defaults['memory_limit'] AND ($defaults['memory_limit'] = getBytes($defaults['memory_limit'])) > 0) {
	ini_set('memory_limit', $defaults['memory_limit']);
    stdOut("Changed memory limit to " . $defaults['memory_limit']);
}

define('START_TIME', microtime(true));

define('ROOT_PATH', realpath($defaults['path']));

if (!ROOT_PATH)
{
    if (isCli())  {
		die(stdOut("Directory '{$defaults['path']}' not found!"));
	}
}
elseif(!is_readable(ROOT_PATH))
{
        if (isCli())  {
		die2(stdOut("Cannot read directory '" . ROOT_PATH . "'!"));
	}
}

define('CURRENT_DIR', getcwd());
chdir(ROOT_PATH);

// Проверяем отчет
if (isCli() AND REPORT !== '' AND !getEmails(REPORT))
{
	$report = str_replace('\\', '/', REPORT);
	$abs = strpos($report, '/') === 0 ? DIR_SEPARATOR : '';
	$report = array_values(array_filter(explode('/', $report)));
	$report_file = array_pop($report);
	$report_path = realpath($abs . implode(DIR_SEPARATOR, $report));

	define('REPORT_FILE', $report_file);
	define('REPORT_PATH', $report_path);

	if (REPORT_FILE AND REPORT_PATH AND is_file(REPORT_PATH . DIR_SEPARATOR . REPORT_FILE))
	{
		@unlink(REPORT_PATH . DIR_SEPARATOR . REPORT_FILE);
	}
}


if (function_exists('phpinfo')) {
   ob_start();
   phpinfo();
   $l_PhpInfo = ob_get_contents();
   ob_end_clean();

   $l_PhpInfo = str_replace('border: 1px', '', $l_PhpInfo);
   preg_match('|<body>(.*)</body>|smi', $l_PhpInfo, $l_PhpInfoBody);
}

////////////////////////////////////////////////////////////////////////////
$l_Template = str_replace("@@MODE@@", AI_EXPERT . '/' . SMART_SCAN, $l_Template);

if (AI_EXPERT == 0) {
   $l_Result .= '<div class="rep">' . AI_STR_057 . '</div>'; 
} else {
}

$l_Template = str_replace('@@HEAD_TITLE@@', AI_STR_051 . $g_AddPrefix . str_replace($g_NoPrefix, '', ROOT_PATH), $l_Template);

define('QCR_INDEX_FILENAME', 'fn');
define('QCR_INDEX_TYPE', 'type');
define('QCR_INDEX_WRITABLE', 'wr');
define('QCR_SVALUE_FILE', '1');
define('QCR_SVALUE_FOLDER', '0');

/**
 * Extract emails from the string
 * @param string $email
 * @return array of strings with emails or false on error
 */
function getEmails($email)
{
	$email = preg_split('#[,\s;]#', $email, -1, PREG_SPLIT_NO_EMPTY);
	$r = array();
	for ($i = 0, $size = sizeof($email); $i < $size; $i++)
	{
	        if (function_exists('filter_var')) {
   		   if (filter_var($email[$i], FILTER_VALIDATE_EMAIL))
   		   {
   		   	$r[] = $email[$i];
    		   }
                } else {
                   // for PHP4
                   if (strpos($email[$i], '@') !== false) {
   		   	$r[] = $email[$i];
                   }
                }
	}
	return empty($r) ? false : $r;
}

/**
 * Get bytes from shorthand byte values (1M, 1G...)
 * @param int|string $val
 * @return int
 */
function getBytes($val)
{
	$val = trim($val);
	$last = strtolower($val{strlen($val) - 1});
	switch($last) {
		case 't':
			$val *= 1024;
		case 'g':
			$val *= 1024;
		case 'm':
			$val *= 1024;
		case 'k':
			$val *= 1024;
	}
	return intval($val);
}

/**
 * Format bytes to human readable
 * @param int $bites
 * @return string
 */
function bytes2Human($bites)
{
	if ($bites < 1024)
	{
		return $bites . ' b';
	}
	elseif (($kb = $bites / 1024) < 1024)
	{
		return number_format($kb, 2) . ' Kb';
	}
	elseif (($mb = $kb / 1024) < 1024)
	{
		return number_format($mb, 2) . ' Mb';
	}
	elseif (($gb = $mb / 1024) < 1024)
	{
		return number_format($gb, 2) . ' Gb';
	}
	else
	{
		return number_format($gb / 1024, 2) . 'Tb';
	}
}

///////////////////////////////////////////////////////////////////////////
function needIgnore($par_FN, $par_CRC) {
  global $g_IgnoreList;
  
  for ($i = 0; $i < count($g_IgnoreList); $i++) {
     if (strpos($par_FN, $g_IgnoreList[$i][0]) !== false) {
		if ($par_CRC == $g_IgnoreList[$i][1]) {
			return true;
		}
	 }
  }
  
  return false;
}

///////////////////////////////////////////////////////////////////////////
function makeSafeFn($par_Str, $replace_path = false) {
  global $g_AddPrefix, $g_NoPrefix;
  if ($replace_path) {
     $lines = explode("\n", $par_Str);
     array_walk($lines, function(&$n) {
          global $g_AddPrefix, $g_NoPrefix;
          $n = $g_AddPrefix . str_replace($g_NoPrefix, '', $n); 
     }); 

     $par_Str = implode("\n", $lines);
  }
 
  return htmlspecialchars($par_Str, ENT_SUBSTITUTE | ENT_QUOTES);
}

function replacePathArray($par_Arr) {
  global $g_AddPrefix, $g_NoPrefix;
     array_walk($par_Arr, function(&$n) {
          global $g_AddPrefix, $g_NoPrefix;
          $n = $g_AddPrefix . str_replace($g_NoPrefix, '', $n); 
     }); 

  return $par_Arr;
}

///////////////////////////////////////////////////////////////////////////
function getRawJsonVuln($par_List) {
  global $g_Structure, $g_NoPrefix, $g_AddPrefix;
   $results = array();
   $l_Src = array('&quot;', '&lt;', '&gt;', '&amp;', '&#039;', '<' . '?php.');
   $l_Dst = array('"',      '<',    '>',    '&', '\'',         '<' . '?php ');

   for ($i = 0; $i < count($par_List); $i++) {
      $l_Pos = $par_List[$i]['ndx'];
      $res['fn'] = $g_AddPrefix . str_replace($g_NoPrefix, '', $g_Structure['n'][$l_Pos]);
      $res['sig'] = $par_List[$i]['id'];

      $res['ct'] = $g_Structure['c'][$l_Pos];
      $res['mt'] = $g_Structure['m'][$l_Pos];
      $res['sz'] = $g_Structure['s'][$l_Pos];
      $res['sigid'] = 'vuln_' . md5($g_Structure['n'][$l_Pos] . $par_List[$i]['id']);

      $results[] = $res; 
   }

   return $results;
}

///////////////////////////////////////////////////////////////////////////
function getRawJson($par_List, $par_Details = null, $par_SigId = null) {
  global $g_Structure, $g_NoPrefix, $g_AddPrefix;
   $results = array();
   $l_Src = array('&quot;', '&lt;', '&gt;', '&amp;', '&#039;', '<' . '?php.');
   $l_Dst = array('"',      '<',    '>',    '&', '\'',         '<' . '?php ');

   for ($i = 0; $i < count($par_List); $i++) {
       if ($par_SigId != null) {
          $l_SigId = 'id_' . $par_SigId[$i];
       } else {
          $l_SigId = 'id_n' . rand(1000000, 9000000);
       }
       


      $l_Pos = $par_List[$i];
      $res['fn'] = $g_AddPrefix . str_replace($g_NoPrefix, '', $g_Structure['n'][$l_Pos]);
      if ($par_Details != null) {
         $res['sig'] = preg_replace('|(L\d+).+__AI_MARKER__|smi', '[$1]: ...', $par_Details[$i]);
         $res['sig'] = preg_replace('/[^\x20-\x7F]/', '.', $res['sig']);
         $res['sig'] = preg_replace('/__AI_LINE1__(\d+)__AI_LINE2__/', '[$1] ', $res['sig']);
         $res['sig'] = preg_replace('/__AI_MARKER__/', ' @!!!>', $res['sig']);
         $res['sig'] = str_replace($l_Src, $l_Dst, $res['sig']);
      }

      $res['ct'] = $g_Structure['c'][$l_Pos];
      $res['mt'] = $g_Structure['m'][$l_Pos];
      $res['sz'] = $g_Structure['s'][$l_Pos];
      $res['sigid'] = $l_SigId;

      $results[] = $res; 
   }

   return $results;
}

///////////////////////////////////////////////////////////////////////////
function printList($par_List, $par_Details = null, $par_NeedIgnore = false, $par_SigId = null, $par_TableName = null) {
  global $g_Structure, $g_NoPrefix, $g_AddPrefix;
  
  $i = 0;

  if ($par_TableName == null) {
     $par_TableName = 'table_' . rand(1000000,9000000);
  }

  $l_Result = '';
  $l_Result .= "<div class=\"flist\"><table cellspacing=1 cellpadding=4 border=0 id=\"" . $par_TableName . "\">";

  $l_Result .= "<thead><tr class=\"tbgh" . ( $i % 2 ). "\">";
  $l_Result .= "<th width=70%>" . AI_STR_004 . "</th>";
  $l_Result .= "<th>" . AI_STR_005 . "</th>";
  $l_Result .= "<th>" . AI_STR_006 . "</th>";
  $l_Result .= "<th width=90>" . AI_STR_007 . "</th>";
  $l_Result .= "<th width=0 class=\"hidd\">CRC32</th>";
  $l_Result .= "<th width=0 class=\"hidd\"></th>";
  $l_Result .= "<th width=0 class=\"hidd\"></th>";
  $l_Result .= "<th width=0 class=\"hidd\"></th>";
  
  $l_Result .= "</tr></thead><tbody>";

  for ($i = 0; $i < count($par_List); $i++) {
    if ($par_SigId != null) {
       $l_SigId = 'id_' . $par_SigId[$i];
    } else {
       $l_SigId = 'id_z' . rand(1000000,9000000);
    }
    
    $l_Pos = $par_List[$i];
        if ($par_NeedIgnore) {
         	if (needIgnore($g_Structure['n'][$par_List[$i]], $g_Structure['crc'][$l_Pos])) {
         		continue;
         	}
        }
  
     $l_Creat = $g_Structure['c'][$l_Pos] > 0 ? date("d/m/Y H:i:s", $g_Structure['c'][$l_Pos]) : '-';
     $l_Modif = $g_Structure['m'][$l_Pos] > 0 ? date("d/m/Y H:i:s", $g_Structure['m'][$l_Pos]) : '-';
     $l_Size = $g_Structure['s'][$l_Pos] > 0 ? bytes2Human($g_Structure['s'][$l_Pos]) : '-';

     if ($par_Details != null) {
        $l_WithMarker = preg_replace('|__AI_MARKER__|smi', '<span class="marker">&nbsp;</span>', $par_Details[$i]);
        $l_WithMarker = preg_replace('|__AI_LINE1__|smi', '<span class="line_no">', $l_WithMarker);
        $l_WithMarker = preg_replace('|__AI_LINE2__|smi', '</span>', $l_WithMarker);
		
        $l_Body = '<div class="details">';

        if ($par_SigId != null) {
           $l_Body .= '<a href="#" onclick="return hsig(\'' . $l_SigId . '\')">[x]</a> ';
        }

        $l_Body .= $l_WithMarker . '</div>';
     } else {
        $l_Body = '';
     }

     $l_Result .= '<tr class="tbg' . ( $i % 2 ). '" o="' . $l_SigId .'">';
	 
	 if (is_file($g_Structure['n'][$l_Pos])) {
//		$l_Result .= '<td><div class="it"><a class="it" target="_blank" href="'. $defaults['site_url'] . 'ai-bolit.php?fn=' .
//	              $g_Structure['n'][$l_Pos] . '&ph=' . realCRC(PASS) . '&c=' . $g_Structure['crc'][$l_Pos] . '">' . $g_Structure['n'][$l_Pos] . '</a></div>' . $l_Body . '</td>';
		$l_Result .= '<td><div class="it"><a class="it">' . makeSafeFn($g_AddPrefix . str_replace($g_NoPrefix, '', $g_Structure['n'][$l_Pos])) . '</a></div>' . $l_Body . '</td>';
	 } else {
		$l_Result .= '<td><div class="it"><a class="it">' . makeSafeFn($g_AddPrefix . str_replace($g_NoPrefix, '', $g_Structure['n'][$par_List[$i]])) . '</a></div></td>';
	 }
	 
     $l_Result .= '<td align=center><div class="ctd">' . $l_Creat . '</div></td>';
     $l_Result .= '<td align=center><div class="ctd">' . $l_Modif . '</div></td>';
     $l_Result .= '<td align=center><div class="ctd">' . $l_Size . '</div></td>';
     $l_Result .= '<td class="hidd"><div class="hidd">' . $g_Structure['crc'][$l_Pos] . '</div></td>';
     $l_Result .= '<td class="hidd"><div class="hidd">' . 'x' . '</div></td>';
     $l_Result .= '<td class="hidd"><div class="hidd">' . $g_Structure['m'][$l_Pos] . '</div></td>';
     $l_Result .= '<td class="hidd"><div class="hidd">' . $l_SigId . '</div></td>';
     $l_Result .= '</tr>';

  }

  $l_Result .= "</tbody></table></div><div class=clear style=\"margin: 20px 0 0 0\"></div>";

  return $l_Result;
}

///////////////////////////////////////////////////////////////////////////
function printPlainList($par_List, $par_Details = null, $par_NeedIgnore = false, $par_SigId = null, $par_TableName = null) {
  global $g_Structure, $g_NoPrefix, $g_AddPrefix;
  
  $l_Result = "";

  $l_Src = array('&quot;', '&lt;', '&gt;', '&amp;', '&#039;');
  $l_Dst = array('"',      '<',    '>',    '&', '\'');

  for ($i = 0; $i < count($par_List); $i++) {
    $l_Pos = $par_List[$i];
        if ($par_NeedIgnore) {
         	if (needIgnore($g_Structure['n'][$par_List[$i]], $g_Structure['crc'][$l_Pos])) {
         		continue;
         	}                      
        }
  

     if ($par_Details != null) {

        $l_Body = preg_replace('|(L\d+).+__AI_MARKER__|smi', '$1: ...', $par_Details[$i]);
        $l_Body = preg_replace('/[^\x20-\x7F]/', '.', $l_Body);
        $l_Body = str_replace($l_Src, $l_Dst, $l_Body);

     } else {
        $l_Body = '';
     }

	 if (is_file($g_Structure['n'][$l_Pos])) {		 
		$l_Result .= $g_AddPrefix . str_replace($g_NoPrefix, '', $g_Structure['n'][$l_Pos]) . "\t\t\t" . $l_Body . "\n";
	 } else {
		$l_Result .= $g_AddPrefix . str_replace($g_NoPrefix, '', $g_Structure['n'][$par_List[$i]]) . "\n";
	 }
	 
  }

  return $l_Result;
}

///////////////////////////////////////////////////////////////////////////
function extractValue(&$par_Str, $par_Name) {
  if (preg_match('|<tr><td class="e">\s*'.$par_Name.'\s*</td><td class="v">(.+?)</td>|sm', $par_Str, $l_Result)) {
     return str_replace('no value', '', strip_tags($l_Result[1]));
  }
}

///////////////////////////////////////////////////////////////////////////
function QCR_ExtractInfo($par_Str) {
   $l_PhpInfoSystem = extractValue($par_Str, 'System');
   $l_PhpPHPAPI = extractValue($par_Str, 'Server API');
   $l_AllowUrlFOpen = extractValue($par_Str, 'allow_url_fopen');
   $l_AllowUrlInclude = extractValue($par_Str, 'allow_url_include');
   $l_DisabledFunction = extractValue($par_Str, 'disable_functions');
   $l_DisplayErrors = extractValue($par_Str, 'display_errors');
   $l_ErrorReporting = extractValue($par_Str, 'error_reporting');
   $l_ExposePHP = extractValue($par_Str, 'expose_php');
   $l_LogErrors = extractValue($par_Str, 'log_errors');
   $l_MQGPC = extractValue($par_Str, 'magic_quotes_gpc');
   $l_MQRT = extractValue($par_Str, 'magic_quotes_runtime');
   $l_OpenBaseDir = extractValue($par_Str, 'open_basedir');
   $l_RegisterGlobals = extractValue($par_Str, 'register_globals');
   $l_SafeMode = extractValue($par_Str, 'safe_mode');


   $l_DisabledFunction = ($l_DisabledFunction == '' ? '-?-' : $l_DisabledFunction);
   $l_OpenBaseDir = ($l_OpenBaseDir == '' ? '-?-' : $l_OpenBaseDir);

   $l_Result = '<div class="title">' . AI_STR_008 . ': ' . phpversion() . '</div>';
   $l_Result .= 'System Version: <span class="php_ok">' . $l_PhpInfoSystem . '</span><br/>';
   $l_Result .= 'PHP API: <span class="php_ok">' . $l_PhpPHPAPI. '</span><br/>';
   $l_Result .= 'allow_url_fopen: <span class="php_' . ($l_AllowUrlFOpen == 'On' ? 'bad' : 'ok') . '">' . $l_AllowUrlFOpen. '</span><br/>';
   $l_Result .= 'allow_url_include: <span class="php_' . ($l_AllowUrlInclude == 'On' ? 'bad' : 'ok') . '">' . $l_AllowUrlInclude. '</span><br/>';
   $l_Result .= 'disable_functions: <span class="php_' . ($l_DisabledFunction == '-?-' ? 'bad' : 'ok') . '">' . $l_DisabledFunction. '</span><br/>';
   $l_Result .= 'display_errors: <span class="php_' . ($l_DisplayErrors == 'On' ? 'ok' : 'bad') . '">' . $l_DisplayErrors. '</span><br/>';
   $l_Result .= 'error_reporting: <span class="php_ok">' . $l_ErrorReporting. '</span><br/>';
   $l_Result .= 'expose_php: <span class="php_' . ($l_ExposePHP == 'On' ? 'bad' : 'ok') . '">' . $l_ExposePHP. '</span><br/>';
   $l_Result .= 'log_errors: <span class="php_' . ($l_LogErrors == 'On' ? 'ok' : 'bad') . '">' . $l_LogErrors . '</span><br/>';
   $l_Result .= 'magic_quotes_gpc: <span class="php_' . ($l_MQGPC == 'On' ? 'ok' : 'bad') . '">' . $l_MQGPC. '</span><br/>';
   $l_Result .= 'magic_quotes_runtime: <span class="php_' . ($l_MQRT == 'On' ? 'bad' : 'ok') . '">' . $l_MQRT. '</span><br/>';
   $l_Result .= 'register_globals: <span class="php_' . ($l_RegisterGlobals == 'On' ? 'bad' : 'ok') . '">' . $l_RegisterGlobals . '</span><br/>';
   $l_Result .= 'open_basedir: <span class="php_' . ($l_OpenBaseDir == '-?-' ? 'bad' : 'ok') . '">' . $l_OpenBaseDir . '</span><br/>';
   
   if (phpversion() < '5.3.0') {
      $l_Result .= 'safe_mode (PHP < 5.3.0): <span class="php_' . ($l_SafeMode == 'On' ? 'ok' : 'bad') . '">' . $l_SafeMode. '</span><br/>';
   }

   return $l_Result . '<p>';
}

///////////////////////////////////////////////////////////////////////////
   function addSlash($dir) {
      return rtrim($dir, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;
   }

///////////////////////////////////////////////////////////////////////////
function QCR_Debug($par_Str = "") {
  if (!DEBUG_MODE) {
     return;
  }

  $l_MemInfo = ' ';  
  if (function_exists('memory_get_usage')) {
     $l_MemInfo .= ' curmem=' .  bytes2Human(memory_get_usage());
  }

  if (function_exists('memory_get_peak_usage')) {
     $l_MemInfo .= ' maxmem=' .  bytes2Human(memory_get_peak_usage());
  }

  stdOut("\n" . date('H:i:s') . ': ' . $par_Str . $l_MemInfo . "\n");
}


///////////////////////////////////////////////////////////////////////////
function QCR_ScanDirectories($l_RootDir)
{
	global $g_Structure, $g_Counter, $g_Doorway, $g_FoundTotalFiles, $g_FoundTotalDirs, 
			$defaults, $g_SkippedFolders, $g_UrlIgnoreList, $g_DirIgnoreList, $g_UnsafeDirArray, 
                        $g_UnsafeFilesFound, $g_SymLinks, $g_HiddenFiles, $g_UnixExec, $g_IgnoredExt, $g_SensitiveFiles, 
						$g_SuspiciousFiles, $g_ShortListExt, $l_SkipSample;

	static $l_Buffer = '';

	$l_DirCounter = 0;
	$l_DoorwayFilesCounter = 0;
	$l_SourceDirIndex = $g_Counter - 1;

        $l_SkipSample = array();

	QCR_Debug('Scan ' . $l_RootDir);

        $l_QuotedSeparator = quotemeta(DIR_SEPARATOR); 
 	if ($l_DIRH = @opendir($l_RootDir))
	{
		while (($l_FileName = readdir($l_DIRH)) !== false)
		{
			if ($l_FileName == '.' || $l_FileName == '..') continue;

			$l_FileName = $l_RootDir . DIR_SEPARATOR . $l_FileName;

			$l_Type = filetype($l_FileName);
            if ($l_Type == "link") 
            {
                $g_SymLinks[] = $l_FileName;
                continue;
            } else			
			if ($l_Type != "file" && $l_Type != "dir" ) {
			        if (!in_array($l_FileName, $g_UnixExec)) {
				   $g_UnixExec[] = $l_FileName;
				}

				continue;
			}	
						
			$l_Ext = strtolower(pathinfo($l_FileName, PATHINFO_EXTENSION));
			$l_IsDir = is_dir($l_FileName);

			if (in_array($l_Ext, $g_SuspiciousFiles)) 
			{
			        if (!in_array($l_FileName, $g_UnixExec)) {
                		   $g_UnixExec[] = $l_FileName;
                                } 
            		}

			// which files should be scanned
			$l_NeedToScan = SCAN_ALL_FILES || (in_array($l_Ext, $g_SensitiveFiles));
			
			if (in_array(strtolower($l_Ext), $g_IgnoredExt)) {    
		           $l_NeedToScan = false;
                        }

      			// if folder in ignore list
      			$l_Skip = false;
      			for ($dr = 0; $dr < count($g_DirIgnoreList); $dr++) {
      				if (($g_DirIgnoreList[$dr] != '') &&
      				   preg_match('#' . $g_DirIgnoreList[$dr] . '#', $l_FileName, $l_Found)) {
      				   if (!in_array($g_DirIgnoreList[$dr], $l_SkipSample)) {
                                      $l_SkipSample[] = $g_DirIgnoreList[$dr];
                                   } else {
        		             $l_Skip = true;
                                     $l_NeedToScan = false;
                                   }
      				}
      			}


			if ($l_IsDir)
			{
				// skip on ignore
				if ($l_Skip) {
				   $g_SkippedFolders[] = $l_FileName;
				   continue;
				}
				
				$l_BaseName = basename($l_FileName);

				if ((strpos($l_BaseName, '.') === 0) && ($l_BaseName != '.htaccess')) {
	               $g_HiddenFiles[] = $l_FileName;
	            }

//				$g_Structure['d'][$g_Counter] = $l_IsDir;
//				$g_Structure['n'][$g_Counter] = $l_FileName;
				if (ONE_PASS) {
					$g_Structure['n'][$g_Counter] = $l_FileName . DIR_SEPARATOR;
				} else {
					$l_Buffer .= $l_FileName . DIR_SEPARATOR . "\n";
				}

				$l_DirCounter++;

				if ($l_DirCounter > MAX_ALLOWED_PHP_HTML_IN_DIR)
				{
					$g_Doorway[] = $l_SourceDirIndex;
					$l_DirCounter = -655360;
				}

				$g_Counter++;
				$g_FoundTotalDirs++;

				QCR_ScanDirectories($l_FileName);
			} else
			{
				if ($l_NeedToScan)
				{
					$g_FoundTotalFiles++;
					if (in_array($l_Ext, $g_ShortListExt)) 
					{
						$l_DoorwayFilesCounter++;
						
						if ($l_DoorwayFilesCounter > MAX_ALLOWED_PHP_HTML_IN_DIR)
						{
							$g_Doorway[] = $l_SourceDirIndex;
							$l_DoorwayFilesCounter = -655360;
						}
					}

					if (ONE_PASS) {
						QCR_ScanFile($l_FileName, $g_Counter++);
					} else {
						$l_Buffer .= $l_FileName."\n";
					}

					$g_Counter++;
				}
			}

			if (strlen($l_Buffer) > 32000)
			{ 
				file_put_contents(QUEUE_FILENAME, $l_Buffer, FILE_APPEND) or die2("Cannot write to file ".QUEUE_FILENAME);
				$l_Buffer = '';
			}

		}

		closedir($l_DIRH);
	}
	
	if (($l_RootDir == ROOT_PATH) && !empty($l_Buffer)) {
		file_put_contents(QUEUE_FILENAME, $l_Buffer, FILE_APPEND) or die2("Cannot write to file " . QUEUE_FILENAME);
		$l_Buffer = '';                                                                            
	}

}


///////////////////////////////////////////////////////////////////////////
function getFragment($par_Content, $par_Pos) {
  $l_MaxChars = MAX_PREVIEW_LEN;
  $l_MaxLen = strlen($par_Content);
  $l_RightPos = min($par_Pos + $l_MaxChars, $l_MaxLen); 
  $l_MinPos = max(0, $par_Pos - $l_MaxChars);

  $l_FoundStart = substr($par_Content, 0, $par_Pos);
  $l_FoundStart = str_replace("\r", '', $l_FoundStart);
  $l_LineNo = strlen($l_FoundStart) - strlen(str_replace("\n", '', $l_FoundStart)) + 1;

  $par_Content = preg_replace('/[\x00-\x1F\x80-\xFF]/', '~', $par_Content);
  $par_Content = preg_replace('/\s+/', ' ', $par_Content);

  $l_Res = '__AI_LINE1__' . $l_LineNo . "__AI_LINE2__  " . ($l_MinPos > 0 ? '…' : '') . substr($par_Content, $l_MinPos, $par_Pos - $l_MinPos) . 
           '__AI_MARKER__' . 
           substr($par_Content, $par_Pos, $l_RightPos - $par_Pos - 1);

  $l_Res = makeSafeFn(UnwrapObfu($l_Res));
  $l_Res = str_replace('~', '·', $l_Res);
  $l_Res = str_replace('' . '?php', '' . '?php ', $l_Res);

  return $l_Res;
}

///////////////////////////////////////////////////////////////////////////
function escapedHexToHex($escaped)
{ $GLOBALS['g_EncObfu']++; return chr(hexdec($escaped[1])); }
function escapedOctDec($escaped)
{ $GLOBALS['g_EncObfu']++; return chr(octdec($escaped[1])); }
function escapedDec($escaped)
{ $GLOBALS['g_EncObfu']++; return chr($escaped[1]); }

///////////////////////////////////////////////////////////////////////////
if (!defined('T_ML_COMMENT')) {
   define('T_ML_COMMENT', T_COMMENT);
} else {
   define('T_DOC_COMMENT', T_ML_COMMENT);
}
          	
function UnwrapObfu($par_Content) {
  $GLOBALS['g_EncObfu'] = 0;
  
  $search  = array( ' ;', ' =', ' ,', ' .', ' (', ' )', ' {', ' }', '; ', '= ', ', ', '. ', '( ', '( ', '{ ', '} ', ' !', ' >', ' <', ' _', '_ ', '< ',  '> ', ' $', ' %',   '% ', '# ', ' #', '^ ', ' ^', ' &', '& ', ' ?', '? ');
  $replace = array(  ';',  '=',  ',',  '.',  '(',  ')',  '{',  '}', ';',  '=',  ',',  '.',  '(',   ')', '{',  '}',   '!',  '>',  '<',  '_', '_',  '<',   '>',   '$',  '%',   '%',  '#',   '#', '^',   '^',  '&', '&',   '?', '?');
  $par_Content = str_replace('@', '', $par_Content);
  $par_Content = preg_replace('~(\(\s*)+~', '(', $par_Content);
  $par_Content = preg_replace('~\s+~', ' ', $par_Content);
  $par_Content = str_replace($search, $replace, $par_Content);
  $par_Content = preg_replace_callback('~\bchr\(\s*([0-9a-fA-FxX]+)\s*\)~', function ($m) { return "'".chr(intval($m[1], 0))."'"; }, $par_Content );

  $par_Content = preg_replace_callback('/\\\\x([a-fA-F0-9]{1,2})/i','escapedHexToHex', $par_Content);
  $par_Content = preg_replace_callback('/\\\\([0-9]{1,3})/i','escapedOctDec', $par_Content);

  $par_Content = preg_replace('/[\'"]\s*?\.+\s*?[\'"]/smi', '', $par_Content);
  $par_Content = preg_replace('/[\'"]\s*?\++\s*?[\'"]/smi', '', $par_Content);

  return $par_Content;
}

///////////////////////////////////////////////////////////////////////////
// Unicode BOM is U+FEFF, but after encoded, it will look like this.
define ('UTF32_BIG_ENDIAN_BOM'   , chr(0x00) . chr(0x00) . chr(0xFE) . chr(0xFF));
define ('UTF32_LITTLE_ENDIAN_BOM', chr(0xFF) . chr(0xFE) . chr(0x00) . chr(0x00));
define ('UTF16_BIG_ENDIAN_BOM'   , chr(0xFE) . chr(0xFF));
define ('UTF16_LITTLE_ENDIAN_BOM', chr(0xFF) . chr(0xFE));
define ('UTF8_BOM'               , chr(0xEF) . chr(0xBB) . chr(0xBF));

function detect_utf_encoding($text) {
    $first2 = substr($text, 0, 2);
    $first3 = substr($text, 0, 3);
    $first4 = substr($text, 0, 3);
    
    if ($first3 == UTF8_BOM) return 'UTF-8';
    elseif ($first4 == UTF32_BIG_ENDIAN_BOM) return 'UTF-32BE';
    elseif ($first4 == UTF32_LITTLE_ENDIAN_BOM) return 'UTF-32LE';
    elseif ($first2 == UTF16_BIG_ENDIAN_BOM) return 'UTF-16BE';
    elseif ($first2 == UTF16_LITTLE_ENDIAN_BOM) return 'UTF-16LE';

    return false;
}

///////////////////////////////////////////////////////////////////////////
function QCR_SearchPHP($src)
{
  if (preg_match("/(<\?php[\w\s]{5,})/smi", $src, $l_Found, PREG_OFFSET_CAPTURE)) {
	  return $l_Found[0][1];
  }

  if (preg_match("/(<script[^>]*language\s*=\s*)('|\"|)php('|\"|)([^>]*>)/i", $src, $l_Found, PREG_OFFSET_CAPTURE)) {
    return $l_Found[0][1];
  }

  return false;
}


///////////////////////////////////////////////////////////////////////////
function knowUrl($par_URL) {
  global $g_UrlIgnoreList;

  for ($jk = 0; $jk < count($g_UrlIgnoreList); $jk++) {
     if  (stripos($par_URL, $g_UrlIgnoreList[$jk]) !== false) {
     	return true;
     }
  }

  return false;
}

///////////////////////////////////////////////////////////////////////////

function makeSummary($par_Str, $par_Number, $par_Style) {
   return '<tr><td class="' . $par_Style . '" width=400>' . $par_Str . '</td><td class="' . $par_Style . '">' . $par_Number . '</td></tr>';
}

///////////////////////////////////////////////////////////////////////////

function CheckVulnerability($par_Filename, $par_Index, $par_Content) {
    global $g_Vulnerable, $g_CmsListDetector;
	
	$l_Vuln = array();

        $par_Filename = strtolower($par_Filename);


	if (
	    (strpos($par_Filename, 'libraries/joomla/session/session.php') !== false) &&
		(strpos($par_Content, '&& filter_var($_SERVER[\'HTTP_X_FORWARDED_FOR') === false)
		) 
	{		
			$l_Vuln['id'] = 'RCE : https://docs.joomla.org/Security_hotfixes_for_Joomla_EOL_versions';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
	}

	if (
	    (strpos($par_Filename, 'administrator/components/com_media/helpers/media.php') !== false) &&
		(strpos($par_Content, '$format == \'\' || $format == false ||') === false)
		) 
	{		
		if ($g_CmsListDetector->isCms(CMS_JOOMLA, '1.5')) {
			$l_Vuln['id'] = 'AFU : https://docs.joomla.org/Security_hotfixes_for_Joomla_EOL_versions';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (
	    (strpos($par_Filename, 'joomla/filesystem/file.php') !== false) &&
		(strpos($par_Content, '$file = rtrim($file, \'.\');') === false)
		) 
	{		
		if ($g_CmsListDetector->isCms(CMS_JOOMLA, '1.5')) {
			$l_Vuln['id'] = 'AFU : https://docs.joomla.org/Security_hotfixes_for_Joomla_EOL_versions';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if ((strpos($par_Filename, 'editor/filemanager/upload/test.html') !== false) ||
		(stripos($par_Filename, 'editor/filemanager/browser/default/connectors/php/') !== false) ||
		(stripos($par_Filename, 'editor/filemanager/connectors/uploadtest.html') !== false) ||
	   (strpos($par_Filename, 'editor/filemanager/browser/default/connectors/test.html') !== false)) {
		$l_Vuln['id'] = 'AFU : FCKEDITOR : http://www.exploit-db.com/exploits/17644/ & /exploit/249';
		$l_Vuln['ndx'] = $par_Index;
		$g_Vulnerable[] = $l_Vuln;
		return true;
	}

	if ((strpos($par_Filename, 'inc_php/image_view.class.php') !== false) ||
	    (strpos($par_Filename, '/inc_php/framework/image_view.class.php') !== false)) {
		if (strpos($par_Content, 'showImageByID') === false) {
			$l_Vuln['id'] = 'AFU : REVSLIDER : http://www.exploit-db.com/exploits/35385/';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if ((strpos($par_Filename, 'elfinder/php/connector.php') !== false) ||
	    (strpos($par_Filename, 'elfinder/elfinder.') !== false)) {
			$l_Vuln['id'] = 'AFU : elFinder';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
	}

	if (strpos($par_Filename, 'includes/database/database.inc') !== false) {
		if (strpos($par_Content, 'foreach ($data as $i => $value)') !== false) {
			$l_Vuln['id'] = 'SQLI : DRUPAL : CVE-2014-3704';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (strpos($par_Filename, 'engine/classes/min/index.php') !== false) {
		if (strpos($par_Content, 'tr_replace(chr(0)') === false) {
			$l_Vuln['id'] = 'AFD : MINIFY : CVE-2013-6619';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (( strpos($par_Filename, 'timthumb.php') !== false ) || 
	    ( strpos($par_Filename, 'thumb.php') !== false ) || 
	    ( strpos($par_Filename, 'cache.php') !== false ) || 
	    ( strpos($par_Filename, '_img.php') !== false )) {
		if (strpos($par_Content, 'code.google.com/p/timthumb') !== false && strpos($par_Content, '2.8.14') === false ) {
			$l_Vuln['id'] = 'RCE : TIMTHUMB : CVE-2011-4106,CVE-2014-4663';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (strpos($par_Filename, 'components/com_rsform/helpers/rsform.php') !== false) {
		if (strpos($par_Content, 'eval($form->ScriptDisplay);') !== false) {
			$l_Vuln['id'] = 'RCE : RSFORM : rsform.php, LINE 1605';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (strpos($par_Filename, 'fancybox-for-wordpress/fancybox.php') !== false) {
		if (strpos($par_Content, '\'reset\' == $_REQUEST[\'action\']') !== false) {
			$l_Vuln['id'] = 'CODE INJECTION : FANCYBOX';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}


	if (strpos($par_Filename, 'cherry-plugin/admin/import-export/upload.php') !== false) {
		if (strpos($par_Content, 'verify nonce') === false) {
			$l_Vuln['id'] = 'AFU : Cherry Plugin';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}
	
	
	if (strpos($par_Filename, 'tiny_mce/plugins/tinybrowser/tinybrowser.php') !== false) {	
		$l_Vuln['id'] = 'AFU : TINYMCE : http://www.exploit-db.com/exploits/9296/';
		$l_Vuln['ndx'] = $par_Index;
		$g_Vulnerable[] = $l_Vuln;
		
		return true;
	}

	if (strpos($par_Filename, '/bx_1c_import.php') !== false) {	
		if (strpos($par_Content, '$_GET[\'action\']=="getfiles"') !== false) {
   		   $l_Vuln['id'] = 'AFD : https://habrahabr.ru/company/dsec/blog/326166/';
   		   $l_Vuln['ndx'] = $par_Index;
   		   $g_Vulnerable[] = $l_Vuln;
   		
   		   return true;
                }
	}

	if (strpos($par_Filename, 'scripts/setup.php') !== false) {		
		if (strpos($par_Content, 'PMA_Config') !== false) {
			$l_Vuln['id'] = 'CODE INJECTION : PHPMYADMIN : http://1337day.com/exploit/5334';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (strpos($par_Filename, '/uploadify.php') !== false) {		
		if (strpos($par_Content, 'move_uploaded_file($tempFile,$targetFile') !== false) {
			$l_Vuln['id'] = 'AFU : UPLOADIFY : CVE: 2012-1153';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (strpos($par_Filename, 'com_adsmanager/controller.php') !== false) {		
		if (strpos($par_Content, 'move_uploaded_file($file[\'tmp_name\'], $tempPath.\'/\'.basename($file[') !== false) {
			$l_Vuln['id'] = 'AFU : https://revisium.com/ru/blog/adsmanager_afu.html';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (strpos($par_Filename, 'wp-content/plugins/wp-mobile-detector/resize.php') !== false) {		
		if (strpos($par_Content, 'file_put_contents($path, file_get_contents($_REQUEST[\'src\']));') !== false) {
			$l_Vuln['id'] = 'AFU : https://www.pluginvulnerabilities.com/2016/05/31/aribitrary-file-upload-vulnerability-in-wp-mobile-detector/';
			$l_Vuln['ndx'] = $par_Index;
			$g_Vulnerable[] = $l_Vuln;
			return true;
		}
		
		return false;
	}

	if (strpos($par_Filename, 'phpmailer.php') !== false) {		
		if (strpos($par_Content, 'PHPMailer') !== false) {
                        $l_Found = preg_match('~Version:\s*(\d+)\.(\d+)\.(\d+)~', $par_Content, $l_Match);

                        if ($l_Found) {
                           $l_Version = $l_Match[1] * 1000 + $l_Match[2] * 100 + $l_Match[3];

                           if ($l_Version < 2520) {
                              $l_Found = false;
                           }
                        }

                        if (!$l_Found) {

                           $l_Found = preg_match('~Version\s*=\s*\'(\d+)\.*(\d+)\.(\d+)~', $par_Content, $l_Match);
                           if ($l_Found) {
                              $l_Version = $l_Match[1] * 1000 + $l_Match[2] * 100 + $l_Match[3];
                              if ($l_Version < 5220) {
                                 $l_Found = false;
                              }
                           }
			}


		        if (!$l_Found) {
	   		   $l_Vuln['id'] = 'RCE : CVE-2016-10045, CVE-2016-10031';
			   $l_Vuln['ndx'] = $par_Index;
			   $g_Vulnerable[] = $l_Vuln;
			   return true;
                        }
		}
		
		return false;
	}




}

///////////////////////////////////////////////////////////////////////////
function QCR_GoScan($par_Offset)
{
	global $g_IframerFragment, $g_Iframer, $g_Redirect, $g_Doorway, $g_EmptyLink, $g_Structure, $g_Counter, 
		   $g_HeuristicType, $g_HeuristicDetected, $g_TotalFolder, $g_TotalFiles, $g_WarningPHP, $g_AdwareList,
		   $g_CriticalPHP, $g_Phishing, $g_CriticalJS, $g_UrlIgnoreList, $g_CriticalJSFragment, $g_PHPCodeInside, $g_PHPCodeInsideFragment, 
		   $g_NotRead, $g_WarningPHPFragment, $g_WarningPHPSig, $g_BigFiles, $g_RedirectPHPFragment, $g_EmptyLinkSrc, $g_CriticalPHPSig, $g_CriticalPHPFragment, 
           $g_Base64Fragment, $g_UnixExec, $g_PhishingSigFragment, $g_PhishingFragment, $g_PhishingSig, $g_CriticalJSSig, $g_IframerFragment, $g_CMS, $defaults, $g_AdwareListFragment, $g_KnownList,$g_Vulnerable;

    QCR_Debug('QCR_GoScan ' . $par_Offset);

	$i = 0;
	
	try {
		$s_file = new SplFileObject(QUEUE_FILENAME);
		$s_file->setFlags(SplFileObject::READ_AHEAD | SplFileObject::SKIP_EMPTY | SplFileObject::DROP_NEW_LINE);

		foreach ($s_file as $l_Filename) {
			QCR_ScanFile($l_Filename, $i++);
		}
		
		unset($s_file);	
	}
	catch (Exception $e) { QCR_Debug( $e->getMessage() ); }
}

///////////////////////////////////////////////////////////////////////////
function QCR_ScanFile($l_Filename, $i = 0)
{
	global $g_IframerFragment, $g_Iframer, $g_Redirect, $g_Doorway, $g_EmptyLink, $g_Structure, $g_Counter, 
		   $g_HeuristicType, $g_HeuristicDetected, $g_TotalFolder, $g_TotalFiles, $g_WarningPHP, $g_AdwareList,
		   $g_CriticalPHP, $g_Phishing, $g_CriticalJS, $g_UrlIgnoreList, $g_CriticalJSFragment, $g_PHPCodeInside, $g_PHPCodeInsideFragment, 
		   $g_NotRead, $g_WarningPHPFragment, $g_WarningPHPSig, $g_BigFiles, $g_RedirectPHPFragment, $g_EmptyLinkSrc, $g_CriticalPHPSig, $g_CriticalPHPFragment, 
           $g_Base64Fragment, $g_UnixExec, $g_PhishingSigFragment, $g_PhishingFragment, $g_PhishingSig, $g_CriticalJSSig, $g_IframerFragment, $g_CMS, $defaults, $g_AdwareListFragment, 
           $g_KnownList,$g_Vulnerable, $g_CriticalFiles;

	global $g_CRC;
	static $_files_and_ignored = 0;

			$l_CriticalDetected = false;
			$l_Stat = stat($l_Filename);

			if (substr($l_Filename, -1) == DIR_SEPARATOR) {
				// FOLDER
				$g_Structure['n'][$i] = $l_Filename;
				$g_TotalFolder++;
				printProgress($_files_and_ignored, $l_Filename);
				return;
			}

			QCR_Debug('Scan file ' . $l_Filename);
			printProgress(++$_files_and_ignored, $l_Filename);

			// FILE
			if ((MAX_SIZE_TO_SCAN > 0 AND $l_Stat['size'] > MAX_SIZE_TO_SCAN) || ($l_Stat['size'] < 0))
			{
				$g_BigFiles[] = $i;

                                if (function_exists('aibolit_onBigFile')) { aibolit_onBigFile($l_Filename); }

				AddResult($l_Filename, $i);

		                $l_Ext = strtolower(pathinfo($l_Filename, PATHINFO_EXTENSION));
                                if ((!AI_HOSTER) && in_array($l_Ext, $g_CriticalFiles)) {
				    $g_CriticalPHP[] = $i;
				    $g_CriticalPHPFragment[] = "BIG FILE. SKIPPED.";
				    $g_CriticalPHPSig[] = "big_1";
                                }
			}
			else
			{
				$g_TotalFiles++;

			$l_TSStartScan = microtime(true);

		$l_Ext = strtolower(pathinfo($l_Filename, PATHINFO_EXTENSION));
		if (filetype($l_Filename) == 'file') {
                   $l_Content = @file_get_contents($l_Filename);
		   if (SHORT_PHP_TAG) {
//                      $l_Content = preg_replace('|<\?\s|smiS', '<?php ', $l_Content); 
                   }

                   $l_Unwrapped = @php_strip_whitespace($l_Filename);
                }

		
                if ((($l_Content == '') || ($l_Unwrapped == '')) && ($l_Stat['size'] > 0)) {
                   $g_NotRead[] = $i;
                   if (function_exists('aibolit_onReadError')) { aibolit_onReadError($l_Filename, 'io'); }
                   AddResult('[io] ' . $l_Filename, $i);
                   return;
                }

				// ignore itself
				if (strpos($l_Content, '264215fae8356a91afdd3514567f7f50') !== false) {
					return;
				}

				// unix executables
				if (strpos($l_Content, chr(127) . 'ELF') !== false) 
				{
			        	if (!in_array($l_Filename, $g_UnixExec)) {
                    				$g_UnixExec[] = $l_Filename;
					}

				        return;
                		}

				$g_CRC = _hash_($l_Unwrapped);

				$l_UnicodeContent = detect_utf_encoding($l_Content);
				//$l_Unwrapped = $l_Content;

				// check vulnerability in files
				$l_CriticalDetected = CheckVulnerability($l_Filename, $i, $l_Content);				

				if ($l_UnicodeContent !== false) {
       				   if (function_exists('iconv')) {
				      $l_Unwrapped = iconv($l_UnicodeContent, "CP1251//IGNORE", $l_Unwrapped);
//       			   if (function_exists('mb_convert_encoding')) {
//                                    $l_Unwrapped = mb_convert_encoding($l_Unwrapped, $l_UnicodeContent, "CP1251");
                                   } else {
                                      $g_NotRead[] = $i;
                                      if (function_exists('aibolit_onReadError')) { aibolit_onReadError($l_Filename, 'ec'); }
                                      AddResult('[ec] ' . $l_Filename, $i);
				   }
                                }

				$l_Unwrapped = UnwrapObfu($l_Unwrapped);
				
				// critical
				$g_SkipNextCheck = false;

				if (CriticalPHP($l_Filename, $i, $l_Unwrapped, $l_Pos, $l_SigId))
				{
				        if ($l_Ext == 'js') {
 					   $g_CriticalJS[] = $i;
 					   $g_CriticalJSFragment[] = getFragment($l_Unwrapped, $l_Pos);
 					   $g_CriticalJSSig[] = $l_SigId;
                                        } else {
       					   $g_CriticalPHP[] = $i;
       					   $g_CriticalPHPFragment[] = getFragment($l_Unwrapped, $l_Pos);
      					   $g_CriticalPHPSig[] = $l_SigId;
                                        }

					$g_SkipNextCheck = true;
				} else {
         				if (CriticalPHP($l_Filename, $i, $l_Content, $l_Pos, $l_SigId))
         				{
					        if ($l_Ext == 'js') {
         					   $g_CriticalJS[] = $i;
         					   $g_CriticalJSFragment[] = getFragment($l_Content, $l_Pos);
         					   $g_CriticalJSSig[] = $l_SigId;
                                                } else {
               					   $g_CriticalPHP[] = $i;
               					   $g_CriticalPHPFragment[] = getFragment($l_Content, $l_Pos);
      						   $g_CriticalPHPSig[] = $l_SigId;
                                                }

         					$g_SkipNextCheck = true;
         				}
				}

				$l_TypeDe = 0;
			    if ((!$g_SkipNextCheck) && HeuristicChecker($l_Content, $l_TypeDe, $l_Filename)) {
					$g_HeuristicDetected[] = $i;
					$g_HeuristicType[] = $l_TypeDe;
					$l_CriticalDetected = true;
				}

				// critical JS
				if (!$g_SkipNextCheck) {
					$l_Pos = CriticalJS($l_Filename, $i, $l_Unwrapped, $l_SigId);
					if ($l_Pos !== false)
					{
					        if ($l_Ext == 'js') {
         					   $g_CriticalJS[] = $i;
         					   $g_CriticalJSFragment[] = getFragment($l_Unwrapped, $l_Pos);
         					   $g_CriticalJSSig[] = $l_SigId;
                                                } else {
               					   $g_CriticalPHP[] = $i;
               					   $g_CriticalPHPFragment[] = getFragment($l_Unwrapped, $l_Pos);
      						   $g_CriticalPHPSig[] = $l_SigId;
                                                }

						$g_SkipNextCheck = true;
					}
			    }

				// phishing
				if (!$g_SkipNextCheck) {
					$l_Pos = Phishing($l_Filename, $i, $l_Unwrapped, $l_SigId);
					if ($l_Pos === false) {
                                            $l_Pos = Phishing($l_Filename, $i, $l_Content, $l_SigId);
                                        }

					if ($l_Pos !== false)
					{
						$g_Phishing[] = $i;
						$g_PhishingFragment[] = getFragment($l_Unwrapped, $l_Pos);
						$g_PhishingSigFragment[] = $l_SigId;
						$g_SkipNextCheck = true;
					}
				}

			
			if (!$g_SkipNextCheck) {
				if (SCAN_ALL_FILES || stripos($l_Filename, 'index.'))
				{
					// check iframes
					if (preg_match_all('|<iframe[^>]+src.+?>|smi', $l_Unwrapped, $l_Found, PREG_SET_ORDER)) 
					{
						for ($kk = 0; $kk < count($l_Found); $kk++) {
						    $l_Pos = stripos($l_Found[$kk][0], 'http://');
						    $l_Pos = $l_Pos || stripos($l_Found[$kk][0], 'https://');
						    $l_Pos = $l_Pos || stripos($l_Found[$kk][0], 'ftp://');
							if  (($l_Pos !== false ) && (!knowUrl($l_Found[$kk][0]))) {
         						$g_Iframer[] = $i;
         						$g_IframerFragment[] = getFragment($l_Found[$kk][0], $l_Pos);
         						$l_CriticalDetected = true;
							}
						}
					}

					// check empty links
					if ((($defaults['report_mask'] & REPORT_MASK_SPAMLINKS) == REPORT_MASK_SPAMLINKS) &&
					   (preg_match_all('|<a[^>]+href([^>]+?)>(.*?)</a>|smi', $l_Unwrapped, $l_Found, PREG_SET_ORDER)))
					{
						for ($kk = 0; $kk < count($l_Found); $kk++) {
							if  ((stripos($l_Found[$kk][1], 'http://') !== false) &&
                                                            (trim(strip_tags($l_Found[$kk][2])) == '')) {

								$l_NeedToAdd = true;

							    if  ((stripos($l_Found[$kk][1], $defaults['site_url']) !== false)
                                                                 || knowUrl($l_Found[$kk][1])) {
										$l_NeedToAdd = false;
								}
								
								if ($l_NeedToAdd && (count($g_EmptyLink) < MAX_EXT_LINKS)) {
									$g_EmptyLink[] = $i;
									$g_EmptyLinkSrc[$i][] = substr($l_Found[$kk][0], 0, MAX_PREVIEW_LEN);
									$l_CriticalDetected = true;
								}
							}
						}
					}
				}

				// check for PHP code inside any type of file
				if (stripos($l_Ext, 'ph') === false)
				{
					$l_Pos = QCR_SearchPHP($l_Content);
					if ($l_Pos !== false)
					{
						$g_PHPCodeInside[] = $i;
						$g_PHPCodeInsideFragment[] = getFragment($l_Unwrapped, $l_Pos);
						$l_CriticalDetected = true;
					}
				}

				// htaccess
				if (stripos($l_Filename, '.htaccess'))
				{
				
					if (stripos($l_Content, 'index.php?name=$1') !== false ||
						stripos($l_Content, 'index.php?m=1') !== false
					)
					{
						$g_SuspDir[] = $i;
					}

					$l_HTAContent = preg_replace('|^\s*#.+$|m', '', $l_Content);

					$l_Pos = stripos($l_Content, 'auto_prepend_file');
					if ($l_Pos !== false) {
						$g_Redirect[] = $i;
						$g_RedirectPHPFragment[] = getFragment($l_Content, $l_Pos);
						$l_CriticalDetected = true;
					}
					
					$l_Pos = stripos($l_Content, 'auto_append_file');
					if ($l_Pos !== false) {
						$g_Redirect[] = $i;
						$g_RedirectPHPFragment[] = getFragment($l_Content, $l_Pos);
						$l_CriticalDetected = true;
					}

					$l_Pos = stripos($l_Content, '^(%2d|-)[^=]+$');
					if ($l_Pos !== false)
					{
						$g_Redirect[] = $i;
                        			$g_RedirectPHPFragment[] = getFragment($l_Content, $l_Pos);
						$l_CriticalDetected = true;
					}

					if (!$l_CriticalDetected) {
						$l_Pos = stripos($l_Content, '%{HTTP_USER_AGENT}');
						if ($l_Pos !== false)
						{
							$g_Redirect[] = $i;
							$g_RedirectPHPFragment[] = getFragment($l_Content, $l_Pos);
							$l_CriticalDetected = true;
						}
					}

					if (!$l_CriticalDetected) {
						if (
							preg_match_all("|RewriteRule\s+.+?\s+http://(.+?)/.+\s+\[.*R=\d+.*\]|smi", $l_HTAContent, $l_Found, PREG_SET_ORDER)
						)
						{
							$l_Host = str_replace('www.', '', $_SERVER['HTTP_HOST']);
							for ($j = 0; $j < sizeof($l_Found); $j++)
							{
								$l_Found[$j][1] = str_replace('www.', '', $l_Found[$j][1]);
								if ($l_Found[$j][1] != $l_Host)
								{
									$g_Redirect[] = $i;
									$l_CriticalDetected = true;
									break;
								}
							}
						}
					}

					unset($l_HTAContent);
			    }
			

			    // warnings
				$l_Pos = '';
				
			    if (WarningPHP($l_Filename, $l_Unwrapped, $l_Pos, $l_SigId))
				{       
					$l_Prio = 1;
					if (strpos($l_Filename, '.ph') !== false) {
					   $l_Prio = 0;
					}
					
					$g_WarningPHP[$l_Prio][] = $i;
					$g_WarningPHPFragment[$l_Prio][] = getFragment($l_Unwrapped, $l_Pos);
					$g_WarningPHPSig[] = $l_SigId;

					$l_CriticalDetected = true;
				}
				

				// adware
				if (Adware($l_Filename, $l_Unwrapped, $l_Pos))
				{
					$g_AdwareList[] = $i;
					$g_AdwareListFragment[] = getFragment($l_Unwrapped, $l_Pos);
					$l_CriticalDetected = true;
				}

				// articles
				if (stripos($l_Filename, 'article_index'))
				{
					$g_AdwareList[] = $i;
					$l_CriticalDetected = true;
				}
			}
		} // end of if (!$g_SkipNextCheck) {
			
			unset($l_Unwrapped);
			unset($l_Content);
			
			//printProgress(++$_files_and_ignored, $l_Filename);

			$l_TSEndScan = microtime(true);
                        if ($l_TSEndScan - $l_TSStartScan >= 0.5) {
			   			   usleep(SCAN_DELAY * 1000);
                        }

			if ($g_SkipNextCheck || $l_CriticalDetected) {
				AddResult($l_Filename, $i);
			}
}

function AddResult($l_Filename, $i)
{
	global $g_Structure, $g_CRC;
	
	$l_Stat = stat($l_Filename);
	$g_Structure['n'][$i] = $l_Filename;
	$g_Structure['s'][$i] = $l_Stat['size'];
	$g_Structure['c'][$i] = $l_Stat['ctime'];
	$g_Structure['m'][$i] = $l_Stat['mtime'];
	$g_Structure['crc'][$i] = $g_CRC;
}

///////////////////////////////////////////////////////////////////////////
function WarningPHP($l_FN, $l_Content, &$l_Pos, &$l_SigId)
{
	   global $g_SusDB,$g_ExceptFlex, $gXX_FlexDBShe, $gX_FlexDBShe, $g_FlexDBShe, $gX_DBShe, $g_DBShe, $g_Base64, $g_Base64Fragment;

  $l_Res = false;

  if (AI_EXTRA_WARN) {
  	foreach ($g_SusDB as $l_Item) {
    	if (preg_match('#' . $l_Item . '#smiS', $l_Content, $l_Found, PREG_OFFSET_CAPTURE)) {
       	 	if (!CheckException($l_Content, $l_Found)) {
           	 	$l_Pos = $l_Found[0][1];
           	 	//$l_SigId = myCheckSum($l_Item);
           	 	$l_SigId = getSigId($l_Found);
           	 	return true;
       	 	}
    	}
  	}
  }

  if (AI_EXPERT < 2) {
    	foreach ($gXX_FlexDBShe as $l_Item) {
      		if (preg_match('#' . $l_Item . '#smiS', $l_Content, $l_Found, PREG_OFFSET_CAPTURE)) {
             	$l_Pos = $l_Found[0][1];
           	    //$l_SigId = myCheckSum($l_Item);
           	    $l_SigId = getSigId($l_Found);
        	    return true;
	  		}
    	}

	}

    if (AI_EXPERT < 1) {
    	foreach ($gX_FlexDBShe as $l_Item) {
      		if (preg_match('#' . $l_Item . '#smiS', $l_Content, $l_Found, PREG_OFFSET_CAPTURE)) {
             	$l_Pos = $l_Found[0][1];
           	 	//$l_SigId = myCheckSum($l_Item);
           	 	$l_SigId = getSigId($l_Found);
        	    return true;
	  		}
    	}

	    $l_Content_lo = strtolower($l_Content);

	    foreach ($gX_DBShe as $l_Item) {
	      $l_Pos = strpos($l_Content_lo, $l_Item);
	      if ($l_Pos !== false) {
	         $l_SigId = myCheckSum($l_Item);
	         return true;
	      }
		}
	}

}

///////////////////////////////////////////////////////////////////////////
function Adware($l_FN, $l_Content, &$l_Pos)
{
  global $g_AdwareSig;

  $l_Res = false;

foreach ($g_AdwareSig as $l_Item) {
    $offset = 0;
    while (preg_match('#' . $l_Item . '#smi', $l_Content, $l_Found, PREG_OFFSET_CAPTURE, $offset)) {
       if (!CheckException($l_Content, $l_Found)) {
           $l_Pos = $l_Found[0][1];
           return true;
       }

       $offset = $l_Found[0][1] + 1;
    }
  }

  return $l_Res;
}

///////////////////////////////////////////////////////////////////////////
function CheckException(&$l_Content, &$l_Found) {
  global $g_ExceptFlex, $gX_FlexDBShe, $gXX_FlexDBShe, $g_FlexDBShe, $gX_DBShe, $g_DBShe, $g_Base64, $g_Base64Fragment;
   $l_FoundStrPlus = substr($l_Content, max($l_Found[0][1] - 10, 0), 70);

   foreach ($g_ExceptFlex as $l_ExceptItem) {
      if (@preg_match('#' . $l_ExceptItem . '#smi', $l_FoundStrPlus, $l_Detected)) {
//         print("\n\nEXCEPTION FOUND\n[" . $l_ExceptItem .  "]\n" . $l_Content . "\n\n----------\n\n");
         return true;
      }
   }

   return false;
}

///////////////////////////////////////////////////////////////////////////
function Phishing($l_FN, $l_Index, $l_Content, &$l_SigId)
{
  global $g_PhishingSig, $g_PhishFiles, $g_PhishEntries;

  $l_Res = false;

  // need check file (by extension) ?
  $l_SkipCheck = SMART_SCAN;

if ($l_SkipCheck) {
  	foreach($g_PhishFiles as $l_Ext) {
  		  if (strpos($l_FN, $l_Ext) !== false) {
		  			$l_SkipCheck = false;
		  		  	break;
  	  	  }
  	  }
  }

  // need check file (by signatures) ?
  if ($l_SkipCheck && preg_match('~' . $g_PhishEntries . '~smiS', $l_Content, $l_Found)) {
	  $l_SkipCheck = false;
  }

  if ($l_SkipCheck && SMART_SCAN) {
      if (DEBUG_MODE) {
         echo "Skipped phs file, not critical.\n";
      }

	  return false;
  }


  foreach ($g_PhishingSig as $l_Item) {
    $offset = 0;
    while (preg_match('#' . $l_Item . '#smi', $l_Content, $l_Found, PREG_OFFSET_CAPTURE, $offset)) {
       if (!CheckException($l_Content, $l_Found)) {
           $l_Pos = $l_Found[0][1];
//           $l_SigId = myCheckSum($l_Item);
           $l_SigId = getSigId($l_Found);

           if (DEBUG_MODE) {
              echo "Phis: $l_FN matched [$l_Item] in $l_Pos\n";
           }

           return $l_Pos;
       }
       $offset = $l_Found[0][1] + 1;

    }
  }

  return $l_Res;
}

///////////////////////////////////////////////////////////////////////////
function CriticalJS($l_FN, $l_Index, $l_Content, &$l_SigId)
{
  global $g_JSVirSig, $gX_JSVirSig, $g_VirusFiles, $g_VirusEntries;

  $l_Res = false;
  
    // need check file (by extension) ?
    $l_SkipCheck = SMART_SCAN;
	
	if ($l_SkipCheck) {
    	foreach($g_VirusFiles as $l_Ext) {
    		  if (strpos($l_FN, $l_Ext) !== false) {
  		  			$l_SkipCheck = false;
  		  		  	break;
    	  	  }
    	  }
	  }
  
    // need check file (by signatures) ?
    if ($l_SkipCheck && preg_match('~' . $g_VirusEntries . '~smiS', $l_Content, $l_Found)) {
  	  $l_SkipCheck = false;
    }
  
    if ($l_SkipCheck && SMART_SCAN) {
        if (DEBUG_MODE) {
           echo "Skipped js file, not critical.\n";
        }

  	  return false;
    }
  

  foreach ($g_JSVirSig as $l_Item) {
    $offset = 0;
    while (preg_match('#' . $l_Item . '#smi', $l_Content, $l_Found, PREG_OFFSET_CAPTURE, $offset)) {
       if (!CheckException($l_Content, $l_Found)) {
           $l_Pos = $l_Found[0][1];
//           $l_SigId = myCheckSum($l_Item);
           $l_SigId = getSigId($l_Found);

           if (DEBUG_MODE) {
              echo "JS: $l_FN matched [$l_Item] in $l_Pos\n";
           }

           return $l_Pos;
       }

       $offset = $l_Found[0][1] + 1;

    }

//   if (pcre_error($l_FN, $l_Index)) {  }

  }

if (AI_EXPERT > 1) {
  foreach ($gX_JSVirSig as $l_Item) {
    if (preg_match('#' . $l_Item . '#smi', $l_Content, $l_Found, PREG_OFFSET_CAPTURE)) {
       if (!CheckException($l_Content, $l_Found)) {
           $l_Pos = $l_Found[0][1];
           //$l_SigId = myCheckSum($l_Item);
           $l_SigId = getSigId($l_Found);

           if (DEBUG_MODE) {
              echo "JS PARA: $l_FN matched [$l_Item] in $l_Pos\n";
           }

           return $l_Pos;
       }
    }

//   if (pcre_error($l_FN, $l_Index)) {  }

  }
}

  return $l_Res;
}

////////////////////////////////////////////////////////////////////////////
function pcre_error($par_FN, $par_Index) {
   global $g_NotRead, $g_Structure;

   $err = preg_last_error();
   if (($err == PREG_BACKTRACK_LIMIT_ERROR) || ($err == PREG_RECURSION_LIMIT_ERROR)) {
      if (!in_array($par_Index, $g_NotRead)) {
         if (function_exists('aibolit_onReadError')) { aibolit_onReadError($l_Filename, 're'); }
         $g_NotRead[] = $par_Index;
         AddResult('[re] ' . $par_FN, $par_Index);
      }
 
      return true;
   }

   return false;
}



////////////////////////////////////////////////////////////////////////////
define('SUSP_MTIME', 1); // suspicious mtime (greater than ctime)
define('SUSP_PERM', 2); // suspicious permissions 
define('SUSP_PHP_IN_UPLOAD', 3); // suspicious .php file in upload or image folder 

  function get_descr_heur($type) {
     switch ($type) {
	     case SUSP_MTIME: return AI_STR_077; 
	     case SUSP_PERM: return AI_STR_078;  
	     case SUSP_PHP_IN_UPLOAD: return AI_STR_079; 
	 }
	 
	 return "---";
  }

  ///////////////////////////////////////////////////////////////////////////
  function HeuristicChecker($l_Content, &$l_Type, $l_Filename) {
     $res = false;
	 
	 $l_Stat = stat($l_Filename);
	 // most likely changed by touch
	 if ($l_Stat['ctime'] < $l_Stat['mtime']) {
	     $l_Type = SUSP_MTIME;
		 return true;
	 }

	 	 
	 $l_Perm = fileperms($l_Filename) & 0777;
	 if (($l_Perm & 0400 != 0400) || // not readable by owner
		($l_Perm == 0000) ||
		($l_Perm == 0404) ||
		($l_Perm == 0505))
	 {
		 $l_Type = SUSP_PERM;
		 return true;
	 }

	 
     if ((strpos($l_Filename, '.ph')) && (
	     strpos($l_Filename, '/images/stories/') ||
	     //strpos($l_Filename, '/img/') ||
		 //strpos($l_Filename, '/images/') ||
	     //strpos($l_Filename, '/uploads/') ||
		 strpos($l_Filename, '/wp-content/upload/') 
	    )	    
	 ) {
		$l_Type = SUSP_PHP_IN_UPLOAD;
	 	return true;
	 }

     return false;
  }

///////////////////////////////////////////////////////////////////////////
function CriticalPHP($l_FN, $l_Index, $l_Content, &$l_Pos, &$l_SigId)
{
  global $g_ExceptFlex, $gXX_FlexDBShe, $gX_FlexDBShe, $g_FlexDBShe, $gX_DBShe, $g_DBShe, $g_Base64, $g_Base64Fragment,
  $g_CriticalFiles, $g_CriticalEntries;

  // 264215fae8356a91afdd3514567f7f50 H24LKHGHCGHFHGKJHGKJHGGGHJ

  // need check file (by extension) ?
  $l_SkipCheck = SMART_SCAN;

  if ($l_SkipCheck) {
	  foreach($g_CriticalFiles as $l_Ext) {
  	  	if ((strpos($l_FN, $l_Ext) !== false) && (strpos($l_FN, '.js') === false)) {
		   $l_SkipCheck = false;
		   break;
  	  	}
  	  }
  }
  
  // need check file (by signatures) ?
  if ($l_SkipCheck && preg_match('~' . $g_CriticalEntries . '~smiS', $l_Content, $l_Found)) {
     $l_SkipCheck = false;
  }
  
  
  // if not critical - skip it 
  if ($l_SkipCheck && SMART_SCAN) {
      if (DEBUG_MODE) {
         echo "Skipped file, not critical.\n";
      }

	  return false;
  }

  foreach ($g_FlexDBShe as $l_Item) {
    $offset = 0;
    while (preg_match('#' . $l_Item . '#smiS', $l_Content, $l_Found, PREG_OFFSET_CAPTURE, $offset)) {
       if (!CheckException($l_Content, $l_Found)) {
           $l_Pos = $l_Found[0][1];
           //$l_SigId = myCheckSum($l_Item);
           $l_SigId = getSigId($l_Found);

           if (DEBUG_MODE) {
              echo "CRIT 1: $l_FN matched [$l_Item] in $l_Pos\n";
           }

           return true;
       }

       $offset = $l_Found[0][1] + 1;

    }

//   if (pcre_error($l_FN, $l_Index)) {  }

  }

if (AI_EXPERT > 0) {
  foreach ($gX_FlexDBShe as $l_Item) {
    if (preg_match('#' . $l_Item . '#smiS', $l_Content, $l_Found, PREG_OFFSET_CAPTURE)) {
       if (!CheckException($l_Content, $l_Found)) {
           $l_Pos = $l_Found[0][1];
           //$l_SigId = myCheckSum($l_Item);
           $l_SigId = getSigId($l_Found);

           if (DEBUG_MODE) {
              echo "CRIT 3: $l_FN matched [$l_Item] in $l_Pos\n";
           }

           return true;
       }
    }

//   if (pcre_error($l_FN, $l_Index)) {  }
  }
}

if (AI_EXPERT > 1) {
  foreach ($gXX_FlexDBShe as $l_Item) {
    if (preg_match('#' . $l_Item . '#smiS', $l_Content, $l_Found, PREG_OFFSET_CAPTURE)) {
       if (!CheckException($l_Content, $l_Found)) {
           $l_Pos = $l_Found[0][1];
           //$l_SigId = myCheckSum($l_Item);
           $l_SigId = getSigId($l_Found);

           if (DEBUG_MODE) {
              echo "CRIT 2: $l_FN matched [$l_Item] in $l_Pos\n";
           }

           return true;
       }
    }

//   if (pcre_error($l_FN, $l_Index)) {  }
  }
}

  $l_Content_lo = strtolower($l_Content);

  foreach ($g_DBShe as $l_Item) {
    $l_Pos = strpos($l_Content_lo, $l_Item);
    if ($l_Pos !== false) {
       $l_SigId = myCheckSum($l_Item);

       if (DEBUG_MODE) {
          echo "CRIT 4: $l_FN matched [$l_Item] in $l_Pos\n";
       }

       return true;
    }
  }

if (AI_EXPERT > 0) {
  foreach ($gX_DBShe as $l_Item) {
    $l_Pos = strpos($l_Content_lo, $l_Item);
    if ($l_Pos !== false) {
       $l_SigId = myCheckSum($l_Item);

       if (DEBUG_MODE) {
          echo "CRIT 5: $l_FN matched [$l_Item] in $l_Pos\n";
       }

       return true;
    }
  }
}

if (AI_HOSTER) return false;

if (AI_EXPERT > 0) {
  if ((strpos($l_Content, 'GIF89') === 0) && (strpos($l_FN, '.php') !== false )) {
     $l_Pos = 0;

     if (DEBUG_MODE) {
          echo "CRIT 6: $l_FN matched [$l_Item] in $l_Pos\n";
     }

     return true;
  }
}

  // detect uploaders / droppers
if (AI_EXPERT > 1) {
  $l_Found = null;
  if (
     (filesize($l_FN) < 1024) &&
     (strpos($l_FN, '.ph') !== false) &&
     (
       (($l_Pos = strpos($l_Content, 'multipart/form-data')) > 0) || 
       (($l_Pos = strpos($l_Content, '$_FILE[') > 0)) ||
       (($l_Pos = strpos($l_Content, 'move_uploaded_file')) > 0) ||
       (preg_match('|\bcopy\s*\(|smi', $l_Content, $l_Found, PREG_OFFSET_CAPTURE))
     )
     ) {
       if ($l_Found != null) {
          $l_Pos = $l_Found[0][1];
       } 
     if (DEBUG_MODE) {
          echo "CRIT 7: $l_FN matched [$l_Item] in $l_Pos\n";
     }

     return true;
  }
}

  return false;
}

///////////////////////////////////////////////////////////////////////////
if (!isCli()) {
   header('Content-type: text/html; charset=utf-8');
}

if (!isCli()) {

  $l_PassOK = false;
  if (strlen(PASS) > 8) {
     $l_PassOK = true;   
  } 

  if ($l_PassOK && preg_match('|[0-9]|', PASS, $l_Found) && preg_match('|[A-Z]|', PASS, $l_Found) && preg_match('|[a-z]|', PASS, $l_Found) ) {
     $l_PassOK = true;   
  }
  
  if (!$l_PassOK) {  
    echo sprintf(AI_STR_009, generatePassword());
    exit;
  }

  if (isset($_GET['fn']) && ($_GET['ph'] == crc32(PASS))) {
     printFile();
     exit;
  }

  if ($_GET['p'] != PASS) {
    $generated_pass = generatePassword(); 
    echo sprintf(AI_STR_010, $generated_pass, $generated_pass);
    exit;
  }
}

if (!is_readable(ROOT_PATH)) {
  echo AI_STR_011;
  exit;
}

if (isCli()) {
	if (defined('REPORT_PATH') AND REPORT_PATH)
	{
		if (!is_writable(REPORT_PATH))
		{
			die2("\nCannot write report. Report dir " . REPORT_PATH . " is not writable.");
		}

		else if (!REPORT_FILE)
		{
			die2("\nCannot write report. Report filename is empty.");
		}

		else if (($file = REPORT_PATH . DIR_SEPARATOR . REPORT_FILE) AND is_file($file) AND !is_writable($file))
		{
			die2("\nCannot write report. Report file '$file' exists but is not writable.");
		}
	}
}


// detect version CMS
$g_KnownCMS = array();
$tmp_cms = array();
$g_CmsListDetector = new CmsVersionDetector(ROOT_PATH);
$l_CmsDetectedNum = $g_CmsListDetector->getCmsNumber();
for ($tt = 0; $tt < $l_CmsDetectedNum; $tt++) {
    $g_CMS[] = $g_CmsListDetector->getCmsName($tt) . ' v' . makeSafeFn($g_CmsListDetector->getCmsVersion($tt));
    $tmp_cms[strtolower($g_CmsListDetector->getCmsName($tt))] = 1;
}

if (count($tmp_cms) > 0) {
   $g_KnownCMS = array_keys($tmp_cms);
   $len = count($g_KnownCMS);
   for ($i = 0; $i < $len; $i++) {
      if ($g_KnownCMS[$i] == strtolower(CMS_WORDPRESS)) $g_KnownCMS[] = 'wp';
      if ($g_KnownCMS[$i] == strtolower(CMS_WEBASYST)) $g_KnownCMS[] = 'shopscript';
      if ($g_KnownCMS[$i] == strtolower(CMS_IPB)) $g_KnownCMS[] = 'ipb';
      if ($g_KnownCMS[$i] == strtolower(CMS_DLE)) $g_KnownCMS[] = 'dle';
      if ($g_KnownCMS[$i] == strtolower(CMS_INSTANTCMS)) $g_KnownCMS[] = 'instantcms';
      if ($g_KnownCMS[$i] == strtolower(CMS_SHOPSCRIPT)) $g_KnownCMS[] = 'shopscript';
   }
}


$g_DirIgnoreList = array();
$g_IgnoreList = array();
$g_UrlIgnoreList = array();
$g_KnownList = array();

$l_IgnoreFilename = $g_AiBolitAbsolutePath . '/.aignore';
$l_DirIgnoreFilename = $g_AiBolitAbsolutePath . '/.adirignore';
$l_UrlIgnoreFilename = $g_AiBolitAbsolutePath . '/.aurlignore';
$l_KnownFilename = '.aknown';

if (file_exists($l_IgnoreFilename)) {
    $l_IgnoreListRaw = file($l_IgnoreFilename);
    for ($i = 0; $i < count($l_IgnoreListRaw); $i++) 
    {
    	$g_IgnoreList[] = explode("\t", trim($l_IgnoreListRaw[$i]));
    }
    unset($l_IgnoreListRaw);
}

if (file_exists($l_DirIgnoreFilename)) {
    $g_DirIgnoreList = file($l_DirIgnoreFilename);
	
	for ($i = 0; $i < count($g_DirIgnoreList); $i++) {
		$g_DirIgnoreList[$i] = trim($g_DirIgnoreList[$i]);
	}
}

if (file_exists($l_UrlIgnoreFilename)) {
    $g_UrlIgnoreList = file($l_UrlIgnoreFilename);
	
	for ($i = 0; $i < count($g_UrlIgnoreList); $i++) {
		$g_UrlIgnoreList[$i] = trim($g_UrlIgnoreList[$i]);
	}
}


$l_SkipMask = array(
            '/template_\w{32}.css',
            '/cache/templates/.{1,150}\.tpl\.php',
	    '/system/cache/templates_c/\w{1,40}\.php',
	    '/assets/cache/rss/\w{1,60}',
            '/cache/minify/minify_\w{32}',
            '/cache/page/\w{32}\.php',
            '/cache/object/\w{1,10}/\w{1,10}/\w{1,10}/\w{32}\.php',
            '/cache/wp-cache-\d{32}\.php',
            '/cache/page/\w{32}\.php_expire',
	    '/cache/page/\w{32}-cache-page-\w{32}\.php',
	    '\w{32}-cache-com_content-\w{32}\.php',
	    '\w{32}-cache-mod_custom-\w{32}\.php',
	    '\w{32}-cache-mod_templates-\w{32}\.php',
            '\w{32}-cache-_system-\w{32}\.php',
            '/cache/twig/\w{1,32}/\d+/\w{1,100}\.php', 
            '/autoptimize/js/autoptimize_\w{32}\.js',
            '/bitrix/cache/\w{32}\.php',
            '/bitrix/cache/.+/\w{32}\.php',
            '/bitrix/cache/iblock_find/',
            '/bitrix/managed_cache/MYSQL/user_option/[^/]+/',
            '/bitrix/cache/s1/bitrix/catalog\.section/',
            '/bitrix/cache/s1/bitrix/catalog\.element/',
            '/bitrix/cache/s1/bitrix/menu/',
            '/catalog.element/[^/]+/[^/]+/\w{32}\.php',
            '/bitrix/managed\_cache/.*/\.\w{32}\.php',
            '/core/cache/mgr/smarty/default/.{1,100}\.tpl\.php',
            '/core/cache/resource/web/resources/[0-9]{1,50}\.cache\.php',
            '/smarty/compiled/SC/.*/%%.*\.php',
            '/smarty/.{1,150}\.tpl\.php',
            '/smarty/compile/.{1,150}\.tpl\.cache\.php',
            '/files/templates_c/.{1,150}\.html\.php',
            '/uploads/javascript_global/.{1,150}\.js',
            '/assets/cache/rss/\w{32}',
	    '/assets/cache/docid_\d+_\w{32}\.pageCache\.php',
            '/t3-assets/dev/t3/.*-cache-\w{1,20}-.{1,150}\.php',
	    '/t3-assets/js/js-\w{1,30}\.js',
            '/temp/cache/SC/.*/\.cache\..*\.php',
            '/tmp/sess\_\w{32}$',
            '/assets/cache/docid\_.*\.pageCache\.php',
            '/stat/usage\_\w+\.html',
            '/stat/site\_\w+\.html',
            '/gallery/item/list/\w+\.cache\.php',
            '/core/cache/registry/.*/ext-.*\.php',
            '/core/cache/resource/shk\_/\w+\.cache\.php',
            '/webstat/awstats.*\.txt',
            '/awstats/awstats.*\.txt',
            '/awstats/.{1,80}\.pl',
            '/awstats/.{1,80}\.html',
            '/inc/min/styles_\w+\.min\.css',
            '/inc/min/styles_\w+\.min\.js',
            '/logs/error\_log\..*',
            '/logs/xferlog\..*',
            '/logs/access_log\..*',
            '/logs/cron\..*',
            '/logs/exceptions/.+\.log$',
            '/hyper-cache/[^/]+/[^/]+/[^/]+/index\.html',
            '/mail/new/[^,]+,S=[^,]+,W=.+',
            '/mail/new/[^,]=,S=.+',
            '/application/logs/\d+/\d+/\d+\.php',
            '/sites/default/files/js/js_\w{32}\.js',
            '/yt-assets/\w{32}\.css',
);

$l_SkipSample = array();

if (SMART_SCAN) {
   $g_DirIgnoreList = array_merge($g_DirIgnoreList, $l_SkipMask);
}

QCR_Debug();

// Load custom signatures

try {
	$s_file = new SplFileObject($g_AiBolitAbsolutePath."/ai-bolit.sig");
	$s_file->setFlags(SplFileObject::READ_AHEAD | SplFileObject::SKIP_EMPTY | SplFileObject::DROP_NEW_LINE);
	foreach ($s_file as $line) {
		$g_FlexDBShe[] = preg_replace('~\G(?:[^#\\\\]+|\\\\.)*+\K#~', '\\#', $line); // escaping #
	}
	stdOut("Loaded " . $s_file->key() . " signatures from ai-bolit.sig");
	$s_file = null; // file handler is closed
} catch (Exception $e) { QCR_Debug( "Import ai-bolit.sig " . $e->getMessage() ); }

QCR_Debug();

	$defaults['skip_ext'] = strtolower(trim($defaults['skip_ext']));
         if ($defaults['skip_ext'] != '') {
	    $g_IgnoredExt = explode(',', $defaults['skip_ext']);
	    for ($i = 0; $i < count($g_IgnoredExt); $i++) {
                $g_IgnoredExt[$i] = trim($g_IgnoredExt[$i]);
             }

	    QCR_Debug('Skip files with extensions: ' . implode(',', $g_IgnoredExt));
	    stdOut('Skip extensions: ' . implode(',', $g_IgnoredExt));
         } 

// scan single file
if (defined('SCAN_FILE')) {
   if (file_exists(SCAN_FILE) && is_file(SCAN_FILE) && is_readable(SCAN_FILE)) {
       stdOut("Start scanning file '" . SCAN_FILE . "'.");
       QCR_ScanFile(SCAN_FILE); 
   } else { 
       stdOut("Error:" . SCAN_FILE . " either is not a file or readable");
   }
} else {
	if (isset($_GET['2check'])) {
		$options['with-2check'] = 1;
	}
   
   // scan list of files from file
   if (!(ICHECK || IMAKE) && isset($options['with-2check']) && file_exists(DOUBLECHECK_FILE)) {
      stdOut("Start scanning the list from '" . DOUBLECHECK_FILE . "'.\n");
      $lines = file(DOUBLECHECK_FILE);
      for ($i = 0, $size = count($lines); $i < $size; $i++) {
         $lines[$i] = trim($lines[$i]);
         if (empty($lines[$i])) unset($lines[$i]);
      }
      /* skip first line with <?php die("Forbidden"); ?> */
      unset($lines[0]);
      $g_FoundTotalFiles = count($lines);
      $i = 1;
      foreach ($lines as $l_FN) {
         is_dir($l_FN) && $g_TotalFolder++;
         printProgress( $i++, $l_FN);
         $BOOL_RESULT = true; // display disable
         is_file($l_FN) && QCR_ScanFile($l_FN, $i);
         $BOOL_RESULT = false; // display enable
      }

      $g_FoundTotalDirs = $g_TotalFolder;
      $g_FoundTotalFiles = $g_TotalFiles;

   } else {
      // scan whole file system
      stdOut("Start scanning '" . ROOT_PATH . "'.\n");
      
      file_exists(QUEUE_FILENAME) && unlink(QUEUE_FILENAME);
      if (ICHECK || IMAKE) {
      // INTEGRITY CHECK
        IMAKE and unlink(INTEGRITY_DB_FILE);
        ICHECK and load_integrity_db();
        QCR_IntegrityCheck(ROOT_PATH);
        stdOut("Found $g_FoundTotalFiles files in $g_FoundTotalDirs directories.");
        if (IMAKE) exit(0);
        if (ICHECK) {
            $i = $g_Counter;
            $g_CRC = 0;
            $changes = array();
            $ref =& $g_IntegrityDB;
            foreach ($g_IntegrityDB as $l_FileName => $type) {
                unset($g_IntegrityDB[$l_FileName]);
                $l_Ext2 = substr(strstr(basename($l_FileName), '.'), 1);
                if (in_array(strtolower($l_Ext2), $g_IgnoredExt)) {
                    continue;
                }
                for ($dr = 0; $dr < count($g_DirIgnoreList); $dr++) {
                    if (($g_DirIgnoreList[$dr] != '') && preg_match('#' . $g_DirIgnoreList[$dr] . '#', $l_FileName, $l_Found)) {
                        continue 2;
                    }
                }
                $type = in_array($type, array('added', 'modified')) ? $type : 'deleted';
                $type .= substr($l_FileName, -1) == '/' ? 'Dirs' : 'Files';
                $changes[$type][] = ++$i;
                AddResult($l_FileName, $i);
            }
            $g_FoundTotalFiles = count($changes['addedFiles']) + count($changes['modifiedFiles']);
            stdOut("Found changes " . count($changes['modifiedFiles']) . " files and added " . count($changes['addedFiles']) . " files.");
        }
        
      } else {
      QCR_ScanDirectories(ROOT_PATH);
      stdOut("Found $g_FoundTotalFiles files in $g_FoundTotalDirs directories.");
      }

      QCR_Debug();
      stdOut(str_repeat(' ', 160),false);
      QCR_GoScan(0);
      unlink(QUEUE_FILENAME);
      if (defined('PROGRESS_LOG_FILE') && file_exists(PROGRESS_LOG_FILE)) @unlink(PROGRESS_LOG_FILE);
   }
}

QCR_Debug();

if (true) {
   $g_HeuristicDetected = array();
   $g_Iframer = array();
   $g_Base64 = array();
}


// whitelist

$snum = 0;
$list = check_whitelist($g_Structure['crc'], $snum);

foreach (array('g_CriticalPHP', 'g_CriticalJS', 'g_Iframer', 'g_Base64', 'g_Phishing', 'g_AdwareList', 'g_Redirect') as $p) {
	if (empty($$p)) continue;
	
	$p_Fragment = $p . "Fragment";
	$p_Sig = $p . "Sig";
	if ($p == 'g_Redirect') $p_Fragment = $p . "PHPFragment";
	if ($p == 'g_Phishing') $p_Sig = $p . "SigFragment";

	$count = count($$p);
	for ($i = 0; $i < $count; $i++) {
		$id = "{${$p}[$i]}";
		if (in_array($g_Structure['crc'][$id], $list)) {
			unset($GLOBALS[$p][$i]);
			unset($GLOBALS[$p_Sig][$i]);
			unset($GLOBALS[$p_Fragment][$i]);
		}
	}

	$$p = array_values($$p);
	$$p_Fragment = array_values($$p_Fragment);
	if (!empty($$p_Sig)) $$p_Sig = array_values($$p_Sig);
}


////////////////////////////////////////////////////////////////////////////
if (AI_HOSTER) {
   $g_IframerFragment = array();
   $g_Iframer = array();
   $g_Redirect = array();
   $g_Doorway = array();
   $g_EmptyLink = array();
   $g_HeuristicType = array();
   $g_HeuristicDetected = array();
   $g_WarningPHP = array();
   $g_AdwareList = array();
   $g_Phishing = array(); 
   $g_PHPCodeInside = array();
   $g_PHPCodeInsideFragment = array();
   $g_NotRead = array();
   $g_WarningPHPFragment = array();
   $g_WarningPHPSig = array();
   $g_BigFiles = array();
   $g_RedirectPHPFragment = array();
   $g_EmptyLinkSrc = array();
   $g_Base64Fragment = array();
   $g_UnixExec = array();
   $g_PhishingSigFragment = array();
   $g_PhishingFragment = array();
   $g_PhishingSig = array();
   $g_IframerFragment = array();
   $g_CMS = array();
   $g_AdwareListFragment = array(); 
   $g_Vulnerable = array();
}


 if (BOOL_RESULT && (!defined('NEED_REPORT'))) {
  if ((count($g_CriticalPHP) > 0) OR (count($g_CriticalJS) > 0) OR (count($g_Base64) > 0) OR  (count($g_Iframer) > 0) OR  (count($g_UnixExec) > 0))
  {
  echo "1\n";
  exit(0);
  }
 }
////////////////////////////////////////////////////////////////////////////
$l_Template = str_replace("@@SERVICE_INFO@@", htmlspecialchars("[" . $int_enc . "][" . $snum . "]"), $l_Template);

$l_Template = str_replace("@@PATH_URL@@", (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : $g_AddPrefix . str_replace($g_NoPrefix, '', addSlash(ROOT_PATH))), $l_Template);

$time_taken = seconds2Human(microtime(true) - START_TIME);

$l_Template = str_replace("@@SCANNED@@", sprintf(AI_STR_013, $g_TotalFolder, $g_TotalFiles), $l_Template);

$l_ShowOffer = false;

stdOut("\nBuilding report [ mode = " . AI_EXPERT . " ]\n");

stdOut("\nLoaded signatures: " . count($g_FlexDBShe) . " / " . count($g_JSVirSig) . "\n");

////////////////////////////////////////////////////////////////////////////
// save 
if (!(ICHECK || IMAKE))
if (isset($options['with-2check']) || isset($options['quarantine']))
if ((count($g_CriticalPHP) > 0) OR (count($g_CriticalJS) > 0) OR (count($g_Base64) > 0) OR 
   (count($g_Iframer) > 0) OR  (count($g_UnixExec))) 
{
  if (!file_exists(DOUBLECHECK_FILE)) {	  
      if ($l_FH = fopen(DOUBLECHECK_FILE, 'w')) {
         fputs($l_FH, '<?php die("Forbidden"); ?>' . "\n");

         $l_CurrPath = dirname(__FILE__);
		 
		 if (!isset($g_CriticalPHP)) { $g_CriticalPHP = array(); }
		 if (!isset($g_CriticalJS)) { $g_CriticalJS = array(); }
		 if (!isset($g_Iframer)) { $g_Iframer = array(); }
		 if (!isset($g_Base64)) { $g_Base64 = array(); }
		 if (!isset($g_Phishing)) { $g_Phishing = array(); }
		 if (!isset($g_AdwareList)) { $g_AdwareList = array(); }
		 if (!isset($g_Redirect)) { $g_Redirect = array(); }
		 
         $tmpIndex = array_merge($g_CriticalPHP, $g_CriticalJS, $g_Phishing, $g_Base64, $g_Iframer, $g_AdwareList, $g_Redirect);
         $tmpIndex = array_values(array_unique($tmpIndex));

         for ($i = 0; $i < count($tmpIndex); $i++) {
             $tmpIndex[$i] = str_replace($l_CurrPath, '.', $g_Structure['n'][$tmpIndex[$i]]);
         }

         for ($i = 0; $i < count($g_UnixExec); $i++) {
             $tmpIndex[] = str_replace($l_CurrPath, '.', $g_UnixExec[$i]);
         }

         $tmpIndex = array_values(array_unique($tmpIndex));

         for ($i = 0; $i < count($tmpIndex); $i++) {
             fputs($l_FH, $tmpIndex[$i] . "\n");
         }

         fclose($l_FH);
      } else {
         stdOut("Error! Cannot create " . DOUBLECHECK_FILE);
      }      
  } else {
      stdOut(DOUBLECHECK_FILE . ' already exists.');
      if (AI_STR_044 != '') $l_Result .= '<div class="rep">' . AI_STR_044 . '</div>';
  }
 
}

////////////////////////////////////////////////////////////////////////////

$l_Summary = '<div class="title">' . AI_STR_074 . '</div>';
$l_Summary .= '<table cellspacing=0 border=0>';

if (count($g_Redirect) > 0) {
   $l_Summary .= makeSummary(AI_STR_059, count($g_Redirect), "crit");
}

if (count($g_CriticalPHP) > 0) {
   $l_Summary .= makeSummary(AI_STR_060, count($g_CriticalPHP), "crit");
}

if (count($g_CriticalJS) > 0) {
   $l_Summary .= makeSummary(AI_STR_061, count($g_CriticalJS), "crit");
}

if (count($g_Phishing) > 0) {
   $l_Summary .= makeSummary(AI_STR_062, count($g_Phishing), "crit");
}

if (count($g_UnixExec) > 0) {
   $l_Summary .= makeSummary(AI_STR_063, count($g_UnixExec), (AI_EXPERT > 1 ? 'crit' : 'warn'));
}

if (count($g_Iframer) > 0) {
   $l_Summary .= makeSummary(AI_STR_064, count($g_Iframer), "crit");
}

if (count($g_NotRead) > 0) {
   $l_Summary .= makeSummary(AI_STR_066, count($g_NotRead), "crit");
}

if (count($g_Base64) > 0) {
   $l_Summary .= makeSummary(AI_STR_067, count($g_Base64), (AI_EXPERT > 1 ? 'crit' : 'warn'));
}

if (count($g_BigFiles) > 0) {
   $l_Summary .= makeSummary(AI_STR_065, count($g_BigFiles), "warn");
}

if (count($g_HeuristicDetected) > 0) {
   $l_Summary .= makeSummary(AI_STR_068, count($g_HeuristicDetected), "warn");
}

if (count($g_SymLinks) > 0) {
   $l_Summary .= makeSummary(AI_STR_069, count($g_SymLinks), "warn");
}

if (count($g_HiddenFiles) > 0) {
   $l_Summary .= makeSummary(AI_STR_070, count($g_HiddenFiles), "warn");
}

if (count($g_AdwareList) > 0) {
   $l_Summary .= makeSummary(AI_STR_072, count($g_AdwareList), "warn");
}

if (count($g_EmptyLink) > 0) {
   $l_Summary .= makeSummary(AI_STR_073, count($g_EmptyLink), "warn");
}

 $l_Summary .= "</table>";

$l_ArraySummary = array();
$l_ArraySummary["redirect"] = count($g_Redirect);
$l_ArraySummary["critical_php"] = count($g_CriticalPHP);
$l_ArraySummary["critical_js"] = count($g_CriticalJS);
$l_ArraySummary["phishing"] = count($g_Phishing);
$l_ArraySummary["unix_exec"] = count($g_UnixExec);
$l_ArraySummary["iframes"] = count($g_Iframer);
$l_ArraySummary["not_read"] = count($g_NotRead);
$l_ArraySummary["base64"] = count($g_Base64);
$l_ArraySummary["heuristics"] = count($g_HeuristicDetected);
$l_ArraySummary["symlinks"] = count($g_SymLinks);
$l_ArraySummary["big_files_skipped"] = count($g_BigFiles);

 if (function_exists('json_encode')) { $l_Summary .= "<!--[json]" . json_encode($l_ArraySummary) . "[/json]-->"; }

 $l_Summary .= "<div class=details style=\"margin: 20px 20px 20px 0\">" . AI_STR_080 . "</div>\n";

 $l_Template = str_replace("@@SUMMARY@@", $l_Summary, $l_Template);


 $l_Result .= AI_STR_015;
 
 $l_Template = str_replace("@@VERSION@@", AI_VERSION, $l_Template);
 
////////////////////////////////////////////////////////////////////////////



if (function_exists("gethostname") && is_callable("gethostname")) {
  $l_HostName = gethostname();
} else {
  $l_HostName = '???';
}

$l_PlainResult = "# Malware list detected by AI-Bolit (https://revisium.com/ai/) on " . date("d/m/Y H:i:s", time()) . " " . $l_HostName .  "\n\n";

$l_RawReport = array();

if (!AI_HOSTER) {
   stdOut("Building list of vulnerable scripts " . count($g_Vulnerable));

   if (count($g_Vulnerable) > 0) {
       $l_Result .= '<div class="note_vir">' . AI_STR_081 . ' (' . count($g_Vulnerable) . ')</div><div class="crit">';
    	foreach ($g_Vulnerable as $l_Item) {
   	    $l_Result .= '<li>' . makeSafeFn($g_Structure['n'][$l_Item['ndx']], true) . ' - ' . $l_Item['id'] . '</li>';
               $l_PlainResult .= '[VULNERABILITY] ' . replacePathArray($g_Structure['n'][$l_Item['ndx']]) . ' - ' . $l_Item['id'] . "\n";
    	}
   	
     $l_Result .= '</div><p>' . PHP_EOL;
     $l_PlainResult .= "\n";
   }
}


stdOut("Building list of shells " . count($g_CriticalPHP));

$l_RawReport['vulners'] = getRawJsonVuln($g_Vulnerable);

if (count($g_CriticalPHP) > 0) {
  $g_CriticalPHP = array_slice($g_CriticalPHP, 0, 15000);
  $l_RawReport['php_malware'] = getRawJson($g_CriticalPHP, $g_CriticalPHPFragment, $g_CriticalPHPSig);
  $l_Result .= '<div class="note_vir">' . AI_STR_016 . ' (' . count($g_CriticalPHP) . ')</div><div class="crit">';
  $l_Result .= printList($g_CriticalPHP, $g_CriticalPHPFragment, true, $g_CriticalPHPSig, 'table_crit');
  $l_PlainResult .= '[SERVER MALWARE]' . "\n" . printPlainList($g_CriticalPHP, $g_CriticalPHPFragment, true, $g_CriticalPHPSig, 'table_crit') . "\n";
  $l_Result .= '</div>' . PHP_EOL;

  $l_ShowOffer = true;
} else {
  $l_Result .= '<div class="ok"><b>' . AI_STR_017. '</b></div>';
}

stdOut("Building list of js " . count($g_CriticalJS));

if (count($g_CriticalJS) > 0) {
  $g_CriticalJS = array_slice($g_CriticalJS, 0, 15000);
  $l_RawReport['js_malware'] = getRawJson($g_CriticalJS, $g_CriticalJSFragment, $g_CriticalJSSig);
  $l_Result .= '<div class="note_vir">' . AI_STR_018 . ' (' . count($g_CriticalJS) . ')</div><div class="crit">';
  $l_Result .= printList($g_CriticalJS, $g_CriticalJSFragment, true, $g_CriticalJSSig, 'table_vir');
  $l_PlainResult .= '[CLIENT MALWARE / JS]'  . "\n" . printPlainList($g_CriticalJS, $g_CriticalJSFragment, true, $g_CriticalJSSig, 'table_vir') . "\n";
  $l_Result .= "</div>" . PHP_EOL;

  $l_ShowOffer = true;
}

if (!AI_HOSTER) {
   stdOut("Building phishing pages " . count($g_Phishing));

   if (count($g_Phishing) > 0) {
     $l_RawReport['phishing'] = getRawJson($g_Phishing, $g_PhishingFragment, $g_PhishingSigFragment);
     $l_Result .= '<div class="note_vir">' . AI_STR_058 . ' (' . count($g_Phishing) . ')</div><div class="crit">';
     $l_Result .= printList($g_Phishing, $g_PhishingFragment, true, $g_PhishingSigFragment, 'table_vir');
     $l_PlainResult .= '[PHISHING]'  . "\n" . printPlainList($g_Phishing, $g_PhishingFragment, true, $g_PhishingSigFragment, 'table_vir') . "\n";
     $l_Result .= "</div>". PHP_EOL;

     $l_ShowOffer = true;
   }

   stdOut("Building list of iframes " . count($g_Iframer));

   if (count($g_Iframer) > 0) {
     $l_RawReport['iframer'] = getRawJson($g_Iframer, $g_IframerFragment);
     $l_ShowOffer = true;
     $l_Result .= '<div class="note_vir">' . AI_STR_021 . ' (' . count($g_Iframer) . ')</div><div class="crit">';
     $l_Result .= printList($g_Iframer, $g_IframerFragment, true);
     $l_Result .= "</div>" . PHP_EOL;

   }

   stdOut("Building list of base64s " . count($g_Base64));

   if (count($g_Base64) > 0) {
     $l_RawReport['warn_enc'] = getRawJson($g_Base64, $g_Base64Fragment);
     if (AI_EXPERT > 1) $l_ShowOffer = true;
     
     $l_Result .= '<div class="note_' . (AI_EXPERT > 1 ? 'vir' : 'warn') . '">' . AI_STR_020 . ' (' . count($g_Base64) . ')</div><div class="' . (AI_EXPERT > 1 ? 'crit' : 'warn') . '">';
     $l_Result .= printList($g_Base64, $g_Base64Fragment, true);
     $l_PlainResult .= '[ENCODED / SUSP_EXT]' . "\n" . printPlainList($g_Base64, $g_Base64Fragment, true) . "\n";
     $l_Result .= "</div>" . PHP_EOL;

   }

   stdOut("Building list of redirects " . count($g_Redirect));
   if (count($g_Redirect) > 0) {
     $l_RawReport['redirect'] = getRawJson($g_Redirect, $g_RedirectPHPFragment);
     $l_ShowOffer = true;
     $l_Result .= '<div class="note_vir">' . AI_STR_027 . ' (' . count($g_Redirect) . ')</div><div class="crit">';
     $l_Result .= printList($g_Redirect, $g_RedirectPHPFragment, true);
     $l_Result .= "</div>" . PHP_EOL;
   }


   stdOut("Building list of unread files " . count($g_NotRead));

   if (count($g_NotRead) > 0) {
     $g_NotRead = array_slice($g_NotRead, 0, AIBOLIT_MAX_NUMBER);
     $l_RawReport['not_read'] = $g_NotRead;
     $l_Result .= '<div class="note_vir">' . AI_STR_030 . ' (' . count($g_NotRead) . ')</div><div class="crit">';
     $l_Result .= printList($g_NotRead);
     $l_Result .= "</div><div class=\"spacer\"></div>" . PHP_EOL;
     $l_PlainResult .= '[SCAN ERROR / SKIPPED]' . "\n" . printPlainList($g_NotRead) . "\n\n";
   }

   stdOut("Building list of symlinks " . count($g_SymLinks));

   if (count($g_SymLinks) > 0) {
     $g_SymLinks = array_slice($g_SymLinks, 0, AIBOLIT_MAX_NUMBER);
     $l_RawReport['sym_links'] = $g_SymLinks;
     $l_Result .= '<div class="note_vir">' . AI_STR_022 . ' (' . count($g_SymLinks) . ')</div><div class="crit">';
     $l_Result .= nl2br(makeSafeFn(implode("\n", $g_SymLinks), true));
     $l_Result .= "</div><div class=\"spacer\"></div>";
   }

   stdOut("Building list of unix executables and odd scripts " . count($g_UnixExec));

   if (count($g_UnixExec) > 0) {
     $g_UnixExec = array_slice($g_UnixExec, 0, AIBOLIT_MAX_NUMBER);
     $l_RawReport['unix_exec'] = $g_UnixExec;
     $l_Result .= '<div class="note_' . (AI_EXPERT > 1 ? 'vir' : 'warn') . '">' . AI_STR_019 . ' (' . count($g_UnixExec) . ')</div><div class="' . (AI_EXPERT > 1 ? 'crit' : 'warn') . '">';
     $l_Result .= nl2br(makeSafeFn(implode("\n", $g_UnixExec), true));
     $l_PlainResult .= '[UNIX EXEC]' . "\n" . implode("\n", replacePathArray($g_UnixExec)) . "\n\n";
     $l_Result .= "</div>" . PHP_EOL;

     if (AI_EXPERT > 1) $l_ShowOffer = true;
   }
}
////////////////////////////////////
if (!AI_HOSTER) {
   $l_WarningsNum = count($g_HeuristicDetected) + count($g_HiddenFiles) + count($g_BigFiles) + count($g_PHPCodeInside) + count($g_AdwareList) + count($g_EmptyLink) + count($g_Doorway) + (count($g_WarningPHP[0]) + count($g_WarningPHP[1]) + count($g_SkippedFolders));

   if ($l_WarningsNum > 0) {
   	$l_Result .= "<div style=\"margin-top: 20px\" class=\"title\">" . AI_STR_026 . "</div>";
   }

   stdOut("Building list of links/adware " . count($g_AdwareList));

   if (count($g_AdwareList) > 0) {
     $l_RawReport['adware'] = getRawJson($g_AdwareList, $g_AdwareListFragment);
     $l_Result .= '<div class="note_warn">' . AI_STR_029 . '</div><div class="warn">';
     $l_Result .= printList($g_AdwareList, $g_AdwareListFragment, true);
     $l_PlainResult .= '[ADWARE]' . "\n" . printPlainList($g_AdwareList, $g_AdwareListFragment, true) . "\n";
     $l_Result .= "</div>" . PHP_EOL;

   }

   stdOut("Building list of heuristics " . count($g_HeuristicDetected));

   if (count($g_HeuristicDetected) > 0) {
     $l_RawReport['heuristic'] = $g_HeuristicDetected;
     $l_Result .= '<div class="note_warn">' . AI_STR_052 . ' (' . count($g_HeuristicDetected) . ')</div><div class="warn">';
     for ($i = 0; $i < count($g_HeuristicDetected); $i++) {
   	   $l_Result .= '<li>' . makeSafeFn($g_Structure['n'][$g_HeuristicDetected[$i]], true) . ' (' . get_descr_heur($g_HeuristicType[$i]) . ')</li>';
     }
     
     $l_Result .= '</ul></div><div class=\"spacer\"></div>' . PHP_EOL;
   }

   stdOut("Building list of hidden files " . count($g_HiddenFiles));
   if (count($g_HiddenFiles) > 0) {
     $g_HiddenFiles = array_slice($g_HiddenFiles, 0, AIBOLIT_MAX_NUMBER);
     $l_RawReport['hidden'] = $g_HiddenFiles;
     $l_Result .= '<div class="note_warn">' . AI_STR_023 . ' (' . count($g_HiddenFiles) . ')</div><div class="warn">';
     $l_Result .= nl2br(makeSafeFn(implode("\n", $g_HiddenFiles), true));
     $l_Result .= "</div><div class=\"spacer\"></div>" . PHP_EOL;
     $l_PlainResult .= '[HIDDEN]' . "\n" . implode("\n", replacePathArray($g_HiddenFiles)) . "\n\n";
   }

   stdOut("Building list of bigfiles " . count($g_BigFiles));
   $max_size_to_scan = getBytes(MAX_SIZE_TO_SCAN);
   $max_size_to_scan = $max_size_to_scan > 0 ? $max_size_to_scan : getBytes('1m');

   if (count($g_BigFiles) > 0) {
     $g_BigFiles = array_slice($g_BigFiles, 0, AIBOLIT_MAX_NUMBER);
     $l_RawReport['big_files'] = getRawJson($g_BigFiles);
     $l_Result .= "<div class=\"note_warn\">" . sprintf(AI_STR_038, bytes2Human($max_size_to_scan)) . '</div><div class="warn">';
     $l_Result .= printList($g_BigFiles);
     $l_Result .= "</div>";
     $l_PlainResult .= '[BIG FILES / SKIPPED]' . "\n" . printPlainList($g_BigFiles) . "\n\n";
   } 

   stdOut("Building list of php inj " . count($g_PHPCodeInside));

   if ((count($g_PHPCodeInside) > 0) && (($defaults['report_mask'] & REPORT_MASK_PHPSIGN) == REPORT_MASK_PHPSIGN)) {
     $l_Result .= '<div class="note_warn">' . AI_STR_028 . '</div><div class="warn">';
     $l_Result .= printList($g_PHPCodeInside, $g_PHPCodeInsideFragment, true);
     $l_Result .= "</div>" . PHP_EOL;

   }

   stdOut("Building list of empty links " . count($g_EmptyLink));
   if (count($g_EmptyLink) > 0) {
     $g_EmptyLink = array_slice($g_EmptyLink, 0, AIBOLIT_MAX_NUMBER);
     $l_Result .= '<div class="note_warn">' . AI_STR_031 . '</div><div class="warn">';
     $l_Result .= printList($g_EmptyLink, '', true);

     $l_Result .= AI_STR_032 . '<br/>';
     
     if (count($g_EmptyLink) == MAX_EXT_LINKS) {
         $l_Result .= '(' . AI_STR_033 . MAX_EXT_LINKS . ')<br/>';
       }
      
     for ($i = 0; $i < count($g_EmptyLink); $i++) {
   	$l_Idx = $g_EmptyLink[$i];
       for ($j = 0; $j < count($g_EmptyLinkSrc[$l_Idx]); $j++) {
         $l_Result .= '<span class="details">' . makeSafeFn($g_Structure['n'][$g_EmptyLink[$i]], true) . ' &rarr; ' . htmlspecialchars($g_EmptyLinkSrc[$l_Idx][$j]) . '</span><br/>';
   	}
     }

     $l_Result .= "</div>";

   }

   stdOut("Building list of doorways " . count($g_Doorway));

   if ((count($g_Doorway) > 0) && (($defaults['report_mask'] & REPORT_MASK_DOORWAYS) == REPORT_MASK_DOORWAYS)) {
     $g_Doorway = array_slice($g_Doorway, 0, AIBOLIT_MAX_NUMBER);
     $l_RawReport['doorway'] = getRawJson($g_Doorway);
     $l_Result .= '<div class="note_warn">' . AI_STR_034 . '</div><div class="warn">';
     $l_Result .= printList($g_Doorway);
     $l_Result .= "</div>" . PHP_EOL;

   }

   stdOut("Building list of php warnings " . (count($g_WarningPHP[0]) + count($g_WarningPHP[1])));

   if (($defaults['report_mask'] & REPORT_MASK_SUSP) == REPORT_MASK_SUSP) {
      if ((count($g_WarningPHP[0]) + count($g_WarningPHP[1])) > 0) {
        $g_WarningPHP[0] = array_slice($g_WarningPHP[0], 0, AIBOLIT_MAX_NUMBER);
        $g_WarningPHP[1] = array_slice($g_WarningPHP[1], 0, AIBOLIT_MAX_NUMBER);
        $l_Result .= '<div class="note_warn">' . AI_STR_035 . '</div><div class="warn">';

        for ($i = 0; $i < count($g_WarningPHP); $i++) {
            if (count($g_WarningPHP[$i]) > 0) 
               $l_Result .= printList($g_WarningPHP[$i], $g_WarningPHPFragment[$i], true, $g_WarningPHPSig, 'table_warn' . $i);
        }                                                                                                                    
        $l_Result .= "</div>" . PHP_EOL;

      } 
   }

   stdOut("Building list of skipped dirs " . count($g_SkippedFolders));
   if (count($g_SkippedFolders) > 0) {
        $l_Result .= '<div class="note_warn">' . AI_STR_036 . '</div><div class="warn">';
        $l_Result .= nl2br(makeSafeFn(implode("\n", $g_SkippedFolders), true));   
        $l_Result .= "</div>" . PHP_EOL;
    }

    if (count($g_CMS) > 0) {
         $l_RawReport['cms'] = $g_CMS;
         $l_Result .= "<div class=\"note_warn\">" . AI_STR_037 . "<br/>";
         $l_Result .= nl2br(makeSafeFn(implode("\n", $g_CMS)));
         $l_Result .= "</div>";
    }
}

if (ICHECK) {
	$l_Result .= "<div style=\"margin-top: 20px\" class=\"title\">" . AI_STR_087 . "</div>";
	
    stdOut("Building list of added files " . count($changes['addedFiles']));
    if (count($changes['addedFiles']) > 0) {
      $l_Result .= '<div class="note_int">' . AI_STR_082 . ' (' . count($changes['addedFiles']) . ')</div><div class="intitem">';
      $l_Result .= printList($changes['addedFiles']);
      $l_Result .= "</div>" . PHP_EOL;
    }

    stdOut("Building list of modified files " . count($changes['modifiedFiles']));
    if (count($changes['modifiedFiles']) > 0) {
      $l_Result .= '<div class="note_int">' . AI_STR_083 . ' (' . count($changes['modifiedFiles']) . ')</div><div class="intitem">';
      $l_Result .= printList($changes['modifiedFiles']);
      $l_Result .= "</div>" . PHP_EOL;
    }

    stdOut("Building list of deleted files " . count($changes['deletedFiles']));
    if (count($changes['deletedFiles']) > 0) {
      $l_Result .= '<div class="note_int">' . AI_STR_084 . ' (' . count($changes['deletedFiles']) . ')</div><div class="intitem">';
      $l_Result .= printList($changes['deletedFiles']);
      $l_Result .= "</div>" . PHP_EOL;
    }

    stdOut("Building list of added dirs " . count($changes['addedDirs']));
    if (count($changes['addedDirs']) > 0) {
      $l_Result .= '<div class="note_int">' . AI_STR_085 . ' (' . count($changes['addedDirs']) . ')</div><div class="intitem">';
      $l_Result .= printList($changes['addedDirs']);
      $l_Result .= "</div>" . PHP_EOL;
    }

    stdOut("Building list of deleted dirs " . count($changes['deletedDirs']));
    if (count($changes['deletedDirs']) > 0) {
      $l_Result .= '<div class="note_int">' . AI_STR_086 . ' (' . count($changes['deletedDirs']) . ')</div><div class="intitem">';
      $l_Result .= printList($changes['deletedDirs']);
      $l_Result .= "</div>" . PHP_EOL;
    }
}

if (!isCli()) {
   $l_Result .= QCR_ExtractInfo($l_PhpInfoBody[1]);
}


if (function_exists('memory_get_peak_usage')) {
  $l_Template = str_replace("@@MEMORY@@", AI_STR_043 . bytes2Human(memory_get_peak_usage()), $l_Template);
}

$l_Template = str_replace('@@WARN_QUICK@@', ((SCAN_ALL_FILES || $g_SpecificExt) ? '' : AI_STR_045), $l_Template);

if ($l_ShowOffer) {
	$l_Template = str_replace('@@OFFER@@', $l_Offer, $l_Template);
} else {
	$l_Template = str_replace('@@OFFER@@', AI_STR_002, $l_Template);
}

$l_Template = str_replace('@@CAUTION@@', AI_STR_003, $l_Template);

$l_Template = str_replace('@@CREDITS@@', AI_STR_075, $l_Template);

$l_Template = str_replace('@@FOOTER@@', AI_STR_076, $l_Template);

$l_Template = str_replace('@@STAT@@', sprintf(AI_STR_012, $time_taken, date('d-m-Y в H:i:s', floor(START_TIME)) , date('d-m-Y в H:i:s')), $l_Template);

////////////////////////////////////////////////////////////////////////////
$l_Template = str_replace("@@MAIN_CONTENT@@", $l_Result, $l_Template);

if (!isCli())
{
    echo $l_Template;
    exit;
}

if (!defined('REPORT') OR REPORT === '')
{
	die2('Report not written.');
}
 
// write plain text result
if (PLAIN_FILE != '') {
	
    $l_PlainResult = preg_replace('|__AI_LINE1__|smi', '[', $l_PlainResult);
    $l_PlainResult = preg_replace('|__AI_LINE2__|smi', '] ', $l_PlainResult);
    $l_PlainResult = preg_replace('|__AI_MARKER__|smi', ' %> ', $l_PlainResult);

   if ($l_FH = fopen(PLAIN_FILE, "w")) {
      fputs($l_FH, $l_PlainResult);
      fclose($l_FH);
   }
}

// write json result
if (defined('JSON_FILE')) {	
   if ($l_FH = fopen(JSON_FILE, "w")) {
      fputs($l_FH, json_encode($l_RawReport));
      fclose($l_FH);
   }
}

// write serialized result
if (defined('PHP_FILE')) {	
   if ($l_FH = fopen(PHP_FILE, "w")) {
      fputs($l_FH, serialize($l_RawReport));
      fclose($l_FH);
   }
}

$emails = getEmails(REPORT);

if (!$emails) {
	if ($l_FH = fopen($file, "w")) {
	   fputs($l_FH, $l_Template);
	   fclose($l_FH);
	   stdOut("\nReport written to '$file'.");
	} else {
		stdOut("\nCannot create '$file'.");
	}
}	else	{
		$headers = array(
			'MIME-Version: 1.0',
			'Content-type: text/html; charset=UTF-8',
			'From: ' . ($defaults['email_from'] ? $defaults['email_from'] : 'AI-Bolit@myhost')
		);

		for ($i = 0, $size = sizeof($emails); $i < $size; $i++)
		{
			mail($emails[$i], 'AI-Bolit Report ' . date("d/m/Y H:i", time()), $l_Result, implode("\r\n", $headers));
		}

		stdOut("\nReport sended to " . implode(', ', $emails));
}


$time_taken = microtime(true) - START_TIME;
$time_taken = number_format($time_taken, 5);

stdOut("Scanning complete! Time taken: " . seconds2Human($time_taken));

stdOut("\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
stdOut("Attention! DO NOT LEAVE either ai-bolit.php or AI-BOLIT-REPORT-<xxxx>-<yy>.html \nfile on server. COPY it locally then REMOVE from server. ");
stdOut("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");

if (isset($options['quarantine'])) {
	Quarantine();
}

if (isset($options['cmd'])) {
	stdOut("Run \"{$options['cmd']}\" ");
	system($options['cmd']);
}

QCR_Debug();

# exit with code

$l_EC1 = count($g_CriticalPHP);
$l_EC2 = count($g_CriticalJS) + count($g_Phishing) + count($g_WarningPHP[0]) + count($g_WarningPHP[1]);
$code = 0;

if ($l_EC1 > 0) {
	$code = 2;
} else {
	if ($l_EC2 > 0) {
		$code = 1;
	}
}

$stat = array('php_malware' => count($g_CriticalPHP), 'js_malware' => count($g_CriticalJS), 'phishing' => count($g_Phishing));

if (function_exists('aibolit_onComplete')) { aibolit_onComplete($code, $stat); }

stdOut('Exit code ' . $code);
exit($code);

############################################# END ###############################################

function Quarantine()
{
	if (!file_exists(DOUBLECHECK_FILE)) {
		return;
	}
	
	$g_QuarantinePass = 'aibolit';
	
	$archive = "AI-QUARANTINE-" .rand(100000, 999999) . ".zip";
	$infoFile = substr($archive, 0, -3) . "txt";
	$report = REPORT_PATH . DIR_SEPARATOR . REPORT_FILE;
	

	foreach (file(DOUBLECHECK_FILE) as $file) {
		$file = trim($file);
		if (!is_file($file)) continue;
	
		$lStat = stat($file);
		
		// skip files over 300KB
		if ($lStat['size'] > 300*1024) continue;

		// http://www.askapache.com/security/chmod-stat.html
		$p = $lStat['mode'];
		$perm ='-';
		$perm.=(($p&0x0100)?'r':'-').(($p&0x0080)?'w':'-');
		$perm.=(($p&0x0040)?(($p&0x0800)?'s':'x'):(($p&0x0800)?'S':'-'));
		$perm.=(($p&0x0020)?'r':'-').(($p&0x0010)?'w':'-');
		$perm.=(($p&0x0008)?(($p&0x0400)?'s':'x'):(($p&0x0400)?'S':'-'));
		$perm.=(($p&0x0004)?'r':'-').(($p&0x0002)?'w':'-');
		$perm.=(($p&0x0001)?(($p&0x0200)?'t':'x'):(($p&0x0200)?'T':'-'));
		
		$owner = (function_exists('posix_getpwuid'))? @posix_getpwuid($lStat['uid']) : array('name' => $lStat['uid']);
		$group = (function_exists('posix_getgrgid'))? @posix_getgrgid($lStat['gid']) : array('name' => $lStat['uid']);

		$inf['permission'][] = $perm;
		$inf['owner'][] = $owner['name'];
		$inf['group'][] = $group['name'];
		$inf['size'][] = $lStat['size'] > 0 ? bytes2Human($lStat['size']) : '-';
		$inf['ctime'][] = $lStat['ctime'] > 0 ? date("d/m/Y H:i:s", $lStat['ctime']) : '-';
		$inf['mtime'][] = $lStat['mtime'] > 0 ? date("d/m/Y H:i:s", $lStat['mtime']) : '-';
		$files[] = strpos($file, './') === 0 ? substr($file, 2) : $file;
	}
	
	// get config files for cleaning
	$configFilesRegex = 'config(uration|\.in[ic])?\.php$|dbconn\.php$';
	$configFiles = preg_grep("~$configFilesRegex~", $files);

	// get columns width
	$width = array();
	foreach (array_keys($inf) as $k) {
		$width[$k] = strlen($k);
		for ($i = 0; $i < count($inf[$k]); ++$i) {
			$len = strlen($inf[$k][$i]);
			if ($len > $width[$k])
				$width[$k] = $len;
		}
	}

	// headings of columns
	$info = '';
	foreach (array_keys($inf) as $k) {
		$info .= str_pad($k, $width[$k], ' ', STR_PAD_LEFT). ' ';
	}
	$info .= "name\n";
	
	for ($i = 0; $i < count($files); ++$i) {
		foreach (array_keys($inf) as $k) {
			$info .= str_pad($inf[$k][$i], $width[$k], ' ', STR_PAD_LEFT). ' ';
		}
		$info .= $files[$i]."\n";
	}
	unset($inf, $width);

	exec("zip -v 2>&1", $output,$code);

	if ($code == 0) {
		$filter = '';
		if ($configFiles && exec("grep -V 2>&1", $output, $code) && $code == 0) {
			$filter = "|grep -v -E '$configFilesRegex'";
		}

		exec("cat AI-BOLIT-DOUBLECHECK.php $filter |zip -@ --password $g_QuarantinePass $archive", $output, $code);
		if ($code == 0) {
			file_put_contents($infoFile, $info);
			$m = array();
			if (!empty($filter)) {
				foreach ($configFiles as $file) {
					$tmp = file_get_contents($file);
					// remove  passwords
					$tmp = preg_replace('~^.*?pass.*~im', '', $tmp);
					// new file name
					$file = preg_replace('~.*/~', '', $file) . '-' . rand(100000, 999999);
					file_put_contents($file, $tmp);
					$m[] = $file;
				}
			}

			exec("zip -j --password $g_QuarantinePass $archive $infoFile $report " . DOUBLECHECK_FILE . ' ' . implode(' ', $m));
			stdOut("\nCreate archive '" . realpath($archive) . "'");
			stdOut("This archive have password '$g_QuarantinePass'");
			foreach ($m as $file) unlink($file);
			unlink($infoFile);
			return;
		}
	}
	
	$zip = new ZipArchive;
	
	if ($zip->open($archive, ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE) === false) {
		stdOut("Cannot create '$archive'.");
		return;
	}

	foreach ($files as $file) {
		if (in_array($file, $configFiles)) {
			$tmp = file_get_contents($file);
			// remove  passwords
			$tmp = preg_replace('~^.*?pass.*~im', '', $tmp);
			$zip->addFromString($file, $tmp);
		} else {
			$zip->addFile($file);
		}
	}
	$zip->addFile(DOUBLECHECK_FILE, DOUBLECHECK_FILE);
	$zip->addFile($report, REPORT_FILE);
	$zip->addFromString($infoFile, $info);
	$zip->close();

	stdOut("\nCreate archive '" . realpath($archive) . "'.");
	stdOut("This archive has no password!");
}



///////////////////////////////////////////////////////////////////////////
function QCR_IntegrityCheck($l_RootDir)
{
	global $g_Structure, $g_Counter, $g_Doorway, $g_FoundTotalFiles, $g_FoundTotalDirs, 
			$defaults, $g_SkippedFolders, $g_UrlIgnoreList, $g_DirIgnoreList, $g_UnsafeDirArray, 
                        $g_UnsafeFilesFound, $g_SymLinks, $g_HiddenFiles, $g_UnixExec, $g_IgnoredExt, $g_SuspiciousFiles, $l_SkipSample;
	global $g_IntegrityDB, $g_ICheck;
	static $l_Buffer = '';
	
	$l_DirCounter = 0;
	$l_DoorwayFilesCounter = 0;
	$l_SourceDirIndex = $g_Counter - 1;
	
	QCR_Debug('Check ' . $l_RootDir);

 	if ($l_DIRH = @opendir($l_RootDir))
	{
		while (($l_FileName = readdir($l_DIRH)) !== false)
		{
			if ($l_FileName == '.' || $l_FileName == '..') continue;

			$l_FileName = $l_RootDir . DIR_SEPARATOR . $l_FileName;

			$l_Type = filetype($l_FileName);
			$l_IsDir = ($l_Type == "dir");
            if ($l_Type == "link") 
            {
				$g_SymLinks[] = $l_FileName;
                continue;
            } else 
			if ($l_Type != "file" && (!$l_IsDir)) {
				$g_UnixExec[] = $l_FileName;
				continue;
			}	
						
			$l_Ext = substr($l_FileName, strrpos($l_FileName, '.') + 1);

			$l_NeedToScan = true;
			$l_Ext2 = substr(strstr(basename($l_FileName), '.'), 1);
			if (in_array(strtolower($l_Ext2), $g_IgnoredExt)) {
                           $l_NeedToScan = false;
            		}

      			// if folder in ignore list
      			$l_Skip = false;
      			for ($dr = 0; $dr < count($g_DirIgnoreList); $dr++) {
      				if (($g_DirIgnoreList[$dr] != '') &&
      				   preg_match('#' . $g_DirIgnoreList[$dr] . '#', $l_FileName, $l_Found)) {
      				   if (!in_array($g_DirIgnoreList[$dr], $l_SkipSample)) {
                                      $l_SkipSample[] = $g_DirIgnoreList[$dr];
                                   } else {
        		             $l_Skip = true;
                                     $l_NeedToScan = false;
                                   }
      				}
      			}
      					
			if (getRelativePath($l_FileName) == "./" . INTEGRITY_DB_FILE) $l_NeedToScan = false;

			if ($l_IsDir)
			{
				// skip on ignore
				if ($l_Skip) {
				   $g_SkippedFolders[] = $l_FileName;
				   continue;
				}
				
				$l_BaseName = basename($l_FileName);

				$l_DirCounter++;

				$g_Counter++;
				$g_FoundTotalDirs++;

				QCR_IntegrityCheck($l_FileName);

			} else
			{
				if ($l_NeedToScan)
				{
					$g_FoundTotalFiles++;
					$g_Counter++;
				}
			}
			
			if (!$l_NeedToScan) continue;

			if (IMAKE) {
				write_integrity_db_file($l_FileName);
				continue;
			}

			// ICHECK
			// skip if known and not modified.
			if (icheck($l_FileName)) continue;
			
			$l_Buffer .= getRelativePath($l_FileName);
			$l_Buffer .= $l_IsDir ? DIR_SEPARATOR . "\n" : "\n";

			if (strlen($l_Buffer) > 32000)
			{
				file_put_contents(QUEUE_FILENAME, $l_Buffer, FILE_APPEND) or die2("Cannot write to file " . QUEUE_FILENAME);
				$l_Buffer = '';
			}

		}

		closedir($l_DIRH);
	}
	
	if (($l_RootDir == ROOT_PATH) && !empty($l_Buffer)) {
		file_put_contents(QUEUE_FILENAME, $l_Buffer, FILE_APPEND) or die2("Cannot write to file ".QUEUE_FILENAME);
		$l_Buffer = '';
	}

	if (($l_RootDir == ROOT_PATH)) {
		write_integrity_db_file();
	}

}


function getRelativePath($l_FileName) {
	return "./" . substr($l_FileName, strlen(ROOT_PATH) + 1) . (is_dir($l_FileName) ? DIR_SEPARATOR : '');
}
/**
 *
 * @return true if known and not modified
 */
function icheck($l_FileName) {
	global $g_IntegrityDB, $g_ICheck;
	static $l_Buffer = '';
	static $l_status = array( 'modified' => 'modified', 'added' => 'added' );
    
	$l_RelativePath = getRelativePath($l_FileName);
	$l_known = isset($g_IntegrityDB[$l_RelativePath]);

	if (is_dir($l_FileName)) {
		if ( $l_known ) {
			unset($g_IntegrityDB[$l_RelativePath]);
		} else {
			$g_IntegrityDB[$l_RelativePath] =& $l_status['added'];
		}
		return $l_known;
	}

	if ($l_known == false) {
		$g_IntegrityDB[$l_RelativePath] =& $l_status['added'];
		return false;
	}

	$hash = is_file($l_FileName) ? hash_file('sha1', $l_FileName) : '';
	
	if ($g_IntegrityDB[$l_RelativePath] != $hash) {
		$g_IntegrityDB[$l_RelativePath] =& $l_status['modified'];
		return false;
	}

	unset($g_IntegrityDB[$l_RelativePath]);
	return true;
}

function write_integrity_db_file($l_FileName = '') {
	static $l_Buffer = '';

	if (empty($l_FileName)) {
		empty($l_Buffer) or file_put_contents('compress.zlib://' . INTEGRITY_DB_FILE, $l_Buffer, FILE_APPEND) or die2("Cannot write to file " . INTEGRITY_DB_FILE);
		$l_Buffer = '';
		return;
	}

	$l_RelativePath = getRelativePath($l_FileName);
		
	$hash = is_file($l_FileName) ? hash_file('sha1', $l_FileName) : '';

	$l_Buffer .= "$l_RelativePath|$hash\n";
	
	if (strlen($l_Buffer) > 32000)
	{
		file_put_contents('compress.zlib://' . INTEGRITY_DB_FILE, $l_Buffer, FILE_APPEND) or die2("Cannot write to file " . INTEGRITY_DB_FILE);
		$l_Buffer = '';
	}
}

function load_integrity_db() {
	global $g_IntegrityDB;
	file_exists(INTEGRITY_DB_FILE) or die2('Not found ' . INTEGRITY_DB_FILE);

	$s_file = new SplFileObject('compress.zlib://'.INTEGRITY_DB_FILE);
	$s_file->setFlags(SplFileObject::READ_AHEAD | SplFileObject::SKIP_EMPTY | SplFileObject::DROP_NEW_LINE);

	foreach ($s_file as $line) {
		$i = strrpos($line, '|');
		if (!$i) continue;
		$g_IntegrityDB[substr($line, 0, $i)] = substr($line, $i+1);
	}

	$s_file = null;
}


function OptimizeSignatures()
{
	global $g_DBShe, $g_FlexDBShe, $gX_FlexDBShe, $gXX_FlexDBShe;
	global $g_JSVirSig, $gX_JSVirSig;
	global $g_AdwareSig;
	global $g_PhishingSig;
	global $g_ExceptFlex, $g_SusDBPrio, $g_SusDB;

	(AI_EXPERT == 2) && ($g_FlexDBShe = array_merge($g_FlexDBShe, $gX_FlexDBShe, $gXX_FlexDBShe));
	(AI_EXPERT == 1) && ($g_FlexDBShe = array_merge($g_FlexDBShe, $gX_FlexDBShe));
	$gX_FlexDBShe = $gXX_FlexDBShe = array();

	(AI_EXPERT == 2) && ($g_JSVirSig = array_merge($g_JSVirSig, $gX_JSVirSig));
	$gX_JSVirSig = array();

	$count = count($g_FlexDBShe);

	for ($i = 0; $i < $count; $i++) {
		if ($g_FlexDBShe[$i] == '[a-zA-Z0-9_]+?\(\s*[a-zA-Z0-9_]+?=\s*\)') $g_FlexDBShe[$i] = '\((?<=[a-zA-Z0-9_].)\s*[a-zA-Z0-9_]++=\s*\)';
		if ($g_FlexDBShe[$i] == '([^\?\s])\({0,1}\.[\+\*]\){0,1}\2[a-z]*e') $g_FlexDBShe[$i] = '(?J)\.[+*](?<=(?<d>[^\?\s])\(..|(?<d>[^\?\s])..)\)?\g{d}[a-z]*e';
		if ($g_FlexDBShe[$i] == '$[a-zA-Z0-9_]\{\d+\}\s*\.$[a-zA-Z0-9_]\{\d+\}\s*\.$[a-zA-Z0-9_]\{\d+\}\s*\.') $g_FlexDBShe[$i] = '\$[a-zA-Z0-9_]\{\d+\}\s*\.\$[a-zA-Z0-9_]\{\d+\}\s*\.\$[a-zA-Z0-9_]\{\d+\}\s*\.';

		$g_FlexDBShe[$i] = str_replace('http://.+?/.+?\.php\?a', 'http://[^?\s]++(?<=\.php)\?a', $g_FlexDBShe[$i]);
		$g_FlexDBShe[$i] = preg_replace('~\[a-zA-Z0-9_\]\+\K\?~', '+', $g_FlexDBShe[$i]);
		$g_FlexDBShe[$i] = preg_replace('~^\\\\[d]\+&@~', '&@(?<=\d..)', $g_FlexDBShe[$i]);
		$g_FlexDBShe[$i] = str_replace('\s*[\'"]{0,1}.+?[\'"]{0,1}\s*', '.+?', $g_FlexDBShe[$i]);
		$g_FlexDBShe[$i] = str_replace('[\'"]{0,1}.+?[\'"]{0,1}', '.+?', $g_FlexDBShe[$i]);

		$g_FlexDBShe[$i] = preg_replace('~^\[\'"\]\{0,1\}\.?|^@\*|^\\\\s\*~', '', $g_FlexDBShe[$i]);
		$g_FlexDBShe[$i] = preg_replace('~^\[\'"\]\{0,1\}\.?|^@\*|^\\\\s\*~', '', $g_FlexDBShe[$i]);
	}

	optSig($g_FlexDBShe);

	optSig($g_JSVirSig);
	optSig($g_AdwareSig);
	optSig($g_PhishingSig);
        optSig($g_SusDB);
        //optSig($g_SusDBPrio);
        //optSig($g_ExceptFlex);

        // convert exception rules
        $cnt = count($g_ExceptFlex);
        for ($i = 0; $i < $cnt; $i++) {                		
            $g_ExceptFlex[$i] = trim(UnwrapObfu($g_ExceptFlex[$i]));
            if (!strlen($g_ExceptFlex[$i])) unset($g_ExceptFlex[$i]);
        }

        $g_ExceptFlex = array_values($g_ExceptFlex);
}

function optSig(&$sigs)
{
	$sigs = array_unique($sigs);

	// Add SigId
	foreach ($sigs as &$s) {
		$s .= '(?<X' . myCheckSum($s) . '>)';
	}
	unset($s);
	
	$fix = array(
		'([^\?\s])\({0,1}\.[\+\*]\){0,1}\2[a-z]*e' => '(?J)\.[+*](?<=(?<d>[^\?\s])\(..|(?<d>[^\?\s])..)\)?\g{d}[a-z]*e',
		'http://.+?/.+?\.php\?a' => 'http://[^?\s]++(?<=\.php)\?a',
		'\s*[\'"]{0,1}.+?[\'"]{0,1}\s*' => '.+?',
		'[\'"]{0,1}.+?[\'"]{0,1}' => '.+?'
	);

	$sigs = str_replace(array_keys($fix), array_values($fix), $sigs);
	
	$fix = array(
		'~^\\\\[d]\+&@~' => '&@(?<=\d..)',
		'~^((\[\'"\]|\\\\s|@)(\{0,1\}\.?|[?*]))+~' => ''
	);

	$sigs = preg_replace(array_keys($fix), array_values($fix), $sigs);

	optSigCheck($sigs);

	$tmp = array();
	foreach ($sigs as $i => $s) {
		if (!preg_match('#^(?>(?!\.[*+]|\\\\\d)(?:\\\\.|\[.+?\]|.))+$#', $s)) {
			unset($sigs[$i]);
			$tmp[] = $s;
		}
	}
	
	usort($sigs, 'strcasecmp');
	$txt = implode("\n", $sigs);

	for ($i = 24; $i >= 1; ($i > 4 ) ? $i -= 4 : --$i) {
	    $txt = preg_replace_callback('#^((?>(?:\\\\.|\\[.+?\\]|[^(\n]|\((?:\\\\.|[^)(\n])++\))(?:[*?+]\+?|\{\d+(?:,\d*)?\}[+?]?|)){' . $i . ',})[^\n]*+(?:\\n\\1(?![{?*+]).+)+#im', 'optMergePrefixes', $txt);
	}

	$sigs = array_merge(explode("\n", $txt), $tmp);
	
	optSigCheck($sigs);
}

function optMergePrefixes($m)
{
	$prefix = $m[1];
	$prefix_len = strlen($prefix);

	$len = $prefix_len;
	$r = array();

	$suffixes = array();
	foreach (explode("\n", $m[0]) as $line) {
	  $s = substr($line, $prefix_len);
	  $len += strlen($s);
	  if ($len > 8000) {
	    $r[] = $prefix . '(?:' . implode('|', $suffixes) . ')';
	    $suffixes = array();
	    $len = $prefix_len + strlen($s);
	  }
	  $suffixes[] = $s;
	}

	if (!empty($suffixes)) {
	  $r[] = $prefix . '(?:' . implode('|', $suffixes) . ')';
	}
	
	return implode("\n", $r);
}

function optMergePrefixes_Old($m)
{
	$prefix = $m[1];
	$prefix_len = strlen($prefix);

	$suffixes = array();
	foreach (explode("\n", $m[0]) as $line) {
	  $suffixes[] = substr($line, $prefix_len);
	}

	return $prefix . '(?:' . implode('|', $suffixes) . ')';
}

/*
 * Checking errors in pattern
 */
function optSigCheck(&$sigs)
{
	$result = true;

	foreach ($sigs as $k => $sig) {
                if (trim($sig) == "") {
                   if (DEBUG_MODE) {
                      echo("************>>>>> EMPTY\n     pattern: " . $sig . "\n");
                   }
	           unset($sigs[$k]);
		   $result = false;
                }

		if (@preg_match('#' . $sig . '#smiS', '') === false) {
			$error = error_get_last();
                        if (DEBUG_MODE) {
			   echo("************>>>>> " . $error['message'] . "\n     pattern: " . $sig . "\n");
                        }
			unset($sigs[$k]);
			$result = false;
		}
	}
	
	return $result;
}

function _hash_($text)
{
	static $r;
	
	if (empty($r)) {
		for ($i = 0; $i < 256; $i++) {
			if ($i < 33 OR $i > 127 ) $r[chr($i)] = '';
		}
	}

	return sha1(strtr($text, $r));
}

function check_whitelist($list, &$snum) 
{
	if (empty($list)) return array();
	
	$file = dirname(__FILE__) . '/AIBOLIT-WHITELIST.db';

	$snum = max(0, @filesize($file) - 1024) / 20;
	stdOut("\nLoaded " . ceil($snum) . " known files\n");
	
	sort($list);

	$hash = reset($list);
	
	$fp = @fopen($file, 'rb');
	
	if (false === $fp) return array();
	
	$header = unpack('V256', fread($fp, 1024));
	
	$result = array();
	
	foreach ($header as $chunk_id => $chunk_size) {
		if ($chunk_size > 0) {
			$str = fread($fp, $chunk_size);
			
			do {
				$raw = pack("H*", $hash);
				$id = ord($raw[0]) + 1;
				
				if ($chunk_id == $id AND binarySearch($str, $raw)) {
					$result[] = $hash;
				}
				
			} while ($chunk_id >= $id AND $hash = next($list));
			
			if ($hash === false) break;
		}
	}
	
	fclose($fp);

	return $result;
}


function binarySearch($str, $item)
{
	$item_size = strlen($item);
	
	if ( $item_size == 0 ) return false;
	
	$first = 0;

	$last = floor(strlen($str) / $item_size);
	
	while ($first < $last) {
		$mid = $first + (($last - $first) >> 1);
		$b = substr($str, $mid * $item_size, $item_size);
		if (strcmp($item, $b) <= 0)
			$last = $mid;
		else
			$first = $mid + 1;
	}

	$b = substr($str, $last * $item_size, $item_size);
	if ($b == $item) {
		return true;
	} else {
		return false;
	}
}

function getSigId($l_Found)
{
	foreach ($l_Found as $key => &$v) {
		if (is_string($key) AND $v[1] != -1 AND strlen($key) == 9) {
			return substr($key, 1);
		}
	}
	
	return null;
}

function die2($str) {
  if (function_exists('aibolit_onFatalError')) { aibolit_onFatalError($str); }
  die($str);
}